/*
 * Decompiled with CFR 0.152.
 */
package pixelradar;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.Biome;
import pixelradar.region.BlockColours;
import pixelradar.util.Logging;
import pixelradar.util.Render;
import pixelradar.util.Texture;
import pixelradar.util.Utils;

public class BlockColourGen {
    private static int getIconMapColour(TextureAtlasSprite icon, Texture terrainTexture) {
        int iconX = Math.round((float)terrainTexture.w * Math.min(icon.func_94209_e(), icon.func_94212_f()));
        int iconY = Math.round((float)terrainTexture.h * Math.min(icon.func_94206_g(), icon.func_94210_h()));
        int iconWidth = Math.round((float)terrainTexture.w * Math.abs(icon.func_94212_f() - icon.func_94209_e()));
        int iconHeight = Math.round((float)terrainTexture.h * Math.abs(icon.func_94210_h() - icon.func_94206_g()));
        int[] pixels = new int[iconWidth * iconHeight];
        terrainTexture.getRGB(iconX, iconY, iconWidth, iconHeight, pixels, 0, iconWidth, icon);
        return Render.getAverageColourOfArray(pixels);
    }

    private static void genBiomeColours(BlockColours bc) {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            double temp = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
            double rain = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
            int grasscolor = ColorizerGrass.func_77480_a((double)temp, (double)rain);
            int foliagecolor = ColorizerFoliage.func_77470_a((double)temp, (double)rain);
            int watercolor = biome.getWaterColorMultiplier();
            bc.setBiomeData(biome.func_185359_l(), watercolor & 0xFFFFFF, grasscolor & 0xFFFFFF, foliagecolor & 0xFFFFFF);
        }
    }

    public static void genBlockColours(BlockColours bc) {
        Logging.log("generating block pixelradar.map colours from textures", new Object[0]);
        int terrainTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
        if (terrainTextureId == 0) {
            Logging.log("error: could get terrain texture ID", new Object[0]);
            return;
        }
        Texture terrainTexture = new Texture(terrainTextureId);
        float u1Last = 0.0f;
        float u2Last = 0.0f;
        float v1Last = 0.0f;
        float v2Last = 0.0f;
        int blockColourLast = 0;
        int eCount = 0;
        int bCount = 0;
        int sCount = 0;
        for (Block block : Block.field_149771_c) {
            for (int dv = 0; dv < 16; ++dv) {
                int blockColour = 0;
                if (block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.INVISIBLE) {
                    TextureAtlasSprite icon = null;
                    try {
                        icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176203_a(dv));
                    }
                    catch (Exception e) {
                        ++eCount;
                    }
                    if (icon != null) {
                        float u1 = icon.func_94209_e();
                        float u2 = icon.func_94212_f();
                        float v1 = icon.func_94206_g();
                        float v2 = icon.func_94210_h();
                        if (Utils.judgeFloat(u1, u1Last) && Utils.judgeFloat(u2, u2Last) && Utils.judgeFloat(v1, v1Last) && Utils.judgeFloat(v2, v2Last)) {
                            blockColour = blockColourLast;
                            ++sCount;
                        } else {
                            blockColour = BlockColourGen.getIconMapColour(icon, terrainTexture);
                            if (((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b().contains("CarpentersBlocks")) {
                                // empty if block
                            }
                            u1Last = u1;
                            u2Last = u2;
                            v1Last = v1;
                            v2Last = v2;
                            blockColourLast = blockColour;
                            ++bCount;
                        }
                    }
                }
                bc.setColour(block.delegate.name().toString(), String.valueOf(dv), blockColour);
            }
        }
        Logging.log("processed %d block textures, %d skipped, %d exceptions", bCount, sCount, eCount);
        BlockColourGen.genBiomeColours(bc);
    }
}

