/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.entities;

import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import java.awt.Color;
import pixelradar.config.PokeradarConfig;

public enum EntityType {
    STATUE(2.0, new Color(130, 130, 130)),
    SHRINE(4.0, new Color(0, 0, 255)),
    GADGET(4.0, new Color(173, 255, 47)),
    NPC(2.0, new Color(130, 130, 130)),
    REGULAR(1.9, new Color(255, 255, 255)),
    PLAYER(2.1, new Color(0, 0, 0)),
    LOOT(2.1, new Color(255, 229, 2)),
    SHINY(3.0, new Color(0, 127, 253)),
    SEARCHED(3.0, new Color(255, 255, 255)),
    BOSS(3.0, new Color(0, 0, 0)),
    BOSS_COMMON(3.0, EnumBossMode.Common.colour),
    BOSS_UNCOMMON(3.0, EnumBossMode.Uncommon.colour),
    BOSS_RARE(3.0, EnumBossMode.Rare.colour),
    BOSS_EPIC(3.0, EnumBossMode.Epic.colour),
    BOSS_LEGENDARY(3.0, EnumBossMode.Legendary.colour),
    BOSS_ULTIMATE(3.0, EnumBossMode.Ultimate.colour),
    BOSS_SPOOKY(3.0, EnumBossMode.Spooky.colour),
    BOSS_DROWNED(3.0, EnumBossMode.Drowned.colour),
    SPECIAL(5.5, new Color(204, 0, 255)),
    LEGENDARY(5.5, new Color(208, 32, 144)),
    ULTRA_BEAST(5.5, new Color(0, 0, 205)),
    DEN(4.0, new Color(205, 51, 51)),
    DITTO(3.0, new Color(255, 0, 0)),
    WORMHOLE(3.0, new Color(255, 0, 0)),
    DEX(3.0, new Color(255, 0, 0));

    private double radius;
    private Color color;

    private EntityType(double radiusN, Color color) {
        this.radius = radiusN;
        this.color = color;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getRadius() {
        return this.radius + (PokeradarConfig.dotSize - 1.0);
    }

    public double getTextureDimension() {
        return this.radius * 3.5 + 6.0 + (PokeradarConfig.textureSize - 1.0);
    }

    public Color getColor() {
        return this.color;
    }
}

