/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.forge;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.reflect.FieldUtils;
import pixelradar.Mw;
import pixelradar.config.Config;
import pixelradar.forge.Pokeradar;
import pixelradar.overlay.OverlaySlime;
import pixelradar.util.Logging;
import pixelradar.util.Reference;
import pixelradar.util.Utils;

public class EventHandler {
    Mw mw;

    public EventHandler(Mw mw) {
        this.mw = mw;
    }

    @SubscribeEvent
    public void eventChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            this.mw.onChunkLoad(event.getChunk());
        }
    }

    @SubscribeEvent
    public void eventChunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            this.mw.onChunkUnload(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatReceivedEvent event) {
        if (OverlaySlime.seedFound || !OverlaySlime.seedAsked) {
            return;
        }
        try {
            TextComponentString component;
            String msg;
            if (event.getMessage() instanceof TextComponentTranslation) {
                TextComponentTranslation component2 = (TextComponentTranslation)event.getMessage();
                if ("commands.seed.success".equals(component2.func_150268_i())) {
                    Long lSeed = component2.func_150271_j()[0] instanceof Long ? (Long)component2.func_150271_j()[0] : Long.valueOf(Long.parseLong((String)component2.func_150271_j()[0]));
                    OverlaySlime.setSeed(lSeed);
                    event.setCanceled(true);
                }
            } else if (event.getMessage() instanceof TextComponentString && (msg = (component = (TextComponentString)event.getMessage()).func_150260_c()).startsWith("Seed: ")) {
                OverlaySlime.setSeed(Long.parseLong(msg.substring(6)));
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            Logging.logError("Something went wrong getting the seed. %s", e.toString());
        }
    }

    @SubscribeEvent
    public void renderMap(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Mw.getInstance().onTick();
        }
    }

    @SubscribeEvent
    public void onTextureStitchEventPost(TextureStitchEvent.Post event) {
        if (Config.reloadColours) {
            Logging.logInfo("Skipping the first generation of blockcolours, models are not loaded yet", null);
        } else {
            this.mw.reloadBlockColours();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (Mw.getInstance().ready) {
            Mw.getInstance().markerManager.drawMarkersWorld(event.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityPixelmon && event.getHand() == EnumHand.MAIN_HAND && event.getItemStack().func_190926_b()) {
            try {
                int level;
                EntityPixelmon entity = (EntityPixelmon)event.getTarget();
                String name = entity.func_70005_c_();
                String localizedName = entity.getLocalizedName();
                Pokemon pokemon = entity.getPokemonData();
                boolean isShiny = pokemon.isShiny();
                String form = pokemon.getFormEnum().getLocalizedName();
                String extra = "";
                if (entity.isBossPokemon()) {
                    level = entity.getBossMode().extraLevels;
                    extra = I18n.func_135052_a((String)"mw.msg.status.boss", (Object[])new Object[0]);
                } else {
                    level = pokemon.getLevel();
                    if (Reference.LEGENDARIES.contains(name)) {
                        extra = I18n.func_135052_a((String)"mw.finder.msg.legendary", (Object[])new Object[0]);
                    } else if (Reference.ULTRA_BEASTS.contains(name)) {
                        extra = I18n.func_135052_a((String)"mw.finder.msg.ultra_beast", (Object[])new Object[0]);
                    } else if (Reference.DITTOS.contains(name)) {
                        extra = I18n.func_135052_a((String)"mw.finder.msg.ditto", (Object[])new Object[0]);
                    }
                }
                String owner = ChatFormatting.ITALIC + I18n.func_135052_a((String)"mw.msg.status.owner.wild", (Object[])new Object[0]);
                if (entity.hasOwner()) {
                    owner = Optional.of(Objects.requireNonNull(entity.func_70902_q()).func_70005_c_()).orElse(I18n.func_135052_a((String)"mw.msg.status.owner.someone", (Object[])new Object[0]));
                }
                EntityPlayer player = event.getEntityPlayer();
                player.func_146105_b((ITextComponent)new TextComponentString(""), false);
                player.func_145747_a((ITextComponent)new TextComponentString(Reference.CHAT_BRANDING));
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.GREEN + "" + ChatFormatting.BOLD + localizedName + ChatFormatting.RESET + (isShiny ? " (" + ChatFormatting.GREEN + I18n.func_135052_a((String)"mw.finder.msg.shiny", (Object[])new Object[0]) + ChatFormatting.RESET + ")" : "") + ChatFormatting.ITALIC + " " + ChatFormatting.DARK_AQUA + extra), false);
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.GREEN + I18n.func_135052_a((String)"mw.msg.status.level", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + (entity.isBossPokemon() ? I18n.func_135052_a((String)"mw.msg.status.boss.extralevels", (Object[])new Object[0]) + " " : "") + level), false);
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.GREEN + I18n.func_135052_a((String)"mw.msg.status.owner", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + owner), false);
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.GREEN + I18n.func_135052_a((String)"mw.msg.status.form", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + form), false);
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.GREEN + I18n.func_135052_a((String)"mw.msg.status.growth", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + entity.getPokemonData().getGrowth().getLocalizedName()), false);
                player.func_146105_b((ITextComponent)new TextComponentString(""), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpenEvent(GuiOpenEvent event) {
        GuiScreen guiScreen = event.getGui();
        if (guiScreen instanceof GuiMainMenu && Config.reloadColours) {
            this.mw.reloadBlockColours();
            Config.reloadColours = false;
        } else if (guiScreen instanceof GuiGameOver) {
            this.mw.onPlayerDeath();
        } else if (guiScreen instanceof GuiScreenRealmsProxy) {
            try {
                RealmsScreen proxy = ((GuiScreenRealmsProxy)guiScreen).func_154321_a();
                RealmsMainScreen parrent = null;
                if (proxy instanceof RealmsLongRunningMcoTaskScreen || proxy instanceof RealmsConfigureWorldScreen) {
                    long id;
                    Object obj = FieldUtils.readField((Object)proxy, (String)"lastScreen", (boolean)true);
                    if (obj instanceof RealmsMainScreen) {
                        parrent = (RealmsMainScreen)obj;
                    }
                    if (parrent != null && (id = ((Long)FieldUtils.readField((Object)parrent, (String)"selectedServerId", (boolean)true)).longValue()) > 0L) {
                        List<Object> list = Utils.castList(FieldUtils.readField((Object)parrent, (String)"realmsServers", (boolean)true), Object.class);
                        for (Object item : list) {
                            RealmsServer server = (RealmsServer)item;
                            Utils.RealmsWorldName = server.owner + "_" + server.getName();
                        }
                    }
                }
            }
            catch (IllegalAccessException e) {
                Pokeradar.logger.error(e.getMessage());
            }
        }
    }
}

