/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.gui;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import pixelradar.gui.RadarGui;

@SideOnly(value=Side.CLIENT)
public class GuiNatureList
extends GuiListExtended {
    private final RadarGui controlsScreen;
    private final Minecraft mc;
    private final GuiListExtended.IGuiListEntry[] listEntries;
    private int maxListLabelWidth;

    public GuiNatureList(RadarGui controls, Minecraft mcIn) {
        super(mcIn, controls.field_146294_l + 45, controls.field_146295_m, 63, controls.field_146295_m - 32, 20);
        this.controlsScreen = controls;
        this.mc = mcIn;
        KeyBinding[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        this.listEntries = new GuiListExtended.IGuiListEntry[akeybinding.length + KeyBinding.func_151467_c().size()];
        Arrays.sort(akeybinding);
        int i = 0;
        String s = null;
        for (KeyBinding keybinding : akeybinding) {
            int j;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                this.listEntries[i++] = new CategoryEntry(s1);
            }
            if ((j = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = j;
            }
            this.listEntries[i++] = new KeyEntry(keybinding);
        }
    }

    protected int func_148127_b() {
        return this.listEntries.length;
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.listEntries[index];
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 35;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    @SideOnly(value=Side.CLIENT)
    public class KeyEntry
    implements GuiListExtended.IGuiListEntry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final GuiButton btnChangeKeyBinding;
        private final GuiButton btnReset;

        private KeyEntry(KeyBinding name) {
            this.keybinding = name;
            this.keyDesc = I18n.func_135052_a((String)name.func_151464_g(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new GuiButton(0, 0, 0, 95, 20, I18n.func_135052_a((String)name.func_151464_g(), (Object[])new Object[0]));
            this.btnReset = new GuiButton(0, 0, 0, 50, 20, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0]));
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            ((GuiNatureList)GuiNatureList.this).mc.field_71466_p.func_78276_b(this.keyDesc, x + 90 - GuiNatureList.this.maxListLabelWidth, y + slotHeight / 2 - ((GuiNatureList)GuiNatureList.this).mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            this.btnReset.field_146128_h = x + 210;
            this.btnReset.field_146129_i = y;
            this.btnReset.field_146124_l = !this.keybinding.isSetToDefaultValue();
            this.btnReset.func_191745_a(GuiNatureList.this.mc, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.field_146128_h = x + 105;
            this.btnChangeKeyBinding.field_146129_i = y;
            this.btnChangeKeyBinding.field_146126_j = this.keybinding.getDisplayName();
            boolean keyCodeModifierConflict = true;
            if (this.keybinding.func_151463_i() != 0) {
                for (KeyBinding keybinding : ((GuiNatureList)GuiNatureList.this).mc.field_71474_y.field_74324_K) {
                    if (keybinding == this.keybinding || !keybinding.conflicts(this.keybinding)) continue;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            this.btnChangeKeyBinding.func_191745_a(GuiNatureList.this.mc, mouseX, mouseY, partialTicks);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnChangeKeyBinding.func_146116_c(GuiNatureList.this.mc, mouseX, mouseY)) {
                return true;
            }
            if (this.btnReset.func_146116_c(GuiNatureList.this.mc, mouseX, mouseY)) {
                this.keybinding.setToDefault();
                ((GuiNatureList)GuiNatureList.this).mc.field_71474_y.func_151440_a(this.keybinding, this.keybinding.func_151469_h());
                KeyBinding.func_74508_b();
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnChangeKeyBinding.func_146118_a(x, y);
            this.btnReset.func_146118_a(x, y);
        }

        public void setSelected(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CategoryEntry
    implements GuiListExtended.IGuiListEntry {
        private final String labelText;
        private final int labelWidth;

        CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((GuiNatureList)GuiNatureList.this).mc.field_71466_p.func_78256_a(this.labelText);
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            ((GuiNatureList)GuiNatureList.this).mc.field_71466_p.func_78276_b(this.labelText, Objects.requireNonNull(((GuiNatureList)GuiNatureList.this).mc.field_71462_r).field_146294_l / 2 - this.labelWidth / 2, y + slotHeight - ((GuiNatureList)GuiNatureList.this).mc.field_71466_p.field_78288_b - 1, 0xFFFFFF);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public void setSelected(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }
    }
}

