/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.gui;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import pixelradar.Mw;
import pixelradar.config.LargeMapModeConfig;
import pixelradar.config.MapModeConfig;
import pixelradar.config.SmallMapModeConfig;
import pixelradar.gui.ModGuiConfig;
import pixelradar.map.MapRenderer;
import pixelradar.map.mapmode.MapMode;

public class ModGuiConfigHUD
extends GuiConfig {
    private Mw mw;
    public MapMode mapMode;
    private MapRenderer map;
    private Boolean DraggingMap = Boolean.FALSE;
    protected GuiButtonExt btnTopLeft;
    protected GuiButtonExt btnTopRight;
    protected GuiButtonExt btnBottomLeft;
    protected GuiButtonExt btnBottomRight;
    protected GuiButtonExt btnCenterTop;
    protected GuiButtonExt btnCenterBottom;
    protected GuiButtonExt btnCenterLeft;
    protected GuiButtonExt btnCenterRight;
    protected GuiButtonExt btnCenter;
    private MapModeConfig dummyMapConfig;

    public ModGuiConfigHUD(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String Config2) {
        super(parentScreen, configElements, modID, configID, allRequireWorldRestart, allRequireMcRestart, title, "Use right click and hold to move the pixelradar.map");
        if ("fullscreenmap".equals(Config2)) {
            this.dummyMapConfig = new MapModeConfig("fullscreenmap");
        } else if ("largemap".equals(Config2)) {
            this.dummyMapConfig = new LargeMapModeConfig("largemap");
        } else if ("smallmap".equals(Config2)) {
            this.dummyMapConfig = new SmallMapModeConfig("smallmap");
        }
        this.dummyMapConfig.setDefaults();
        this.dummyMapConfig.loadConfig();
        this.mw = Mw.getInstance();
        this.mapMode = new MapMode(this.dummyMapConfig);
        this.map = new MapRenderer(this.mw, this.mapMode, null);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int topLeftWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.topleft", (Object[])new Object[0])) + 20, 100);
        int topRightWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.topright", (Object[])new Object[0])) + 20, 100);
        int bottomLeftWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.botleft", (Object[])new Object[0])) + 20, 100);
        int bottomRightWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.botright", (Object[])new Object[0])) + 20, 100);
        int centerTopWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.centertop", (Object[])new Object[0])) + 20, 100);
        int centerBottomWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerbottom", (Object[])new Object[0])) + 20, 100);
        int centerWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.center", (Object[])new Object[0])) + 20, 100);
        int centerLeft = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerleft", (Object[])new Object[0])) + 20, 100);
        int centerRight = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerright", (Object[])new Object[0])) + 20, 100);
        int buttonWidthHalf1 = (bottomLeftWidth + 5 + bottomRightWidth + centerTopWidth + 5) / 2;
        int buttonWidthHalf2 = (centerLeft + 5 + centerWidth + centerRight + 5) / 2;
        int buttonWidthHalf3 = (topLeftWidth + 5 + topRightWidth + centerBottomWidth + 5) / 2;
        int buttonHeigth1 = this.field_146295_m - 29 - 29 - 29 - 29;
        int buttonHeigth2 = this.field_146295_m - 29 - 29 - 29;
        int buttonHeigth3 = this.field_146295_m - 29 - 29;
        this.field_146292_n.add(new GuiButtonExt(3000, this.field_146294_l / 2 - buttonWidthHalf1, buttonHeigth1, topLeftWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.topleft", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3001, this.field_146294_l / 2 - buttonWidthHalf1 + topLeftWidth + 5, buttonHeigth1, centerTopWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.centertop", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3002, this.field_146294_l / 2 - buttonWidthHalf1 + topLeftWidth + 5 + centerTopWidth + 5, buttonHeigth1, topRightWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.topright", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3010, this.field_146294_l / 2 - buttonWidthHalf2, buttonHeigth2, centerLeft, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerleft", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3011, this.field_146294_l / 2 - buttonWidthHalf2 + centerLeft + 5, buttonHeigth2, centerWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.center", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3012, this.field_146294_l / 2 - buttonWidthHalf2 + centerLeft + 5 + centerWidth + 5, buttonHeigth2, centerRight, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerright", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3020, this.field_146294_l / 2 - buttonWidthHalf3, buttonHeigth3, bottomLeftWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.botleft", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3021, this.field_146294_l / 2 - buttonWidthHalf3 + bottomLeftWidth + 5, buttonHeigth3, centerBottomWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.centerbottom", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButtonExt(3022, this.field_146294_l / 2 - buttonWidthHalf3 + bottomLeftWidth + 5 + centerBottomWidth + 5, buttonHeigth3, bottomRightWidth, 20, I18n.func_135052_a((String)"mw.config.map.ctgy.position.botright", (Object[])new Object[0])));
        this.updateParrentSettings();
    }

    protected void func_146284_a(GuiButton button) {
        double bottomOffset = 0.0;
        if (!this.mapMode.getConfig().biomeMode.equals(MapModeConfig.coordsModeStringArray[0])) {
            bottomOffset = bottomOffset + (double)this.field_146297_k.field_71466_p.field_78288_b + 3.0;
        }
        if (!this.mapMode.getConfig().biomeMode.equals(MapModeConfig.coordsModeStringArray[0])) {
            bottomOffset = bottomOffset + (double)this.field_146297_k.field_71466_p.field_78288_b + 3.0;
        }
        bottomOffset = bottomOffset / (double)this.field_146295_m * 100.0;
        double SmallMarginY = 10.0 / (double)(this.field_146295_m - this.mapMode.getH()) * 100.0;
        double SmallMarginX = 10.0 / (double)(this.field_146294_l - this.mapMode.getW()) * 100.0;
        double LargeMarginBottom = 40.0 / (double)(this.field_146295_m - this.mapMode.getH()) * 100.0;
        double d = bottomOffset = bottomOffset < SmallMarginY ? SmallMarginY : bottomOffset;
        if (button.field_146127_k == 3000) {
            this.updateMap(new Point2D.Double(SmallMarginX, SmallMarginY));
        } else if (button.field_146127_k == 3001) {
            this.updateMap(new Point2D.Double(50.0, SmallMarginY));
        } else if (button.field_146127_k == 3002) {
            this.updateMap(new Point2D.Double(100.0 - SmallMarginX, SmallMarginY));
        } else if (button.field_146127_k == 3010) {
            this.updateMap(new Point2D.Double(SmallMarginX, 50.0));
        } else if (button.field_146127_k == 3011) {
            this.updateMap(new Point2D.Double(50.0, 50.0));
        } else if (button.field_146127_k == 3012) {
            this.updateMap(new Point2D.Double(100.0 - SmallMarginX, 50.0));
        } else if (button.field_146127_k == 3020) {
            this.updateMap(new Point2D.Double(SmallMarginX, 100.0 - bottomOffset));
        } else if (button.field_146127_k == 3021) {
            this.updateMap(new Point2D.Double(50.0, 100.0 - LargeMarginBottom));
        } else if (button.field_146127_k == 3022) {
            this.updateMap(new Point2D.Double(100.0 - SmallMarginX, 100.0 - bottomOffset));
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73864_a(int x, int y, int mouseEvent) throws IOException {
        if (mouseEvent != 1 || !this.mapMode.posWithin(x, y)) {
            super.func_73864_a(x, y, mouseEvent);
        } else {
            this.DraggingMap = Boolean.TRUE;
        }
    }

    protected void func_146273_a(int x, int y, int mouseEvent, long timeSinceLastClick) {
        if (this.DraggingMap.booleanValue()) {
            this.updateMap(this.mapMode.getNewPosPoint(x, y));
        } else {
            super.func_146273_a(x, y, mouseEvent, timeSinceLastClick);
        }
    }

    public void func_146286_b(int x, int y, int mouseEvent) {
        if (this.DraggingMap.booleanValue()) {
            this.DraggingMap = Boolean.FALSE;
        } else {
            super.func_146286_b(x, y, mouseEvent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.updateButtonValues();
        this.map.drawDummy();
    }

    private void updateButtonValues() {
        for (GuiConfigEntries.IConfigEntry entry : this.entryList.listEntries) {
            if ("xPos".equals(entry.getName())) {
                this.dummyMapConfig.xPos = (Double)entry.getCurrentValue();
                continue;
            }
            if ("yPos".equals(entry.getName())) {
                this.dummyMapConfig.yPos = (Double)entry.getCurrentValue();
                continue;
            }
            if ("heightPercent".equals(entry.getName())) {
                this.dummyMapConfig.heightPercent = (Double)entry.getCurrentValue();
                continue;
            }
            if (!"widthPercent".equals(entry.getName())) continue;
            this.dummyMapConfig.widthPercent = (Double)entry.getCurrentValue();
            ((ModGuiConfig.ModNumberSliderEntry)entry).setEnabled(!this.mapMode.getConfig().circular);
        }
    }

    private void updateParrentSettings() {
        if (this.parentScreen != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parrent = (GuiConfig)this.parentScreen;
            if (parrent.entryList != null && parrent.entryList.listEntries != null) {
                for (GuiConfigEntries.IConfigEntry entry : parrent.entryList.listEntries) {
                    if ("circular".equals(entry.getName())) {
                        this.dummyMapConfig.circular = (Boolean)entry.getCurrentValue();
                        continue;
                    }
                    if ("coordsMode".equals(entry.getName())) {
                        this.dummyMapConfig.coordsMode = (String)entry.getCurrentValue();
                        continue;
                    }
                    if ("borderMode".equals(entry.getName())) {
                        this.dummyMapConfig.borderMode = (Boolean)entry.getCurrentValue();
                        continue;
                    }
                    if ("playerArrowSize".equals(entry.getName())) {
                        this.dummyMapConfig.playerArrowSize = Integer.parseInt((String)entry.getCurrentValue());
                        continue;
                    }
                    if (!"biomeMode".equals(entry.getName())) continue;
                    this.dummyMapConfig.biomeMode = (String)entry.getCurrentValue();
                }
            }
        }
    }

    private void updateMap(Point2D.Double point) {
        for (GuiConfigEntries.IConfigEntry entry : this.entryList.listEntries) {
            if (!(entry instanceof ModGuiConfig.ModNumberSliderEntry)) continue;
            if ("xPos".equals(entry.getName())) {
                ((ModGuiConfig.ModNumberSliderEntry)entry).setValue(point.getX());
                continue;
            }
            if (!"yPos".equals(entry.getName())) continue;
            ((ModGuiConfig.ModNumberSliderEntry)entry).setValue(point.getY());
        }
    }

    public static class MapPosConfigEntry
    extends GuiConfigEntries.CategoryEntry {
        public MapPosConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        protected GuiScreen buildChildScreen() {
            String qualifiedName = this.configElement.getQualifiedName();
            String config = qualifiedName.substring(0, qualifiedName.indexOf(".")).replace(".", "");
            return new ModGuiConfigHUD((GuiScreen)this.owningScreen, this.getConfigElement().getChildElements(), this.owningScreen.modID, null, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title, config);
        }
    }
}

