/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.gui;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import pixelradar.gui.ScrollableField;

public class ScrollableTextBox
extends ScrollableField {
    public int textFieldX;
    public int textFieldY;
    public int textFieldWidth;
    private static int textFieldHeight = 12;
    public List<String> scrollableElements;
    protected GuiTextField textField;

    ScrollableTextBox(int x, int y, int width, String label, FontRenderer fontrendererObj) {
        super(x, y, width, label, fontrendererObj);
        this.init();
    }

    ScrollableTextBox(int x, int y, int width, String label, List<String> scrollableElements, FontRenderer fontrendererObj) {
        super(x, y, width, label, fontrendererObj);
        this.scrollableElements = scrollableElements;
        this.init();
    }

    private void init() {
        this.textFieldX = this.x + ScrollableField.arrowsWidth + 3;
        this.textFieldY = this.y;
        this.textFieldWidth = this.width - 5 - ScrollableField.arrowsWidth * 2;
        this.textField = new GuiTextField(0, this.fontrendererObj, this.textFieldX, this.textFieldY, this.textFieldWidth, textFieldHeight);
        this.textField.func_146203_f(32);
    }

    @Override
    public void draw() {
        super.draw();
        this.textField.func_146194_f();
        if (!this.validateTextFieldData()) {
            int x1 = this.textFieldX - 1;
            int y1 = this.textFieldY - 1;
            int x2 = this.textFieldX + this.textFieldWidth;
            int y2 = this.textFieldY + textFieldHeight;
            int colour = -7340032;
            this.func_73730_a(x1, x2, y1, colour);
            this.func_73730_a(x1, x2, y2, colour);
            this.func_73728_b(x1, y1, y2, colour);
            this.func_73728_b(x2, y1, y2, colour);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.textField.func_146192_a(x, y, button);
    }

    public void mouseDWheelScrolled(int x, int y, int direction) {
        if (this.posWithinTextField(x, y)) {
            this.textFieldScroll(-direction);
        }
    }

    public boolean validateTextFieldData() {
        return this.getText().length() > 0;
    }

    public boolean posWithinTextField(int x, int y) {
        return x >= this.textFieldX && y >= this.textFieldY && x <= this.textFieldWidth + this.textFieldX && y <= textFieldHeight + this.textFieldY;
    }

    public void textFieldScroll(int direction) {
        if (this.scrollableElements != null) {
            int index = this.scrollableElements.indexOf(this.getText().trim());
            if (direction > 0) {
                index = index == -1 || index == this.scrollableElements.size() - 1 ? 0 : ++index;
            } else if (direction < 0) {
                index = index == -1 || index == 0 ? this.scrollableElements.size() - 1 : --index;
            }
            this.textField.func_146180_a(this.scrollableElements.get(index));
        }
    }

    @Override
    public void nextElement() {
        this.textFieldScroll(1);
    }

    @Override
    public void previousElement() {
        this.textFieldScroll(-1);
    }

    public String getText() {
        return this.textField.func_146179_b();
    }

    public void setText(String text) {
        this.textField.func_146180_a(text);
    }

    @Override
    public void setFocused(Boolean focus) {
        this.textField.func_146195_b(focus.booleanValue());
        this.textField.func_146199_i(0);
    }

    @Override
    public Boolean isFocused() {
        return this.textField.func_146206_l();
    }

    public void KeyTyped(char c, int key) {
        this.textField.func_146201_a(c, key);
    }

    public int getCursorPosition() {
        return this.textField.func_146198_h();
    }

    public void setCursorPositionEnd() {
        this.textField.func_146202_e();
    }
}

