/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.map;

import java.awt.geom.Point2D;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import pixelradar.map.MapView;
import pixelradar.map.mapmode.MapMode;
import pixelradar.util.Render;
import pixelradar.util.Utils;

public class Marker {
    public final String name;
    public final String groupName;
    public int x;
    public int y;
    public int z;
    public int dimension;
    public int colour;
    public Point2D.Double screenPos = new Point2D.Double(0.0, 0.0);

    public Marker(String name, String groupName, int x, int y, int z, int dimension, int colour) {
        this.name = Utils.mungeStringForConfig(name);
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.colour = colour;
        this.groupName = Utils.mungeStringForConfig(groupName);
    }

    public String getString() {
        return String.format("%s %s (%d, %d, %d) %d %06x", this.name, this.groupName, this.x, this.y, this.z, this.dimension, this.colour & 0xFFFFFF);
    }

    public void colourNext() {
        this.colour = Utils.getNextColour();
    }

    public void colourPrev() {
        this.colour = Utils.getPrevColour();
    }

    public void draw(MapMode mapMode, MapView mapView, int borderColour) {
        double scale = mapView.getDimensionScaling(this.dimension);
        Point2D.Double p = mapMode.getClampedScreenXY(mapView, (double)this.x * scale, (double)this.z * scale);
        this.screenPos.setLocation(p.x + (double)mapMode.getXTranslation(), p.y + (double)mapMode.getYTranslation());
        double mSize = mapMode.getConfig().markerSize;
        double halfMSize = (double)mapMode.getConfig().markerSize / 2.0;
        Render.setColour(borderColour);
        Render.drawRect(p.x - halfMSize, p.y - halfMSize, mSize, mSize);
        Render.setColour(this.colour);
        Render.drawRect(p.x - halfMSize + 0.5, p.y - halfMSize + 0.5, mSize - 1.0, mSize - 1.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Marker) {
            Marker m = (Marker)o;
            return this.name == m.name && this.groupName == m.groupName && this.x == m.x && this.y == m.y && this.z == m.z && this.dimension == m.dimension;
        }
        return false;
    }

    public double getDistanceToMarker(Entity entityIn) {
        if (entityIn == null) {
            return 0.0;
        }
        double d0 = (double)this.x - entityIn.field_70165_t;
        double d1 = (double)this.y - entityIn.field_70163_u;
        double d2 = (double)this.z - entityIn.field_70161_v;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public float getRed() {
        return (float)(this.colour >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.colour >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.colour & 0xFF) / 255.0f;
    }
}

