/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.map;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;
import pixelradar.config.PokeradarConfig;
import pixelradar.config.WorldConfig;
import pixelradar.entities.EntityFinder;
import pixelradar.entities.EntityType;
import pixelradar.map.MapRenderer;
import pixelradar.map.MapView;
import pixelradar.map.Marker;
import pixelradar.map.PKMarker;
import pixelradar.map.mapmode.MapMode;
import pixelradar.util.Logging;
import pixelradar.util.TwoDimensionalArrayList;
import pixelradar.util.Utils;

public class MarkerManager {
    public List<Marker> markerList = new ArrayList<Marker>();
    public List<String> groupList = new ArrayList<String>();
    public List<Marker> visibleMarkerList = new ArrayList<Marker>();
    private String visibleGroupName = "none";
    public Marker selectedMarker = null;

    public void load(Configuration config, String category) {
        this.markerList.clear();
        if (config.hasCategory(category)) {
            int markerCount = config.get(category, "markerCount", 0).getInt();
            this.visibleGroupName = config.get(category, "visibleGroup", "").getString();
            if (markerCount > 0) {
                for (int i = 0; i < markerCount; ++i) {
                    String key = "marker" + i;
                    String value = config.get(category, key, "").getString();
                    Marker marker = this.stringToMarker(value);
                    if (marker != null) {
                        this.addMarker(marker);
                        continue;
                    }
                    Logging.log("error: could not load " + key + " from pixelradar.config file", new Object[0]);
                }
            }
        }
        this.update();
    }

    public void save(Configuration config, String category) {
        config.removeCategory(config.getCategory(category));
        config.get(category, "markerCount", 0).set(this.markerList.size());
        config.get(category, "visibleGroup", "").set(this.visibleGroupName);
        int i = 0;
        for (Marker marker : this.markerList) {
            String key = "marker" + i;
            String value = this.markerToString(marker);
            config.get(category, key, "").set(value);
            ++i;
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void setVisibleGroupName(String groupName) {
        this.visibleGroupName = groupName != null ? Utils.mungeStringForConfig(groupName) : "none";
    }

    public String getVisibleGroupName() {
        return this.visibleGroupName;
    }

    public void clear() {
        this.markerList.clear();
        this.groupList.clear();
        this.visibleMarkerList.clear();
        this.visibleGroupName = "none";
    }

    public String markerToString(Marker marker) {
        return String.format("%s:%d:%d:%d:%d:%06x:%s", marker.name, marker.x, marker.y, marker.z, marker.dimension, marker.colour & 0xFFFFFF, marker.groupName);
    }

    public Marker stringToMarker(String s) {
        String[] split = s.split(":");
        if (split.length != 7) {
            split = s.split(" ");
        }
        Marker marker = null;
        if (split.length == 7) {
            try {
                int x = Integer.parseInt(split[1]);
                int y = Integer.parseInt(split[2]);
                int z = Integer.parseInt(split[3]);
                int dimension = Integer.parseInt(split[4]);
                int colour = 0xFF000000 | Integer.parseInt(split[5], 16);
                marker = new Marker(split[0], split[6], x, y, z, dimension, colour);
            }
            catch (NumberFormatException e) {
                marker = null;
            }
        } else {
            Logging.log("PKMarker.stringToMarker: invalid marker '%s'", s);
        }
        return marker;
    }

    public void addMarker(Marker marker) {
        this.markerList.add(marker);
    }

    public void addMarker(String name, String groupName, int x, int y, int z, int dimension, int colour) {
        this.addMarker(new Marker(name, groupName, x, y, z, dimension, colour));
        this.save(WorldConfig.getInstance().worldConfiguration, "markers");
    }

    public boolean delMarker(Marker markerToDelete) {
        if (this.selectedMarker == markerToDelete) {
            this.selectedMarker = null;
        }
        boolean result = this.markerList.remove(markerToDelete);
        this.save(WorldConfig.getInstance().worldConfiguration, "markers");
        return result;
    }

    public boolean delMarker(String name, String group) {
        Marker markerToDelete = null;
        for (Marker marker : this.markerList) {
            if (name != null && !marker.name.equals(name) || group != null && !marker.groupName.equals(group)) continue;
            markerToDelete = marker;
            break;
        }
        return this.delMarker(markerToDelete);
    }

    public void update() {
        this.visibleMarkerList.clear();
        this.groupList.clear();
        this.groupList.add("none");
        this.groupList.add("all");
        for (Marker marker : this.markerList) {
            if (marker.groupName.equals(this.visibleGroupName) || "all".equals(this.visibleGroupName)) {
                this.visibleMarkerList.add(marker);
            }
            if (this.groupList.contains(marker.groupName)) continue;
            this.groupList.add(marker.groupName);
        }
        if (!this.groupList.contains(this.visibleGroupName)) {
            this.visibleGroupName = "none";
        }
    }

    public void nextGroup(int n) {
        if (this.groupList.size() > 0) {
            int i = this.groupList.indexOf(this.visibleGroupName);
            int size = this.groupList.size();
            i = i != -1 ? (i + size + n) % size : 0;
            this.visibleGroupName = this.groupList.get(i);
        } else {
            this.visibleGroupName = "none";
            this.groupList.add("none");
        }
    }

    public void nextGroup() {
        this.nextGroup(1);
    }

    public int countMarkersInGroup(String group) {
        int count = 0;
        if ("all".equals(group)) {
            count = this.markerList.size();
        } else {
            for (Marker marker : this.markerList) {
                if (!marker.groupName.equals(group)) continue;
                ++count;
            }
        }
        return count;
    }

    public void selectNextMarker() {
        if (this.visibleMarkerList.size() > 0) {
            int i = 0;
            if (this.selectedMarker != null && (i = this.visibleMarkerList.indexOf(this.selectedMarker)) == -1) {
                i = 0;
            }
            i = (i + 1) % this.visibleMarkerList.size();
            this.selectedMarker = this.visibleMarkerList.get(i);
        } else {
            this.selectedMarker = null;
        }
    }

    public Marker getNearestMarker(int x, int z, int maxDistance) {
        int nearestDistance = maxDistance * maxDistance;
        Marker nearestMarker = null;
        for (Marker marker : this.visibleMarkerList) {
            int dx = x - marker.x;
            int dz = z - marker.z;
            int d = dx * dx + dz * dz;
            if (d >= nearestDistance) continue;
            nearestMarker = marker;
            nearestDistance = d;
        }
        return nearestMarker;
    }

    public Marker getNearestMarkerInDirection(int x, int z, double desiredAngle) {
        int nearestDistance = 100000000;
        Marker nearestMarker = null;
        for (Marker marker : this.visibleMarkerList) {
            int dx = marker.x - x;
            int dz = marker.z - z;
            int d = dx * dx + dz * dz;
            double angle = Math.atan2(dz, dx);
            if (!(Math.cos(desiredAngle - angle) > 0.8) || d >= nearestDistance || d <= 4) continue;
            nearestMarker = marker;
            nearestDistance = d;
        }
        return nearestMarker;
    }

    public void drawMarkers(MapMode mapMode, MapView mapView) {
        for (Marker marker : this.visibleMarkerList) {
            if (mapView.getDimension() != marker.dimension) continue;
            marker.draw(mapMode, mapView, -16777216);
        }
        if (this.selectedMarker != null) {
            this.selectedMarker.draw(mapMode, mapView, -1);
        }
    }

    public void drawPKMarkers(MapMode mapMode, MapView mapView, MapRenderer mr, float mapRotationDegrees) {
        TwoDimensionalArrayList<PKMarker> markerList = new TwoDimensionalArrayList<PKMarker>();
        for (int i = 0; i < EntityType.values().length; ++i) {
            markerList.add(new ArrayList());
        }
        for (PKMarker pKMarker : EntityFinder.pkMarkers) {
            if (mapView.getDimension() != pKMarker.dimension) continue;
            markerList.addToInnerArray(pKMarker.type.ordinal(), pKMarker);
        }
        EntityFinder.pkMarkers.clear();
        for (ArrayList arrayList : markerList) {
            for (PKMarker marker : arrayList) {
                if (marker.type == EntityType.PLAYER) {
                    mr.drawEntityArrow(marker.x, marker.z, Math.toRadians(marker.yaw) + 1.5707963267948966, true);
                    continue;
                }
                if (marker.type == EntityType.NPC) {
                    mr.drawEntityArrow(marker.x, marker.z, Math.toRadians(marker.yaw) + 1.5707963267948966, false);
                    continue;
                }
                if (PokeradarConfig.useTextures) {
                    marker.drawPKTexture(mapMode, mapView, mapRotationDegrees);
                    continue;
                }
                marker.draw(mapMode, mapView);
            }
        }
    }

    public void drawMarkersWorld(float partialTicks) {
        if (!PokeradarConfig.drawMarkersInWorld && !PokeradarConfig.drawMarkersNameInWorld) {
            return;
        }
        for (PKMarker pKMarker : EntityFinder.pkMarkers) {
            Minecraft mc = Minecraft.func_71410_x();
            if (pKMarker.dimension != mc.field_71441_e.field_73011_w.getDimension()) continue;
            boolean draw = false;
            boolean drawLine = false;
            switch (pKMarker.type) {
                case BOSS_COMMON: 
                case BOSS_UNCOMMON: 
                case BOSS_RARE: 
                case BOSS_EPIC: 
                case BOSS_LEGENDARY: 
                case BOSS_ULTIMATE: 
                case BOSS_SPOOKY: 
                case BOSS_DROWNED: {
                    if (PokeradarConfig.drawBossMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawBossLines) break;
                    drawLine = true;
                    break;
                }
                case SPECIAL: 
                case LEGENDARY: 
                case ULTRA_BEAST: {
                    if (PokeradarConfig.drawSpecialMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawSpecialLines) break;
                    drawLine = true;
                    break;
                }
                case SEARCHED: {
                    if (PokeradarConfig.drawSearchedMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawSearchedLines) break;
                    drawLine = true;
                    break;
                }
                case SHINY: {
                    if (PokeradarConfig.drawShinyMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawShinyLines) break;
                    drawLine = true;
                    break;
                }
                case LOOT: {
                    if (PokeradarConfig.drawLootMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawLootLines) break;
                    drawLine = true;
                    break;
                }
                case DITTO: {
                    if (PokeradarConfig.drawDittoMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawDittoLines) break;
                    drawLine = true;
                    break;
                }
                case NPC: {
                    if (PokeradarConfig.drawNPCMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawNPCLines) break;
                    drawLine = true;
                    break;
                }
                case DEX: {
                    if (PokeradarConfig.drawDexMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawDexLines) break;
                    drawLine = true;
                    break;
                }
                case WORMHOLE: {
                    if (PokeradarConfig.drawWormMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawWormLines) break;
                    drawLine = true;
                    break;
                }
                case DEN: {
                    if (PokeradarConfig.drawDenMarkers) {
                        draw = true;
                    }
                    if (!PokeradarConfig.drawDenLines) break;
                    drawLine = true;
                }
            }
            if (drawLine && PokeradarConfig.allowLinesInWorld) {
                this.drawLine(pKMarker, partialTicks, mc.field_71439_g);
            }
            if (!draw) continue;
            if (PokeradarConfig.drawMarkersInWorld) {
                this.drawBeam(pKMarker, partialTicks);
            }
            if (!PokeradarConfig.drawMarkersNameInWorld) continue;
            if (!pKMarker.desc.isEmpty()) {
                this.drawLabel(pKMarker);
                continue;
            }
            this.drawLabelNoDesc(pKMarker);
        }
        if (!PokeradarConfig.enableMap) {
            EntityFinder.pkMarkers.clear();
        }
        for (Marker marker : this.visibleMarkerList) {
            if (marker.dimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK) continue;
            if (PokeradarConfig.drawMarkersInWorld) {
                this.drawBeam(marker, partialTicks);
            }
            if (!PokeradarConfig.drawMarkersNameInWorld) continue;
            this.drawLabel(marker);
        }
    }

    public void drawLine(PKMarker m, float partialTicks, EntityPlayerSP player) {
        RayTraceResult ray = player.func_174822_a(2.0, partialTicks);
        if (ray == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        Vec3d ma = new Vec3d(m.x, m.y, m.z);
        GL11.glTranslated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GL11.glEnable((int)34383);
        GL11.glColor4ub((byte)((byte)m.type.getColor().getRed()), (byte)((byte)m.type.getColor().getGreen()), (byte)((byte)m.type.getColor().getBlue()), (byte)-106);
        GL11.glLineWidth((float)10.0f);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)ray.field_72307_f.field_72450_a, (double)ray.field_72307_f.field_72448_b, (double)ray.field_72307_f.field_72449_c);
        GL11.glVertex3d((double)ma.field_72450_a, (double)(ma.field_72448_b + 0.5), (double)ma.field_72449_c);
        GL11.glEnd();
        GL11.glDisable((int)34383);
        GlStateManager.func_179126_j();
        GL11.glPopAttrib();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void drawBeam(Marker m, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        float f2 = (float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks;
        double d3 = (double)f2 * 0.025 * -1.5;
        double d17 = 255.0;
        double x = (double)m.x - TileEntityRendererDispatcher.field_147554_b;
        double y = 0.0 - TileEntityRendererDispatcher.field_147555_c;
        double z = (double)m.z - TileEntityRendererDispatcher.field_147552_d;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double d4 = 0.2;
        double d5 = 0.5 + Math.cos(d3 + 2.356194490192345) * d4;
        double d6 = 0.5 + Math.sin(d3 + 2.356194490192345) * d4;
        double d7 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d4;
        double d8 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d4;
        double d9 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d4;
        double d10 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d4;
        double d11 = 0.5 + Math.cos(d3 + 5.497787143782138) * d4;
        double d12 = 0.5 + Math.sin(d3 + 5.497787143782138) * d4;
        float fRed = m.getRed();
        float fGreen = m.getGreen();
        float fBlue = m.getBlue();
        float fAlpha = 0.125f;
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        d4 = 0.5;
        d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * d4;
        d6 = 0.5 + Math.cos(d3 + 2.356194490192345) * d4;
        d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d4;
        d8 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d4;
        d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d4;
        d10 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d4;
        d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * d4;
        d12 = 0.5 + Math.cos(d3 + 5.497787143782138) * d4;
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void drawBeam(PKMarker m, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        float f2 = (float)Minecraft.func_71410_x().field_71441_e.func_82737_E() + partialTicks;
        double d3 = (double)f2 * 0.025 * -1.5;
        double d17 = 255.0;
        double x = m.x - TileEntityRendererDispatcher.field_147554_b;
        double y = 0.0 - TileEntityRendererDispatcher.field_147555_c;
        double z = m.z - TileEntityRendererDispatcher.field_147552_d;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double d4 = 0.2;
        double d5 = 0.5 + Math.cos(d3 + 2.356194490192345) * d4;
        double d6 = 0.5 + Math.sin(d3 + 2.356194490192345) * d4;
        double d7 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d4;
        double d8 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d4;
        double d9 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d4;
        double d10 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d4;
        double d11 = 0.5 + Math.cos(d3 + 5.497787143782138) * d4;
        double d12 = 0.5 + Math.sin(d3 + 5.497787143782138) * d4;
        Color color = m.type.getColor();
        float fRed = (float)color.getRed() / 255.0f;
        float fGreen = (float)color.getGreen() / 255.0f;
        float fBlue = (float)color.getBlue() / 255.0f;
        float fAlpha = 0.125f;
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        d4 = 0.5;
        d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * d4;
        d6 = 0.5 + Math.cos(d3 + 2.356194490192345) * d4;
        d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * d4;
        d8 = 0.5 + Math.cos(d3 + 0.7853981633974483) * d4;
        d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * d4;
        d10 = 0.5 + Math.cos(d3 + 3.9269908169872414) * d4;
        d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * d4;
        d12 = 0.5 + Math.cos(d3 + 5.497787143782138) * d4;
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y + d17, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d7, y, z + d8).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d11, y + d17, z + d12).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y + d17, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d9, y, z + d10).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b(x + d5, y + d17, z + d6).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void drawLabel(Marker m) {
        float growFactor = 0.17f;
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        FontRenderer fontrenderer = mc.field_71466_p;
        double x = 0.5 + (double)m.x - TileEntityRendererDispatcher.field_147554_b;
        double y = 0.5 + (double)m.y - TileEntityRendererDispatcher.field_147555_c;
        double z = 0.5 + (double)m.z - TileEntityRendererDispatcher.field_147552_d;
        float fRed = m.getRed();
        float fGreen = m.getGreen();
        float fBlue = m.getBlue();
        float fAlpha = 0.2f;
        double distance = m.getDistanceToMarker(renderManager.field_78734_h);
        String strText = m.name;
        String strDistance = "(" + (int)distance + "m)";
        int strTextWidth = fontrenderer.func_78256_a(strText) / 2;
        int strDistanceWidth = fontrenderer.func_78256_a(strDistance) / 2;
        int offstet = 9;
        float f = (float)(1.0 + distance * (double)growFactor);
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)34383);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(-1 + offstet), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(8 + offstet), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(8 + offstet), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(-1 + offstet), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(strText, -strTextWidth, 0, -1);
        fontrenderer.func_78276_b(strDistance, -strDistanceWidth, offstet, -1);
        GL11.glDisable((int)34383);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawLabel(PKMarker m) {
        float growFactor = 0.17f;
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        FontRenderer fontrenderer = mc.field_71466_p;
        double x = 0.5 + m.x - TileEntityRendererDispatcher.field_147554_b;
        double y = 0.5 + m.y - TileEntityRendererDispatcher.field_147555_c;
        double z = 0.5 + m.z - TileEntityRendererDispatcher.field_147552_d;
        Color color = m.type.getColor();
        float fRed = (float)color.getRed() / 255.0f;
        float fGreen = (float)color.getGreen() / 255.0f;
        float fBlue = (float)color.getBlue() / 255.0f;
        float fAlpha = 0.2f;
        double distance = m.getDistanceToMarker(renderManager.field_78734_h);
        String strText = m.name;
        String strDesc = m.desc;
        String strDistance = "(" + (int)distance + "m)";
        int strTextWidth = fontrenderer.func_78256_a(strText) / 2;
        int strDescWidth = fontrenderer.func_78256_a(strDesc) / 2;
        int strDistanceWidth = fontrenderer.func_78256_a(strDistance) / 2;
        int offset = 9;
        float f = (float)(1.0 + distance * (double)growFactor);
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)34383);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strDescWidth - 1), (double)(-1 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strDescWidth - 1), (double)(8 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDescWidth + 1), (double)(8 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDescWidth + 1), (double)(-1 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(-1 + offset * 2), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(8 + offset * 2), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(8 + offset * 2), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(-1 + offset * 2), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(strText, -strTextWidth, 0, -1);
        fontrenderer.func_78276_b(strDesc, -strDescWidth, offset, -1);
        fontrenderer.func_78276_b(strDistance, -strDistanceWidth, offset * 2, -1);
        GL11.glDisable((int)34383);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawLabelNoDesc(PKMarker m) {
        float growFactor = 0.17f;
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        FontRenderer fontrenderer = mc.field_71466_p;
        double x = 0.5 + m.x - TileEntityRendererDispatcher.field_147554_b;
        double y = 0.5 + m.y - TileEntityRendererDispatcher.field_147555_c;
        double z = 0.5 + m.z - TileEntityRendererDispatcher.field_147552_d;
        Color color = m.type.getColor();
        float fRed = (float)color.getRed() / 255.0f;
        float fGreen = (float)color.getGreen() / 255.0f;
        float fBlue = (float)color.getBlue() / 255.0f;
        float fAlpha = 0.2f;
        double distance = m.getDistanceToMarker(renderManager.field_78734_h);
        String strText = m.name;
        String strDistance = "(" + (int)distance + "m)";
        int strTextWidth = fontrenderer.func_78256_a(strText) / 2;
        int strDistanceWidth = fontrenderer.func_78256_a(strDistance) / 2;
        int offset = 9;
        float f = (float)(1.0 + distance * (double)growFactor);
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)34383);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strTextWidth - 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), 8.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strTextWidth + 1), -1.0, 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(-1 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strDistanceWidth - 1), (double)(8 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(8 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        vertexbuffer.func_181662_b((double)(strDistanceWidth + 1), (double)(-1 + offset), 0.0).func_181666_a(fRed, fGreen, fBlue, fAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(strText, -strTextWidth, 0, -1);
        fontrenderer.func_78276_b(strDistance, -strDistanceWidth, offset, -1);
        GL11.glDisable((int)34383);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

