/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import pixelradar.util.Logging;

public class Render {
    public static double zDepth = 0.0;
    public static final double circleSteps = 30.0;

    public static void setColourWithAlphaPercent(int colour, int alphaPercent) {
        Render.setColour((alphaPercent * 255 / 100 & 0xFF) << 24 | colour & 0xFFFFFF);
    }

    public static void setColour(int colour) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)((float)(colour >> 24 & 0xFF) / 255.0f));
        GlStateManager.func_179084_k();
    }

    public static void resetColour() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int multiplyColours(int c1, int c2) {
        float c1A = c1 >> 24 & 0xFF;
        float c1R = c1 >> 16 & 0xFF;
        float c1G = c1 >> 8 & 0xFF;
        float c1B = c1 & 0xFF;
        float c2A = c2 >> 24 & 0xFF;
        float c2R = c2 >> 16 & 0xFF;
        float c2G = c2 >> 8 & 0xFF;
        float c2B = c2 & 0xFF;
        int r = (int)(c1R * c2R / 255.0f) & 0xFF;
        int g = (int)(c1G * c2G / 255.0f) & 0xFF;
        int b = (int)(c1B * c2B / 255.0f) & 0xFF;
        int a = (int)(c1A * c2A / 255.0f) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getAverageOfPixelQuad(int[] pixels, int offset, int scanSize) {
        int p00 = pixels[offset];
        int p01 = pixels[offset + 1];
        int p10 = pixels[offset + scanSize];
        int p11 = pixels[offset + scanSize + 1];
        int r = (p00 >> 16 & 0xFF) + (p01 >> 16 & 0xFF) + (p10 >> 16 & 0xFF) + (p11 >> 16 & 0xFF);
        int g = (p00 >> 8 & 0xFF) + (p01 >> 8 & 0xFF) + (p10 >> 8 & 0xFF) + (p11 >> 8 & 0xFF);
        int b = (p00 & 0xFF) + (p01 & 0xFF) + (p10 & 0xFF) + (p11 & 0xFF);
        return 0xFF000000 | ((r >>= 2) & 0xFF) << 16 | ((g >>= 2) & 0xFF) << 8 | (b >>= 2) & 0xFF;
    }

    public static int getAverageColourOfArray(int[] pixels) {
        int count = 0;
        double totalA = 0.0;
        double totalR = 0.0;
        double totalG = 0.0;
        double totalB = 0.0;
        for (int pixel : pixels) {
            double a = pixel >> 24 & 0xFF;
            double r = pixel >> 16 & 0xFF;
            double g = pixel >> 8 & 0xFF;
            double b = pixel & 0xFF;
            totalA += a;
            totalR += r * a / 255.0;
            totalG += g * a / 255.0;
            totalB += b * a / 255.0;
            ++count;
        }
        totalR = totalR * 255.0 / totalA;
        totalG = totalG * 255.0 / totalA;
        totalB = totalB * 255.0 / totalA;
        return ((int)(totalA /= (double)count) & 0xFF) << 24 | ((int)totalR & 0xFF) << 16 | ((int)totalG & 0xFF) << 8 | (int)totalB & 0xFF;
    }

    public static int adjustPixelBrightness(int colour, int brightness) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        r = Math.min(Math.max(0, r + brightness), 255);
        g = Math.min(Math.max(0, g + brightness), 255);
        b = Math.min(Math.max(0, b + brightness), 255);
        return colour & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getTextureWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public static int getTextureHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public static int getBoundTextureId() {
        return GL11.glGetInteger((int)32873);
    }

    public static void printBoundTextureInfo(int texture) {
        int w = Render.getTextureWidth();
        int h = Render.getTextureHeight();
        int depth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)32881);
        int format = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        Logging.log("texture %d parameters: width=%d, height=%d, depth=%d, format=%08x", texture, w, h, depth, format);
    }

    public static int getMaxTextureSize() {
        return GL11.glGetInteger((int)3379);
    }

    public static void drawTexturedRect(double x, double y, double w, double h) {
        Render.drawTexturedRect(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawTexturedRectRotate(double x, double y, double w, double h, float angle) {
        Render.drawTexturedRectRotate(x, y, w, h, 0.0, 0.0, 1.0, 1.0, angle);
    }

    public static void drawTexturedRect(double x, double y, double w, double h, double u1, double v1, double u2, double v2) {
        try {
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(x + w, y, zDepth).func_187315_a(u2, v1).func_181675_d();
            vertexbuffer.func_181662_b(x, y, zDepth).func_187315_a(u1, v1).func_181675_d();
            vertexbuffer.func_181662_b(x, y + h, zDepth).func_187315_a(u1, v2).func_181675_d();
            vertexbuffer.func_181662_b(x + w, y + h, zDepth).func_187315_a(u2, v2).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
        }
        catch (NullPointerException e) {
            Logging.log("MwRender.drawTexturedRect: null pointer exception", new Object[0]);
        }
    }

    private static void drawTexturedRectRotate(double x, double y, double w, double h, double u1, double v1, double u2, double v2, float angle) {
        try {
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double x1 = x + Math.cos(angle) * w;
            double y1 = y + Math.sin(angle) * w;
            vertexbuffer.func_181662_b(x1 + w, y1, zDepth).func_187315_a(u2, v1).func_181675_d();
            vertexbuffer.func_181662_b(x1, y1, zDepth).func_187315_a(u1, v1).func_181675_d();
            vertexbuffer.func_181662_b(x1, y1 + h, zDepth).func_187315_a(u1, v2).func_181675_d();
            vertexbuffer.func_181662_b(x1 + w, y1 + h, zDepth).func_187315_a(u2, v2).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
        }
        catch (NullPointerException e) {
            Logging.log("MwRender.drawTexturedRect: null pointer exception", new Object[0]);
        }
    }

    public static void drawArrow(double x, double y, double angle, double length) {
        double arrowBackAngle = 2.356194490192345;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(x + length * Math.cos(angle), y + length * Math.sin(angle), zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x + length * 0.5 * Math.cos(angle - arrowBackAngle), y + length * 0.5 * Math.sin(angle - arrowBackAngle), zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x + length * 0.3 * Math.cos(angle + Math.PI), y + length * 0.3 * Math.sin(angle + Math.PI), zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x + length * 0.5 * Math.cos(angle + arrowBackAngle), y + length * 0.5 * Math.sin(angle + arrowBackAngle), zDepth).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(x1, y1, zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x2, y2, zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x3, y3, zDepth).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawRect(double x, double y, double w, double h) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(x + w, y, zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x, y, zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x, y + h, zDepth).func_181675_d();
        vertexbuffer.func_181662_b(x + w, y + h, zDepth).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircle(double x, double y, double r) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(x, y, zDepth).func_181675_d();
        double end = Math.PI * 2;
        double incr = end / 30.0;
        for (double theta = -incr; theta < end; theta += incr) {
            vertexbuffer.func_181662_b(x + r * Math.cos(-theta), y + r * Math.sin(-theta), zDepth).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircleSteps(double x, double y, double r, double steps) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(x, y, zDepth).func_181675_d();
        double end = Math.PI * 2;
        double incr = end / 30.0;
        for (double theta = -incr; theta < end; theta += incr) {
            vertexbuffer.func_181662_b(x + r * Math.cos(-theta), y + r * Math.sin(-theta), zDepth).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawCircleBorder(double x, double y, double r, double width) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181705_e);
        double end = Math.PI * 2;
        double incr = end / 30.0;
        double r2 = r + width;
        for (double theta = -incr; theta < end; theta += incr) {
            vertexbuffer.func_181662_b(x + r * Math.cos(-theta), y + r * Math.sin(-theta), zDepth).func_181675_d();
            vertexbuffer.func_181662_b(x + r2 * Math.cos(-theta), y + r2 * Math.sin(-theta), zDepth).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawRectBorder(double x, double y, double w, double h, double bw) {
        Render.drawRect(x - bw, y - bw, w + bw + bw, bw);
        Render.drawRect(x - bw, y + h, w + bw + bw, bw);
        Render.drawRect(x - bw, y, bw, h);
        Render.drawRect(x + w, y, bw, h);
    }

    public static void drawString(int x, int y, int colour, String formatString, Object ... args) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        String s = String.format(formatString, args);
        fr.func_175063_a(s, (float)x, (float)y, colour);
    }

    public static void drawCentredString(int x, int y, int colour, String formatString, Object ... args) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        String s = String.format(formatString, args);
        int w = fr.func_78256_a(s);
        fr.func_175063_a(s, (float)x - (float)w / 2.0f, (float)y, colour);
    }

    public static void setCircularStencil(double x, double y, double r) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)519);
        Render.setColour(-1);
        zDepth = 0.0;
        Render.drawCircle(x, y, r);
        zDepth = -1.0;
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)516);
    }

    public static void disableStencil() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        zDepth = 0.0;
    }
}

