/*
 * Decompiled with CFR 0.152.
 */
package pixelradar.util;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.chunk.Chunk;
import pixelradar.config.Config;
import pixelradar.util.Logging;
import pixelradar.util.Reference;

public class Utils {
    public static String RealmsWorldName = "";
    private static final int[] COLOURS = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFF8000, 0x8000FF};
    public static int colourIndex = 0;

    public static boolean judgeFloat(float a, float b) {
        return (double)Math.abs(a - b) < 1.0E-6;
    }

    public static int[] integerListToIntArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static String mungeString(String s) {
        s = s.replace('.', '_');
        s = s.replace('-', '_');
        s = s.replace(' ', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return Reference.patternInvalidChars.matcher(s).replaceAll("");
    }

    public static String mungeStringForConfig(String s) {
        return Reference.patternInvalidChars2.matcher(s).replaceAll("");
    }

    public static File getFreeFilename(File dir, String baseName, String ext) {
        int i;
        File outputFile = dir != null ? new File(dir, baseName + "." + ext) : new File(baseName + "." + ext);
        for (i = 0; outputFile.exists() && i < 1000; ++i) {
            outputFile = dir != null ? new File(dir, baseName + "." + i + "." + ext) : new File(baseName + "." + i + "." + ext);
        }
        return i < 1000 ? outputFile : null;
    }

    public static void printBoth(String msg) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(msg), false);
        }
        Logging.log("%s", msg);
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        if (size < 1) {
            int newSize = Minecraft.func_71369_N();
            return ByteBuffer.allocateDirect(newSize * newSize * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static int nextHighestPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }

    public static String getCurrentDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        return dateFormat.format(new Date());
    }

    public static int distToChunkSq(int x, int z, Chunk chunk) {
        int dx = (chunk.field_76635_g << 4) + 8 - x;
        int dz = (chunk.field_76647_h << 4) + 8 - z;
        return dx * dx + dz * dz;
    }

    public static String loadServerName() {
        String serverName;
        if (Minecraft.func_71410_x().func_71387_A()) {
            IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
            serverName = server != null ? server.func_71270_I() : "sp_world";
        } else if (Minecraft.func_71410_x().func_181540_al()) {
            serverName = !"".equals(RealmsWorldName) ? RealmsWorldName : "Realms";
        } else {
            serverName = Optional.ofNullable(Minecraft.func_71410_x().func_147104_D()).orElse((ServerData)new ServerData((String)"anonymous_server", (String)"", (boolean)false)).field_78845_b;
            serverName = !Config.portNumberInWorldNameEnabled ? serverName.substring(0, serverName.indexOf(":")) : (!serverName.contains(":") ? serverName + "_25565" : serverName.replace(":", "_"));
        }
        serverName = Utils.mungeString(serverName);
        if ("".equals(serverName)) {
            serverName = "default";
        }
        return serverName;
    }

    public static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable) {
            Logging.logError("Couldn't open link %s", Arrays.toString(throwable.getStackTrace()));
        }
    }

    public static String stringArrayToString(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for (String s : arr) {
            builder.append(I18n.func_135052_a((String)s, (Object[])new Object[0]));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static int getMaxWidth(String[] arr, String[] arr2) {
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        int width = 1;
        for (int i = 0; i < arr.length; ++i) {
            int w2 = 0;
            String s = I18n.func_135052_a((String)arr[i], (Object[])new Object[0]);
            int w1 = fontRendererObj.func_78256_a(s);
            if (arr2 != null && i < arr2.length) {
                s = I18n.func_135052_a((String)arr2[i], (Object[])new Object[0]);
                w2 = fontRendererObj.func_78256_a(s);
                w2 += 65;
            }
            int wTot = Math.max(w1, w2);
            width = Math.max(width, wTot);
        }
        return width;
    }

    private static int getColoursLength() {
        return COLOURS.length;
    }

    public static int getCurrentColour() {
        return 0xFF000000 | COLOURS[colourIndex];
    }

    public static int getNextColour() {
        colourIndex = (colourIndex + 1) % Utils.getColoursLength();
        return Utils.getCurrentColour();
    }

    public static int getPrevColour() {
        colourIndex = (colourIndex + Utils.getColoursLength() - 1) % Utils.getColoursLength();
        return Utils.getCurrentColour();
    }

    public static <K, V> Map<K, V> checkedMapByCopy(Map rawMap, Class<K> keyType, Class<V> valueType, boolean strict) throws ClassCastException {
        HashMap<K, V> m2 = new HashMap<K, V>(rawMap.size() * 4 / 3 + 1);
        Iterator iterator = rawMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            try {
                m2.put(keyType.cast(e.getKey()), valueType.cast(e.getValue()));
            }
            catch (ClassCastException x) {
                if (strict) {
                    throw x;
                }
                System.out.println("not assignable");
            }
        }
        return m2;
    }

    public static Field findUnderlying(Class<?> clazz, String fieldName) {
        Class<?> current = clazz;
        while (true) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                if ((current = current.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    private static String[] getLocalizedStringArray(String[] str, String translateKey) {
        String[] res = new String[str.length];
        for (int i = 0; i < str.length; ++i) {
            res[i] = "".equals(str[i]) ? "" : I18n.func_135052_a((String)(translateKey + str[i].toLowerCase()), (Object[])new Object[0]);
        }
        return res;
    }

    public static String[] getLocalizedBgModeArray(String[] mode) {
        return Utils.getLocalizedStringArray(mode, "mw.config.backgroundTextureMode.");
    }

    public static String[] getLocalizedHelpText(String[] str) {
        return Utils.getLocalizedStringArray(str, "mw.gui.mwgui.helptext.");
    }

    public static String[] getLocalizedHelpTextKey(String[] str) {
        String[] res = Utils.getLocalizedStringArray(str, "mw.gui.mwgui.helptext.key.");
        for (int i = 2; i < res.length; ++i) {
            res[i] = "  " + res[i];
        }
        return res;
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }
}

