/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.LiteLoaderUpdateSite;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.interfaces.PanelManager;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.lwjgl.input.Keyboard;

public class LiteLoaderPanelManager
implements PanelManager<blk> {
    private static final int UPDATE_CHECK_INTERVAL = 10;
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private LiteLoaderMods mods;
    private ConfigManager configManager;
    private bib minecraft;
    private boolean displayModInfoScreenTab = true;
    private boolean tabAlwaysExpanded = false;
    private boolean hideModInfoScreenTab = false;
    private boolean checkForUpdate = false;
    private String notification;
    private GuiLiteLoaderPanel panelHost;

    public LiteLoaderPanelManager(GameEngine<?, ?> engine, LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
        this.properties = properties;
        this.minecraft = (bib)engine.getClient();
        this.displayModInfoScreenTab = this.properties.getAndStoreBooleanProperty("modInfoScreen", true);
        this.tabAlwaysExpanded = this.properties.getAndStoreBooleanProperty("tabAlwaysExpanded", false);
        if (this.shouldCheckForUpdates()) {
            int updateCheckInterval = this.properties.getIntegerProperty("updateCheckInterval") + 1;
            LiteLoaderLogger.debug("Regular update check enabled, updateCheckInterval = %d", updateCheckInterval);
            if (LiteLoader.isSnapshot() || updateCheckInterval > 10) {
                LiteLoaderLogger.debug("Checking for updates...", new Object[0]);
                this.checkForUpdate = true;
                updateCheckInterval = 0;
            }
            this.properties.setIntegerProperty("updateCheckInterval", updateCheckInterval);
            this.properties.writeProperties();
        }
    }

    private boolean shouldCheckForUpdates() {
        if (LiteLoader.isSnapshot() && this.properties.getAndStoreBooleanProperty("checkForNewSnapshots", true)) {
            return true;
        }
        return this.properties.getAndStoreBooleanProperty("allowForceUpdate", false);
    }

    @Override
    public void init(LiteLoaderMods mods, ConfigManager configManager) {
        this.mods = mods;
        this.configManager = configManager;
    }

    @Override
    public void onStartupComplete() {
        if (this.checkForUpdate) {
            LiteLoaderVersion.getUpdateSite().beginUpdateCheck();
        }
    }

    @Override
    public void onTick(boolean clock, float partialTicks, boolean inGame) {
        LiteLoaderUpdateSite updateSite;
        if (clock && this.panelHost != null && this.minecraft.m != this.panelHost) {
            this.panelHost.e();
        }
        if (clock && this.checkForUpdate && !(updateSite = LiteLoaderVersion.getUpdateSite()).isCheckInProgress() && updateSite.isCheckComplete()) {
            LiteLoaderLogger.debug("Scheduled update check completed, success=%s", updateSite.isCheckSucceess());
            this.checkForUpdate = false;
            if (updateSite.isCheckSucceess() && updateSite.isUpdateAvailable()) {
                this.setNotification(cey.a((String)("gui.notifications." + (LiteLoader.isSnapshot() ? "newsnapshotavailable" : "updateavailable")), (Object[])new Object[]{updateSite.getAvailableVersion(), updateSite.getAvailableVersionDate()}));
            }
        }
    }

    @Override
    public void onPostRender(int mouseX, int mouseY, float partialTicks) {
        boolean tabHidden;
        if (this.mods == null) {
            return;
        }
        boolean bl2 = tabHidden = this.isTabHidden() && this.minecraft.m instanceof blr;
        if (this.isPanelSupportedOnScreen(this.minecraft.m) && (this.displayModInfoScreenTab && !tabHidden || this.panelHost != null && this.panelHost.isOpen())) {
            if (this.panelHost == null || this.panelHost.getScreen() != this.minecraft.m) {
                this.panelHost = new GuiLiteLoaderPanel(this.minecraft, this.minecraft.m, this.mods, this.environment, this.properties, this.configManager, !tabHidden);
                if (this.notification != null) {
                    this.panelHost.setNotification(this.notification);
                }
            }
            this.minecraft.o.j();
            this.panelHost.drawScreen(mouseX, mouseY, partialTicks, this.tabAlwaysExpanded);
        } else if (this.minecraft.m != this.panelHost && this.panelHost != null) {
            this.panelHost.release();
            this.panelHost = null;
        } else if (this.isPanelSupportedOnScreen(this.minecraft.m) && Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)15)) {
            this.displayLiteLoaderPanel(this.minecraft.m);
        }
    }

    @Override
    public void hideTab() {
        this.hideModInfoScreenTab = true;
    }

    private boolean isTabHidden() {
        return this.hideModInfoScreenTab && this.getStartupErrorCount() == 0 && this.notification == null;
    }

    @Override
    public void setTabVisible(boolean show) {
        this.displayModInfoScreenTab = show;
        this.properties.setBooleanProperty("modInfoScreen", show);
        this.properties.writeProperties();
    }

    @Override
    public boolean isTabVisible() {
        return this.displayModInfoScreenTab;
    }

    @Override
    public void setTabAlwaysExpanded(boolean expand) {
        this.tabAlwaysExpanded = expand;
        this.properties.setBooleanProperty("tabAlwaysExpanded", expand);
        this.properties.writeProperties();
    }

    @Override
    public boolean isTabAlwaysExpanded() {
        return this.tabAlwaysExpanded;
    }

    @Override
    public void setForceUpdateEnabled(boolean forceUpdate) {
        this.properties.setBooleanProperty("allowForceUpdate", forceUpdate);
        this.properties.writeProperties();
    }

    @Override
    public boolean isForceUpdateEnabled() {
        return this.properties.getBooleanProperty("allowForceUpdate");
    }

    @Override
    public void setCheckForSnapshotsEnabled(boolean checkForSnapshots) {
        this.properties.setBooleanProperty("checkForNewSnapshots", checkForSnapshots);
        this.properties.writeProperties();
    }

    @Override
    public boolean isCheckForSnapshotsEnabled() {
        return this.properties.getBooleanProperty("checkForNewSnapshots");
    }

    @Override
    public void displayLiteLoaderPanel(blk parentScreen) {
        if (this.isPanelSupportedOnScreen(parentScreen)) {
            this.panelHost = new GuiLiteLoaderPanel(this.minecraft, parentScreen, this.mods, this.environment, this.properties, this.configManager, !this.isTabHidden());
            this.minecraft.a((blk)this.panelHost);
        }
    }

    @Override
    public int getStartupErrorCount() {
        return this.mods.getStartupErrorCount();
    }

    @Override
    public int getCriticalErrorCount() {
        return this.mods.getCriticalErrorCount();
    }

    @Override
    public void setNotification(String notification) {
        LiteLoaderLogger.debug("Setting notification: " + notification, new Object[0]);
        this.notification = notification;
        if (this.panelHost != null) {
            this.panelHost.setNotification(notification);
        }
    }

    private boolean isPanelSupportedOnScreen(blk guiScreen) {
        return guiScreen instanceof blr || guiScreen instanceof blg || guiScreen instanceof ble;
    }
}

