/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui;

import com.mumfrey.liteloader.client.gui.GuiCheckbox;
import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.client.gui.GuiPanel;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.interfaces.PanelManager;

class GuiPanelSettings
extends GuiPanel {
    private final GuiLiteLoaderPanel parentScreen;
    private final boolean isSnapshot;
    private GuiCheckbox chkShowTab;
    private GuiCheckbox chkNoHide;
    private GuiCheckbox chkForceUpdate;
    private GuiCheckbox chkCheckForSnapshots;
    private boolean hide;
    private String[] helpText = new String[5];

    GuiPanelSettings(GuiLiteLoaderPanel parentScreen, bib minecraft) {
        super(minecraft);
        this.parentScreen = parentScreen;
        this.isSnapshot = LiteLoader.isSnapshot();
        String helpKey = this.isSnapshot ? "checkforsnapshots" : "forceupdate";
        this.helpText[0] = cey.a((String)"gui.settings.showtab.help1", (Object[])new Object[0]);
        this.helpText[1] = cey.a((String)"gui.settings.showtab.help2", (Object[])new Object[0]);
        this.helpText[2] = cey.a((String)"gui.settings.notabhide.help1", (Object[])new Object[0]);
        this.helpText[3] = cey.a((String)("gui.settings." + helpKey + ".help1"), (Object[])new Object[0]);
        this.helpText[4] = cey.a((String)("gui.settings." + helpKey + ".help2"), (Object[])new Object[0]);
    }

    @Override
    public void close() {
        this.hide = true;
    }

    @Override
    boolean isCloseRequested() {
        boolean hide = this.hide;
        this.hide = false;
        return hide;
    }

    @Override
    void setSize(int width, int height) {
        super.setSize(width, height);
        this.controls.add(new bja(-1, this.width - 99 - 12, this.height - 40 + 9, 100, 20, cey.a((String)"gui.done", (Object[])new Object[0])));
        this.chkShowTab = new GuiCheckbox(0, 34, 90, cey.a((String)"gui.settings.showtab.label", (Object[])new Object[0]));
        this.controls.add(this.chkShowTab);
        this.chkNoHide = new GuiCheckbox(1, 34, 128, cey.a((String)"gui.settings.notabhide.label", (Object[])new Object[0]));
        this.controls.add(this.chkNoHide);
        this.chkForceUpdate = new GuiCheckbox(2, 34, 158, cey.a((String)"gui.settings.forceupdate.label", (Object[])new Object[0]));
        this.controls.add(this.chkForceUpdate);
        this.chkCheckForSnapshots = new GuiCheckbox(2, 34, 158, cey.a((String)"gui.settings.checkforsnapshots.label", (Object[])new Object[0]));
        this.controls.add(this.chkCheckForSnapshots);
        this.chkForceUpdate.m = !this.isSnapshot;
        this.chkCheckForSnapshots.m = this.isSnapshot;
        this.updateCheckBoxes();
    }

    private void updateCheckBoxes() {
        PanelManager panelManager = LiteLoader.getModPanelManager();
        this.chkShowTab.checked = panelManager.isTabVisible();
        this.chkNoHide.checked = panelManager.isTabAlwaysExpanded();
        this.chkForceUpdate.checked = panelManager.isForceUpdateEnabled();
        this.chkCheckForSnapshots.checked = panelManager.isCheckForSnapshotsEnabled();
    }

    private void updateSettings() {
        PanelManager panelManager = LiteLoader.getModPanelManager();
        panelManager.setTabVisible(this.chkShowTab.checked);
        panelManager.setTabAlwaysExpanded(this.chkNoHide.checked);
        panelManager.setForceUpdateEnabled(this.chkForceUpdate.checked);
        panelManager.setCheckForSnapshotsEnabled(this.chkCheckForSnapshots.checked);
    }

    @Override
    void draw(int mouseX, int mouseY, float partialTicks) {
        this.parentScreen.drawInfoPanel(mouseX, mouseY, partialTicks, 0, 38);
        bip fontRenderer = this.mc.k;
        int brandColour = this.parentScreen.getBrandColour();
        fontRenderer.a(this.helpText[0], 50, 104, brandColour);
        fontRenderer.a(this.helpText[1], 50, 114, brandColour);
        fontRenderer.a(this.helpText[2], 50, 142, brandColour);
        fontRenderer.a(this.helpText[3], 50, 172, brandColour);
        fontRenderer.a(this.helpText[4], 50, 182, brandColour);
        super.draw(mouseX, mouseY, partialTicks);
    }

    @Override
    void actionPerformed(bja control) {
        if (control.k == -1) {
            this.close();
            return;
        }
        if (control instanceof GuiCheckbox) {
            ((GuiCheckbox)control).checked = !((GuiCheckbox)control).checked;
            this.updateSettings();
        }
    }

    @Override
    void keyPressed(char keyChar, int keyCode) {
        if (keyCode == 1) {
            this.close();
        }
    }

    @Override
    void onTick() {
    }

    @Override
    void onHidden() {
    }

    @Override
    void onShown() {
    }

    @Override
    void mouseMoved(int mouseX, int mouseY) {
    }

    @Override
    void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    void mouseWheelScrolled(int mouseWheelDelta) {
    }
}

