/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.transformers;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CrashReportTransformer
extends ClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && (Obf.CrashReport$6.name.equals(name) || Obf.CrashReport$6.obf.equals(name))) {
            try {
                return this.transformCallableJVMFlags(basicClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return basicClass;
    }

    private byte[] transformCallableJVMFlags(byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass, true);
        for (MethodNode method : classNode.methods) {
            if (!"<init>".equals(method.name)) continue;
            this.transformCallableJVMFlagsConstructor(method);
        }
        return this.writeClass(classNode);
    }

    public void transformCallableJVMFlagsConstructor(MethodNode ctor) {
        InsnList code = new InsnList();
        code.add((AbstractInsnNode)new VarInsnNode(25, 1));
        code.add((AbstractInsnNode)new MethodInsnNode(184, "com/mumfrey/liteloader/core/LiteLoader", "populateCrashReport", "(Ljava/lang/Object;)V", false));
        for (AbstractInsnNode insnNode : ctor.instructions) {
            if (insnNode.getOpcode() != 177) continue;
            ctor.instructions.insertBefore(insnNode, code);
        }
    }
}

