/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.PacketHandler;
import com.mumfrey.liteloader.ServerChatFilter;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEventBroker;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public abstract class PacketEvents
implements InterfaceProvider {
    protected static PacketEvents instance;
    protected final LiteLoader loader;
    private PacketHandlerList[] packetHandlers = new PacketHandlerList[Packets.count()];
    private FastIterable<ServerChatFilter> serverChatFilters = new HandlerList<ServerChatFilter>(ServerChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private final int loginSuccessPacketId = Packets.SPacketLoginSuccess.getIndex();
    private final int serverChatPacketId = Packets.SPacketChat.getIndex();
    private final int clientChatPacketId = Packets.CPacketChatMessage.getIndex();
    private final int joinGamePacketId = Packets.SPacketJoinGame.getIndex();
    private final int serverPayloadPacketId = Packets.SPacketCustomPayload.getIndex();
    private final int clientPayloadPacketId = Packets.CPacketCustomPayload.getIndex();
    private final int clientSettingsPacketId = Packets.CPacketClientSettings.getIndex();

    public PacketEvents() {
        instance = this;
        this.loader = LiteLoader.getInstance();
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(PacketHandler.class);
        delegate.registerInterface(ServerChatFilter.class);
    }

    @Override
    public void initProvider() {
    }

    public void registerServerChatFilter(ServerChatFilter serverChatFilter) {
        this.serverChatFilters.add(serverChatFilter);
    }

    public void registerPacketHandler(PacketHandler handler) {
        List<Class<ht<?>>> handledPackets = handler.getHandledPackets();
        if (handledPackets != null) {
            for (Class<ht<?>> packetClass : handledPackets) {
                String packetClassName = packetClass.getName();
                int packetId = Packets.indexOf(packetClassName);
                if (packetId == -1 || packetId >= this.packetHandlers.length) {
                    LiteLoaderLogger.warning("PacketHandler %s attempted to register a handler for unupported packet class %s", handler.getName(), packetClassName);
                    continue;
                }
                if (this.packetHandlers[packetId] == null) {
                    this.packetHandlers[packetId] = new PacketHandlerList();
                }
                this.packetHandlers[packetId].add(handler);
            }
        }
    }

    public static void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler) {
        instance.handlePacket(e, netHandler, e.getPacketId());
    }

    private void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, int packetId) {
        Packets packetInfo = Packets.packets[e.getPacketId()];
        tr threadListener = this.getPacketContextListener(packetInfo.getContext());
        if (threadListener != null && !threadListener.aF()) {
            this.handleAsyncPacketEvent(e, netHandler, packetId);
            return;
        }
        if (this.handlePacketEvent(e, netHandler, packetId) || this.packetHandlers[packetId] == null || e.isCancelled()) {
            return;
        }
        if (((PacketHandler)this.packetHandlers[packetId].all()).handlePacket(netHandler, (ht)e.getSource())) {
            return;
        }
        e.cancel();
    }

    protected abstract tr getPacketContextListener(Packets.Context var1);

    protected void handleAsyncPacketEvent(PacketEventInfo<ht<?>> e, hb netHandler, int packetId) {
        ht packet = (ht)e.getSource();
        if (packetId == this.loginSuccessPacketId) {
            this.handlePacket(e, netHandler, (mh)packet);
        }
    }

    protected boolean handlePacketEvent(PacketEventInfo<ht<?>> e, hb netHandler, int packetId) {
        ht packet = (ht)e.getSource();
        if (packetId == this.serverChatPacketId) {
            this.handlePacket(e, netHandler, (in)packet);
            return true;
        }
        if (packetId == this.clientChatPacketId) {
            this.handlePacket(e, netHandler, (la)packet);
            return true;
        }
        if (packetId == this.joinGamePacketId) {
            this.handlePacket(e, netHandler, (jh)packet);
            return true;
        }
        if (packetId == this.serverPayloadPacketId) {
            this.handlePacket(e, netHandler, (iw)packet);
            return true;
        }
        if (packetId == this.clientPayloadPacketId) {
            this.handlePacket(e, netHandler, (lh)packet);
            return true;
        }
        if (packetId == this.clientSettingsPacketId) {
            this.handlePacket(e, netHandler, (lc)packet);
            return true;
        }
        return false;
    }

    protected abstract void handlePacket(PacketEventInfo<ht<?>> var1, hb var2, mh var3);

    protected abstract void handlePacket(PacketEventInfo<ht<?>> var1, hb var2, in var3);

    protected void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, la packet) {
        oq player;
        oq oq2 = player = netHandler instanceof pa ? ((pa)netHandler).b : null;
        if (!this.serverChatFilters.all().onChat(player, packet, packet.a())) {
            e.cancel();
        }
    }

    protected void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, jh packet) {
        this.loader.onJoinGame(netHandler, packet);
    }

    protected void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, iw packet) {
        LiteLoader.getClientPluginChannels().onPluginChannelMessage(packet);
    }

    protected void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, lh packet) {
        LiteLoader.getServerPluginChannels().onPluginChannelMessage(netHandler, packet);
    }

    private void handlePacket(PacketEventInfo<ht<?>> e, hb netHandler, lc packet) {
        if (netHandler instanceof pa) {
            LiteLoaderEventBroker.broker.onPlayerSettingsReceived(((pa)netHandler).b, packet);
        }
    }

    class PacketHandlerList
    extends HandlerList<PacketHandler> {
        private static final long serialVersionUID = 1L;

        PacketHandlerList() {
            super(PacketHandler.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
        }
    }
}

