/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

public final class InjectionStrategy {
    public static final InjectionStrategy TOP = new InjectionStrategy(InjectionPosition.Top, null);
    public static final InjectionStrategy DEFAULT = new InjectionStrategy(InjectionPosition.Bottom, null);
    private final InjectionPosition position;
    private final String[] params;

    private InjectionStrategy(String injectAt) {
        this.position = InjectionPosition.parsePosition(injectAt);
        this.params = this.position.parseParams(injectAt);
    }

    private InjectionStrategy(InjectionPosition position, String[] params) {
        this.position = position;
        this.params = params;
    }

    public InjectionPosition getPosition() {
        return this.position;
    }

    public String[] getParams() {
        return this.params;
    }

    public static InjectionStrategy parseStrategy(String injectAt) {
        return InjectionStrategy.parseStrategy(injectAt, null);
    }

    public static InjectionStrategy parseStrategy(String injectAt, InjectionStrategy defaultStrategy) {
        if (injectAt == null) {
            return defaultStrategy;
        }
        return new InjectionStrategy(injectAt);
    }

    public static enum InjectionPosition {
        Bottom,
        Base,
        Top,
        Above;


        public static InjectionPosition parsePosition(String injectAt) {
            if ("top".equalsIgnoreCase(injectAt)) {
                return Top;
            }
            if ("base".equalsIgnoreCase(injectAt)) {
                return Base;
            }
            if (injectAt != null && injectAt.toLowerCase().startsWith("above:")) {
                return Above;
            }
            return Bottom;
        }

        public String[] parseParams(String injectAt) {
            if (this == Above && injectAt != null) {
                return injectAt.substring(6).split(",");
            }
            return null;
        }
    }
}

