/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player.decoder.mp3;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    private static final int BANDS = 32;
    private final float[] settings = new float[32];

    public void setFrom(float[] eq) {
        this.reset();
        int max = Math.min(eq.length, 32);
        for (int i = 0; i < max; ++i) {
            this.settings[i] = this.limit(eq[i]);
        }
    }

    public void setFrom(EQFunction eq) {
        this.reset();
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = this.limit(eq.getBand(i));
        }
    }

    public void setFrom(Equalizer eq) {
        if (eq != this) {
            this.setFrom(eq.settings);
        }
    }

    public void reset() {
        for (int i = 0; i < 32; ++i) {
            this.settings[i] = 0.0f;
        }
    }

    private float limit(float eq) {
        if (eq == Float.NEGATIVE_INFINITY) {
            return eq;
        }
        if (eq > 1.0f) {
            return 1.0f;
        }
        return Math.max(eq, -1.0f);
    }

    public static abstract class EQFunction {
        public float getBand(int band) {
            return 0.0f;
        }
    }
}

