/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.zmusic.player.decoder.ogg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.concurrent.Semaphore;
import me.zhenxin.zmusic.player.MusicPlayer;
import me.zhenxin.zmusic.player.decoder.BuffPack;
import me.zhenxin.zmusic.player.decoder.IDecoder;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jogg.Packet;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jogg.Page;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jogg.StreamState;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jogg.SyncState;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jorbis.Block;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jorbis.Comment;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jorbis.DspState;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.jorbis.Info;
import me.zhenxin.zmusic.player.decoder.ogg.jcraft.oggdecoder.OggData;

public class OggDecoder
implements IDecoder {
    private final MusicPlayer player;
    private int convsize = 8192;
    private boolean isDone = false;
    private int size;
    private boolean isClose;
    private boolean isOK;
    private final SyncState oy = new SyncState();
    private final StreamState os = new StreamState();
    private final Page og = new Page();
    private final Packet op = new Packet();
    private final Info vi = new Info();
    private final Comment vc = new Comment();
    private final DspState vd = new DspState();
    private final Block vb = new Block(this.vd);
    private final byte[] convbuffer = new byte[this.convsize];
    private OggData ogg;
    private final BuffPack buff = new BuffPack();
    private final Semaphore get1 = new Semaphore(0);
    private final Semaphore get2 = new Semaphore(0);

    public OggDecoder(MusicPlayer player) {
        this.player = player;
    }

    public void getData(InputStream input) throws IOException, InterruptedException {
        boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.oy.init();
        while (true) {
            int bytes;
            boolean eos = false;
            int index = this.oy.buffer(4096);
            byte[] buffer = this.oy.data;
            try {
                bytes = input.read(buffer, index, 4096);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            this.oy.wrote(bytes);
            if (this.oy.pageout(this.og) != 1) {
                if (bytes < 4096) break;
                throw new IOException("Input does not appear to be an Ogg bitstream.");
            }
            this.os.init(this.og.serialno());
            this.vi.init();
            this.vc.init();
            if (this.os.pagein(this.og) < 0) {
                throw new IOException("Error reading first page of Ogg bitstream data.");
            }
            if (this.os.packetout(this.op) != 1) {
                throw new IOException("Error reading initial header packet.");
            }
            if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
            }
            this.ogg = new OggData();
            this.ogg.channels = this.vi.channels;
            this.ogg.rate = this.vi.rate;
            this.isOK = true;
            this.get1.release();
            int i = 0;
            while (i < 2) {
                int result;
                while (i < 2 && (result = this.oy.pageout(this.og)) != 0) {
                    if (result != 1) continue;
                    this.os.pagein(this.og);
                    while (i < 2 && (result = this.os.packetout(this.op)) != 0) {
                        if (result == -1) {
                            throw new IOException("Corrupt secondary header.  Exiting.");
                        }
                        this.vi.synthesis_headerin(this.vc, this.op);
                        ++i;
                    }
                }
                index = this.oy.buffer(4096);
                buffer = this.oy.data;
                try {
                    bytes = input.read(buffer, index, 4096);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                if (bytes == 0 && i < 2) {
                    throw new IOException("End of file before finding all Vorbis headers!");
                }
                this.oy.wrote(bytes);
            }
            this.convsize = 4096 / this.vi.channels;
            this.vd.synthesis_init(this.vi);
            this.vb.init(this.vd);
            float[][][] _pcm = new float[1][][];
            int[] _index = new int[this.vi.channels];
            while (!eos) {
                int result;
                while (!eos && (result = this.oy.pageout(this.og)) != 0) {
                    if (result == -1) {
                        System.err.println("Corrupt or missing data in bitstream; continuing...");
                        continue;
                    }
                    this.os.pagein(this.og);
                    while ((result = this.os.packetout(this.op)) != 0) {
                        int samples;
                        if (result == -1) continue;
                        if (this.vb.synthesis(this.op) == 0) {
                            this.vd.synthesis_blockin(this.vb);
                        }
                        while ((samples = this.vd.synthesis_pcmout(_pcm, _index)) > 0) {
                            float[][] pcm = _pcm[0];
                            int bout = Math.min(samples, this.convsize);
                            for (i = 0; i < this.vi.channels; ++i) {
                                int ptr = i * 2;
                                int mono = _index[i];
                                for (int j = 0; j < bout; ++j) {
                                    int val = (int)((double)pcm[i][mono + j] * 32767.0);
                                    if (val > Short.MAX_VALUE) {
                                        val = Short.MAX_VALUE;
                                    }
                                    if (val < Short.MIN_VALUE) {
                                        val = Short.MIN_VALUE;
                                    }
                                    if (val < 0) {
                                        val |= 0x8000;
                                    }
                                    if (bigEndian) {
                                        this.convbuffer[ptr] = (byte)(val >>> 8);
                                        this.convbuffer[ptr + 1] = (byte)val;
                                    } else {
                                        this.convbuffer[ptr] = (byte)val;
                                        this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                    }
                                    ptr += 2 * this.vi.channels;
                                }
                            }
                            this.get1.acquire();
                            this.size = 2 * this.vi.channels * bout;
                            this.get2.release();
                            if (this.isClose) {
                                return;
                            }
                            this.vd.synthesis_read(bout);
                        }
                    }
                    if (this.og.eos() == 0) continue;
                    eos = true;
                }
                if (eos) continue;
                index = this.oy.buffer(4096);
                buffer = this.oy.data;
                try {
                    bytes = input.read(buffer, index, 4096);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                this.oy.wrote(bytes);
                if (bytes != 0) continue;
                eos = true;
            }
            this.os.clear();
            this.vb.clear();
            this.vd.clear();
            this.vi.clear();
        }
        this.oy.clear();
        this.isDone = true;
        this.get2.release();
    }

    @Override
    public BuffPack decodeFrame() throws Exception {
        this.get1.release();
        this.get2.acquire();
        if (this.isDone || this.isClose) {
            return null;
        }
        this.buff.buff = this.convbuffer;
        this.buff.len = this.size;
        return this.buff;
    }

    @Override
    public void close() throws Exception {
        this.isClose = true;
        this.player.close();
        this.get1.release();
        this.get2.release();
    }

    @Override
    public boolean set() throws Exception {
        new Thread(() -> {
            try {
                this.getData(this.player);
            }
            catch (IOException e) {
                this.isOK = false;
                this.get1.release();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.get1.release();
        }, "allmusic_ogg").start();
        this.get1.acquire();
        return this.isOK;
    }

    @Override
    public int getOutputFrequency() {
        return this.ogg.rate;
    }

    @Override
    public int getOutputChannels() {
        return this.ogg.channels;
    }

    @Override
    public void set(int time) {
    }
}

