#version 400 compatibility

/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/
//temporal aa buffer
const bool colortex4Clear = false;
//these buffers are going to be totally overwritten, saves a few fps to not clear it!
const bool colortex3Clear = false;
const bool colortex0Clear = false;
const bool colortex1Clear = false;



	#define SHADOW_MAP_BIAS 0.8
#define UNDERWATERFIX //fixes shadows and other stuff underwater
/*--------------------------------*/
in vec2 texcoord;
in float tempSample;
in float mulfov;

uniform sampler2D depthtex2;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D shadow;

const int 		noiseTextureResolution  = 128;
uniform vec3 cameraPosition;

uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
uniform int heldBlockLightValue;

float comp = 1.0-near/far/far;			//distance above that are considered as sky
float invRain06 = 1.0-rainStrength*0.6;


#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}
vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
vec3 toScreenSpace(vec3 p) {
        vec3 p3 = p * 2. - 1.;
        vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
        return fragposition.xyz / fragposition.w;
}

vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n = vec3(fenc*g,1.-f*0.5);
    return n;
}

float bayer2(vec2 a){
    a = floor(a);
    return fract( a.x*.5+a.y*a.y*.75 );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  fract(bayer16(.5*(a))*.25+bayer2(a)+tempSample)




//spiral sampling (numbers tweaked for 9 samples)
vec2 tapLocation(int sampleNumber, float spinAngle,int nb, float nbRot,float r0)
{
    float alpha = (float(sampleNumber*1.0f + r0) * (1.0 / (nb)));
    float angle = alpha * (nbRot * 6.28) + spinAngle;

    float ssR = alpha;
    float sin_v, cos_v;

	sin_v = sin(angle);
	cos_v = cos(angle);
	
    return vec2(cos_v, sin_v)*ssR;
}

void ssao(inout float occlusion,  vec2 tex,vec3 fragpos,float mulfov,float dither)
{
	const float tan70 = tan(70.*3.14/180.);
	float mulfov2 = gbufferProjection[1][1]/tan70; 

	const float PI = 3.14159265;
	const float samplingRadius = 0.712;
	vec2 radius = clamp(0.712/ (-fragpos.zz),6.0/vec2(viewWidth,viewHeight),vec2(0.5));
	float angle_thresh = 0.025;


	float noise2 = dither;
	float noise = noise2*(PI*2.);


	vec3 normal = decode(texture2DLod(gdepth,tex,0).xy);
	vec2 rd = vec2(radius.x,radius.y*aspectRatio)*mulfov2*vec2(viewWidth,viewHeight);
	//pre-rotate direction
	float n =0.;

	occlusion = 0.0;
	ivec2 pos = ivec2(gl_FragCoord.xy);
	vec2 acc = 0.5/vec2(viewWidth,viewHeight);
	
	for (int i = 0; i < 7; i++){		
		vec2 sp = tapLocation(i,noise,7,3.,noise2);
		vec2 sampleOffset = sp*rd;	
		ivec2 offset = ivec2(gl_FragCoord.xy + sampleOffset); 
		if (offset.x < viewWidth && offset.y < viewHeight && offset.x > 0. && offset.y > 0.){
		vec3 t0 = toScreenSpace(vec3(offset/vec2(viewWidth,viewHeight)+acc,texelFetch(depthtex2,offset,0).x));

		vec3 vec = t0.xyz*vec3(mulfov,mulfov,1.) - fragpos;
		float dsquared = dot(vec,vec);
		float NdotV = clamp(dot(vec*inversesqrt(max(dsquared,0.000001)), normal)-angle_thresh,0.,1.);

		occlusion += NdotV * samplingRadius/(samplingRadius+dsquared);
		n += 1.;
		}
		}

		occlusion = 1.-pow(occlusion*n/7.*0.15,0.4);

}




vec3 toShadowSpace(vec3 p3){
    p3 = mat3(gbufferModelViewInverse) * p3 + gbufferModelViewInverse[3].xyz;
    p3 = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
    p3 = diagonal3(shadowProjection) * p3 + shadowProjection[3].xyz;

    return p3;
}
float getVolumetricRays(vec2 texcoord, float dither,vec3 fragpos) {		
		int maxIT = 6; 
		
		//project pixel position into projected shadowmap space
		vec3 fragposition = toShadowSpace(fragpos);
		

		
		//project view origin into projected shadowmap space
		vec3 start = toShadowSpace(vec3(0.));

		
		//rayvector into projected shadow map space
		//we can use a projected vector because its orthographic projection
		//however we still have to send it to curved shadow map space every step
		vec3 dV = (fragposition-start)/(maxIT);
		
		//apply dither
		vec3 progress = start.xyz + dV*dither;
		
		float vL = 0.0;
		float total_extinction = 1.0;

		for (int i=0;i<maxIT;i++) {
			//project into biased shadowmap space
			vec2 pos = abs(progress.xy) * 1.165;
			float distb = pow(pow(pos.x, 12.) + pow(pos.y, 12.), 1.0 / 12.0);
			float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
			pos = progress.xy/distortFactor;

			vec4 sampleS = textureGather( shadow, pos*(0.5/0.97)+0.5, 0);

			sampleS = step(sampleS,vec4(progress.z*0.5/2.5+0.5));
			
			vec2 filterWeight = fract(pos*(0.5/0.97*4096.)+0.5*4096. - 0.5);
			float temp0 = mix( sampleS.x, sampleS.y, filterWeight.x );
			float temp1 = mix( sampleS.w, sampleS.z, filterWeight.x );
	
			vL += mix( temp1, temp0, filterWeight.y )/maxIT;
			
			//advance the ray
			progress += dV;
	
		}
		
	return 1.0-vL;


		
}

float BlueNoise(){
	vec2 nrep = vec2(viewWidth,viewHeight)/32.;
	vec2 nTC = mod(gl_FragCoord.xy,32.);
	 return fract(texelFetch(noisetex,ivec2(nTC),0).x+tempSample);
	
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {

float occlusion = 1.;
float vL = 0.5;
vec2 ntc = texcoord.xy;

float Depth = texture2D(depthtex2, ntc).x;
vec4 albedo = texture2D(gcolor,ntc);
bool land = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 || (Depth > comp));
bool land2 = !(dot(albedo.rgb,vec3(1.0))<0.00000000001 || (texture2D(depthtex0, ntc).x > comp));



vec3 fragpos = toScreenSpace(vec3(ntc,Depth));
fragpos.xy *= mulfov;


float noise = BlueNoise();
if (land) ssao(occlusion,ntc,fragpos.xyz,mulfov,noise);
if (land2) vL = getVolumetricRays(ntc,noise,fragpos);





/* DRAWBUFFERS:3 */
	gl_FragData[0] = vec4(occlusion,vL,0.,1.0);


}
