#version 400 compatibility

const bool		colortex4MipmapEnabled = true;
/*






!! DO NOT REMOVE !! !! DO NOT REMOVE !!

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !! !! DO NOT REMOVE !!


Sharing and modification rules

Sharing a modified version of my shaders:
-You are not allowed to claim any of the code included in "Chocapic13' shaders" as your own
-You can share a modified version of my shaders if you respect the following title scheme : " -Name of the shaderpack- (Chocapic13' Shaders edit) "
-You cannot use any monetizing links
-The rules of modification and sharing have to be same as the one here (copy paste all these rules in your post), you cannot make your own rules
-I have to be clearly credited
-You cannot use any version older than "Chocapic13' Shaders V4" as a base, however you can modify older versions for personal use
-Common sense : if you want a feature from another shaderpack or want to use a piece of code found on the web, make sure the code is open source. In doubt ask the creator.
-Common sense #2 : share your modification only if you think it adds something really useful to the shaderpack(not only 2-3 constants changed)


Special level of permission; with written permission from Chocapic13, if you think your shaderpack is an huge modification from the original (code wise, the look/performance is not taken in account):
-Allows to use monetizing links
-Allows to create your own sharing rules
-Shaderpack name can be chosen
-Listed on Chocapic13' shaders official thread
-Chocapic13 still have to be clearly credited


Using this shaderpack in a video or a picture:
-You are allowed to use this shaderpack for screenshots and videos if you give the shaderpack name in the description/message
-You are allowed to use this shaderpack in monetized videos if you respect the rule above.


Minecraft website:
-The download link must redirect to the link given in the shaderpack's official thread
-You are not allowed to add any monetizing link to the shaderpack download

If you are not sure about what you are allowed to do or not, PM Chocapic13 on http://www.minecraftforum.net/
Not respecting these rules can and will result in a request of thread/download shutdown to the host/administrator, with or without warning. Intellectual property stealing is punished by law.











*/

#define UNDERWATERFIX //fixes shadows and other stuff underwater
//#define BANDINGFIX //enable this only if you are using minecraft 1.8.9 and lower
	//#define GODRAYS			//in this step previous godrays result is blurred
		const float exposure = 1.05;			//godrays intensity
		const float density = 1.0;
		const float grnoise = 0.0;		//amount of noise


//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int maxf = 6;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.07;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step

const vec3 moonlight = vec3(0.55, 0.9, 1.35) * 0.001;
const vec3 moonlightS = vec3(0.5, 0.9, 1.4) * 0.001;
/*--------------------------------*/
in vec2 texcoord;

in vec3 sunVec;
in vec3 moonVec;
in vec3 upVec;

in vec3 trueSunlight;
in vec3 sunlight;
in float tempSample;
in float tr;

in float sunVisibility;
in float moonVisibility;
in vec2 tempOffset;

uniform sampler2D composite;
uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex2;

uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D noisetex;
uniform sampler2D gaux3;
uniform sampler2D gaux2;
uniform sampler2D colortex4;
uniform sampler2D gaux4;
uniform sampler2D depthtex1;


uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int frameCounter;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
float comp = 1.0-near/far/far;


float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

	
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)

#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toClipSpace3(vec3 viewSpacePosition) {
    return projMAD(gbufferProjection, viewSpacePosition) / -viewSpacePosition.z * 0.5 + 0.5;
}
vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
vec3 toScreenSpace(vec3 p) {
        vec3 p3 = p * 2. - 1.;
        vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
        return fragposition.xyz / fragposition.w;
}



vec3 drawSun(vec3 fposition,vec3 color,float vis) {
vec3 sVector = normalize(fposition);

float angle = (1.0-max(dot(sVector,sunVec),0.0));
float sun = 1.0-smoothstep(0.0010,0.002,angle);
sun *= (1.0-rainStrength*0.9925)*sunVisibility;
vec3 sunlightB = mix(pow(sunlight,vec3(1.0))*2.2*40,vec3(0.25,0.3,0.4),rainStrength*0.8);

return mix(color,sunlightB,sun*vis);

}





vec4 ld4(vec4 depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}





vec3 rayTrace(vec3 dir,vec3 position,float dither){

    const float quality = 25.;
    vec3 clipPosition = toClipSpace3(position);
    vec3 direction = normalize(toClipSpace3(position+dir)-clipPosition);  //convert to clip space
    direction.xy = normalize(direction.xy);
    
    //get at which length the ray intersects with the edge of the screen
    vec3 maxLengths = (step(0.,direction)-clipPosition) / direction;
    float mult = min(min(maxLengths.x,maxLengths.y),maxLengths.z);

    vec3 stepv = direction * mult / quality;
	vec3 spos = clipPosition + stepv*dither;
	
    for (int i = 0; i < int(quality); i++) {
        
        spos += stepv;

        if( texture2D(depthtex0,spos.xy).x <= spos.z ){
            spos -= stepv * .5;
            //refinements
            spos -= stepv * .25     * sign( spos.z - texture2D(depthtex0,spos.xy).x );
            spos -= stepv * .125    * sign( spos.z - texture2D(depthtex0,spos.xy).x );
            spos -= stepv * .0625   * sign( spos.z - texture2D(depthtex0,spos.xy).x );
            spos -= stepv * .03125  * sign( spos.z - texture2D(depthtex0,spos.xy).x );
            spos -= stepv * 0.015625 * sign(spos.z - texture2D(depthtex0,spos.xy).x );
            float rejectSample = texture2D(depthtex0,spos.xy).x;
            if( 
                abs(spos.z-rejectSample) < abs(stepv.z) + .001 / quality //not backface
            )
                return spos;
        }
    }

    return vec3(0.0);
}


float waterH(vec3 posxz,float time) {

float wave = 0.0;



const float amplitude = 0.2;

vec4 waveXYZW = vec4(posxz.xz,posxz.xz)/vec4(250.,50.,-250.,-150.)+vec4(50.,250.,50.,-250.);
vec2 fpxy = abs(fract(waveXYZW.xy*20.0)-0.5)*2.0;

float d = amplitude*length(fpxy);

wave = cos(waveXYZW.x*waveXYZW.y+time) + 0.5 * cos(2.0*waveXYZW.x*waveXYZW.y+time) + 0.25 * cos(4.0*waveXYZW.x*waveXYZW.y+time);

return d*wave + d*(cos(waveXYZW.z*waveXYZW.w+time) + 0.5 * cos(2.0*waveXYZW.z*waveXYZW.w+time) + 0.25 * cos(4.0*waveXYZW.z*waveXYZW.w+time));

}
vec3 decode (vec2 enc)
{
    vec2 fenc = enc*4-2;
    float f = dot(fenc,fenc);
    float g = sqrt(1-f/4.0);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1-f/2;
    return n;
}


float interleaved_gradientNoise(){
	vec2 coord = gl_FragCoord.xy;
	float noise = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	return noise;
}


// earth shadow hack
const float pi = 3.141592653589793238462643383279502884197169;

float RayleighPhase(float cosViewSunAngle)
{
	/*
	Rayleigh phase function.
			   3
	p(θ) =	________   [1 + cos(θ)^2]
			   16π
	*/

	return (3.0 / (16.0*pi)) * (1.0 + pow(max(cosViewSunAngle, 0.0), 2.0));
}

float hgPhase(float cosViewSunAngle, float g)
{

	/*
	Henyey-Greenstein phase function.
			   1		 		1 − g^2 
	p(θ) =	________   ____________________________
			   4π		[1 + g^2 − 2g cos(θ)]^(3/2)
	*/


	return (1.0 / (4.0 * pi)) * ((1.0 - pow(g, 2.0)) / pow(1.0 + pow(g, 2.0) - 2.0*g * cosViewSunAngle, 1.5));
}

vec3 totalMie(vec3 lambda, vec3 K, float T, float v)
{
	float c = (0.2 * T ) * 10E-18;
	return 0.434 * c * pi * pow((2.0 * pi) / lambda, vec3(v - 2.0)) * K;
}

vec3 totalRayleigh(vec3 lambda, float n, float N, float pn){
	return (24.0 * pow(pi, 3.0) * pow(pow(n, 2.0) - 1.0, 2.0) * (6.0 + 3.0 * pn))
	/ (N * pow(lambda, vec3(4.0)) * pow(pow(n, 2.0) + 2.0, 2.0) * (6.0 - 7.0 * pn));
}

float SunIntensity(float zenithAngleCos, float sunIntensity)
{
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;
	return sunIntensity * max(0.0, 1.0 - exp(-((cutoffAngle - acos(zenithAngleCos))/steepness)));
}


float calcSun(vec3 fragpos, vec3 sunVec){

	const float sunAngularDiameterCos = 0.99813194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float sundisk = pow(smoothstep(sunAngularDiameterCos,sunAngularDiameterCos+0.001,cosViewSunAngle),10.);

	return 1000.0 * sundisk * (1.0 - rainStrength*0.999999)*pow(clamp(dot(normalize(fragpos),upVec)+0.05,0.0,0.1)/0.1,20.);

}

float calcMoon(vec3 fragpos, vec3 moonVec){

	const float moonAngularDiameterCos = 0.99833194915;

	float cosViewSunAngle = dot(normalize(fragpos.rgb), moonVec);
	float moondisk = smoothstep(moonAngularDiameterCos,moonAngularDiameterCos+0.001,cosViewSunAngle);

	return clamp(4.0 * moondisk, 0.0, 15.0) * (1.0 - rainStrength);

}

vec3 getAtmosphericScattering(vec3 color, vec3 fragpos){

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	float turbidity = 6.;
	float rayleighCoefficient = 2.;

	// constants for mie scattering
	const float mieCoefficient = 0.008;
	const float mieDirectionalG = 0.76;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Cos Angles
	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float cosUpViewAngle = dot(upVec, normalize(fragpos.rgb));
	float sunAngle = max(0.0, cosSunUpAngle * 0.95 + 0.05);
	
	vec3 sunE = vec3(1.,0.899,0.828)*SunIntensity(cosSunUpAngle, sunIntensity);  // Get sun intensity based on how high in the sky it is
	
	vec3 totalRayleigh = totalRayleigh(primaryWavelengths, n, N, pn);

	vec3 rayleighAtX = totalRayleigh * rayleighCoefficient;

	vec3 mieAtX = totalMie(primaryWavelengths, K, turbidity, v) * mieCoefficient;

	float zenithAngle = max(0.0, cosUpViewAngle);

	float rayleighOpticalLength = rayleighZenithLength / zenithAngle;
	float mieOpticalLength = mieZenithLength / zenithAngle;
	
	float rayleighOpticalLengthSun = rayleighZenithLength / sunAngle;
	float mieOpticalLengthSun = mieZenithLength / sunAngle;
	
	vec3 Fex = exp(-(rayleighAtX * rayleighOpticalLength + mieAtX * mieOpticalLength));
	vec3 FexSun = exp(-(rayleighAtX * rayleighOpticalLengthSun + mieAtX * mieOpticalLengthSun));

	vec3 rayleighXtoEye = rayleighAtX * RayleighPhase(cosViewSunAngle)*exp(-(rayleighAtX * rayleighOpticalLengthSun*0.1));
	vec3 mieXtoEye = vec3(1.,0.899,0.828)*mieAtX *  hgPhase(cosViewSunAngle , mieDirectionalG)*exp(-(rayleighAtX * rayleighOpticalLengthSun + mieAtX * mieOpticalLengthSun));

	vec3 totalLightAtX = rayleighAtX + mieAtX;
	vec3 lightFromXtoEye = rayleighXtoEye + mieXtoEye;

	vec3 scattering = sunE * (lightFromXtoEye / totalLightAtX);
	float undergroundLighting = clamp((eyeBrightnessSmooth.y/255.-2/16.)*4.,0.0,1.0); //avoid light leaking udnerground
	vec3 sky = scattering *(1.0-Fex);
	//sky *= mix(vec3(1.0),pow(scattering * Fex,vec3(0.5)),clamp(pow(1.0-cosSunUpAngle,5.0),0.0,1.0));
	float SdotE = dot(sunVec,normalize(fragpos.xyz));
	float EdotU = clamp(1.0-dot(upVec,normalize(fragpos.xyz)),0.,1.25);
	vec3 rainSky = vec3(0.1,0.14,0.2)*trueSunlight*0.15*exp(SdotE*SdotE*SdotE*2. + EdotU*EdotU*EdotU) + vec3(0.1,0.12,0.15)*length(trueSunlight);
	return sky*vec3(1.2,1.3,1.5)*2.8*sunVisibility*(1.0-rainStrength)+rainSky*rainStrength/0.0075*0.5;
}

vec3 getAtmosphericScattering2(float dist,vec3 fragpos,vec3 color,float VL){
	float tr2 = clamp(abs(worldTime*1.-17975.0)-5275.,0.,200.)/200.;
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	float turbidity = 4.;
	float rayleighCoefficient = 2.0;

	// constants for mie scattering
	const float mieCoefficient = 0.024;
	const float mieDirectionalG = 0.76;
	const float v = 4.0;

	// Wavelength of the primary colors RGB in nanometers.
	const vec3 primaryWavelengths = vec3(680, 550, 450) * 1.0E-9;
	
	float n = 1.00029; // refractive index of air
	float N = 2.54743E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)
	float pn = 0.035;	// depolarization factor for standard air

	// optical length at zenith for molecules
	float rayleighZenithLength = 8.4E3 ;
	float mieZenithLength = 1.25E3;
	
	const vec3 K = vec3(0.686, 0.678, 0.666);

	float sunIntensity = 1000.0;

	// earth shadow hack
	float cutoffAngle = pi * 0.5128205128205128;
	float steepness = 1.5;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Cos Angles
	float cosViewSunAngle = dot(normalize(fragpos.rgb), sunVec);
	float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05; //Has a lower offset making it scatter when sun is below the horizon.
	float cosUpViewAngle = pow(abs(dot(upVec, normalize(fragpos.rgb))),1.6)*sign(dot(upVec, normalize(fragpos.rgb)));

	vec3 sunE = vec3(1.,0.899,0.828)*SunIntensity(cosSunUpAngle, sunIntensity);  // Get sun intensity based on how high in the sky it is
	
	vec3 totalRayleigh = totalRayleigh(primaryWavelengths, n, N, pn);

	vec3 rayleighAtX = totalRayleigh * rayleighCoefficient;

	vec3 mieAtX = totalMie(primaryWavelengths, K, turbidity, v) * mieCoefficient;

	float zenithAngle = max(0.0, cosUpViewAngle);

	float rayleighOpticalLength = rayleighZenithLength / zenithAngle;
	float mieOpticalLength = mieZenithLength / zenithAngle;

	vec3 wVec = normalize((gbufferModelViewInverse*vec4(normalize(fragpos),0.0)).xyz);
	
	
	vec3 Fex = exp(-(rayleighAtX  + mieAtX)*dist);
	vec3 Fexsun = vec3(exp(-(rayleighCoefficient * 0.00002853075 * rayleighOpticalLength + mieAtX * mieOpticalLength)));

	vec3 rayleighXtoEye = rayleighAtX * RayleighPhase(cosViewSunAngle);
	vec3 mieXtoEye = mieAtX *  hgPhase(cosViewSunAngle , mieDirectionalG);

	vec3 totalLightAtX = rayleighAtX + mieAtX;
	vec3 lightFromXtoEye = rayleighXtoEye*(0.5+VL*tr2*tr2) + mieXtoEye*VL*3.*sunlight*tr2*tr2;

	vec3 scattering = sunE * (lightFromXtoEye / totalLightAtX);

	vec3 sky = scattering * (1.0-Fex);
	float SdotE = dot(sunVec,normalize(fragpos.xyz));
	float EdotU = clamp(1.0-dot(upVec,normalize(fragpos.xyz)),0.,1.25);
	vec3 caveFog = (1.0-exp(-dist/512.))*vec3(0.001) * (1.0+VL*5.);
	float undergroundLighting = clamp((eyeBrightnessSmooth.y/255.-2/16.)*4.,0.0,1.0); //avoid light leaking udnerground
		vec3 rainSky =  vec3(0.1,0.14,0.2)*trueSunlight*0.01*exp(SdotE*SdotE*SdotE*4.)*(3.4+VL) + vec3(0.1,0.12,0.15)*length(trueSunlight)*(1.1+VL*0.33);
	return color * Fex * exp(-dist/22.*rainStrength*rainStrength*rainStrength) + mix(caveFog,sky*0.6*sunVisibility*(1.0-rainStrength)+rainSky*rainStrength*(1.0-exp(-dist/22.))*0.2,undergroundLighting);
}
 


 float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}


float TriangularInterleaved_gradientNoise(){
	vec2 coord = gl_FragCoord.xy;
	float nrnd0 = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	
	float orig = nrnd0*2.0-1.0;
    nrnd0 = orig*inversesqrt(abs(orig));
    nrnd0 = max(-1.0,nrnd0); 
    nrnd0 = nrnd0-sign(orig);
	return nrnd0;
}
float TriangularInterleaved_gradientNoise2(){
	vec2 coord = 2000.-gl_FragCoord.xy;
	float nrnd0 = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	
	float orig = nrnd0*2.0-1.0;
    nrnd0 = orig*inversesqrt(abs(orig));
    nrnd0 = max(-1.0,nrnd0); 
    nrnd0 = nrnd0-sign(orig);
	return nrnd0;
}
float TriangularInterleaved_gradientNoise3(){
	vec2 coord = 1000+gl_FragCoord.xy;
	float nrnd0 = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y)+tempSample);
	
	float orig = nrnd0*2.0-1.0;
    nrnd0 = orig*inversesqrt(abs(orig));
    nrnd0 = max(-1.0,nrnd0); 
    nrnd0 = nrnd0-sign(orig);
	return nrnd0;
}
float bayer2(vec2 a){
	
	//(a-0.5)*(a-0.5)*0.75 = 0.75*a^2 - a*0.75 + 0.25*0.75
	//(a.y*sqrt(0.75)-0.5sqrt(0.75))^2 = 0.75a^2 - 0.75*a + 0.25*0.75
	a = floor(a);
    a = vec2(a.x*0.5-0.25,(a.y*sqrt(0.75)-0.43301270189));
    return fract(dot(a,vec2(1.,a.y)));
}
#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) bayer64(.5*(a))*.25+bayer2(a)

float nrand( vec2 n )
{
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float triangWhiteNoise( vec2 n )
{
	//uses white noise for color dithering : gives a somewhat more "filmic" look when noise is visible
	float t = fract( frameTimeCounter );
	float rnd = nrand( n + 0.07*t );

    float center = rnd*2.0-1.0;
    rnd = center*inversesqrt(abs(center));
    rnd = max(-1.0,rnd); 
    return rnd-sign(center);
}

vec3 drawMoon(vec3 pos){

	vec3 npos = normalize(pos);
		float MdotE = dot(npos,-sunVec);
	vec2 moon2 = moonVec.xy/moonVec.z;
	vec2 pos2 = npos.xy/npos.z;
	vec2 dif = vec2(moon2.x-pos2.x,moon2.y-pos2.y)*npos.z*32.*0.65;
	vec2 coord = clamp(dif*0.5+0.5,0.,1.);
	coord.x = clamp(coord.x*2047.5/4944. + 2896.5/4944.0,0.5/4944.,1.0-0.5/4944.);

	

	
	return pow(texture2D(depthtex1,coord).xyz,vec3(2.2))*0.08*(sunPosition.z > 0.? 1.0 : 0.)*(1.0-rainStrength*0.999);
}

vec4 smoothfilter(in sampler2D tex, in vec2 uv)
{
	const float textureResolution = 128.;
	uv = uv*textureResolution + 0.5;
	vec2 iuv = floor( uv );
	vec2 fuv = fract( uv );
	uv = iuv + (fuv*fuv)*(3.0-2.0*fuv); 
	uv = uv/textureResolution - 0.5/textureResolution;
	return texture2D( tex, uv);
}

vec3 drawStars(vec3 pos){
	vec4 wpos = gbufferModelViewInverse*vec4(pos,0.);
	wpos.xyz = normalize(wpos.xyz);
	float elevation = clamp(dot(upVec,normalize(pos)),0.,1.);
	vec2 uv = wpos.xz/wpos.y*sqrt(elevation)*2.;
	float noise  = texture2D(noisetex, uv).x;
					noise += texture2D(noisetex, uv * 2.0).x / 2.0;
					noise += texture2D(noisetex, uv * 6.0).x / 6.0;
	
	return max(noise-1.41,0.)*vec3(1.)*elevation*(1.0 - rainStrength*0.999999);
}
vec3 fpDither(vec3 color,float dither){
	const vec3 mantissaBits = vec3(6.,6.,5.);
	vec3 exponent = floor(log2(color));
	return color + dither*exp2(-mantissaBits)*exp2(exponent);
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
void main() {
	vec4 rainVL = texture2D(gaux4,texcoord);
	float Depth2 = texture2D(depthtex0, texcoord).x;
	vec4 sPos = gbufferProjectionInverse * (vec4(texcoord-tempOffset/vec2(viewWidth,viewHeight),Depth2,1.0) * 2.0 - 1.0);
		sPos /= sPos.w;
	vec3 c = vec3(0.);

	


	
	vec4 trp = texture2D(gaux3,texcoord.xy);
	bool transparency = dot(trp.xyz,trp.xyz) > 0.000001;


	if (transparency) {
	#ifdef UNDERWATERFIX
	float mulfov = 1.0;
	if (isEyeInWater>0.1){
		float fov = atan(1./gbufferProjection[1][1]);
		float fovUnderWater = fov*0.85;
		mulfov = gbufferProjection[1][1]*tan(fovUnderWater); 
		sPos.xy *= mulfov;
	}
	#endif
	#ifndef UNDERWATERFIX
	const float mulfov = 1.0;
	#endif




	vec2 newtc = texcoord;
	bool reflective = false;
	vec3 normal = texture2D(gnormal,texcoord).xyz;
	float sky = normal.z;
	float sunVis = 1.0;

	bool iswater = sky < 0.2499;
	bool isice = sky > 0.2499 && sky < 0.4999;
	


	sky *= iswater? 4.0:1.0;
	sky = isice? (sky - 0.25)*4.0:sky;

	sky = (!iswater && !isice)? (sky - 0.5)*4.0 : sky;

	sky = clamp(sky*1.2-2./16.0*1.2,0.,1.0);
	sky *= sky;




		if (iswater || isice) {
			vec3 wpos = (gbufferModelViewInverse*sPos).rgb;

			vec3 posxz = wpos+cameraPosition;
			float ft = iswater? frameTimeCounter*4.0:0.0;

			posxz.x += sin(posxz.z+ft)*0.25;
			posxz.z += cos(posxz.x+ft*0.5)*0.25;

			const float deltaPos = 0.4;
			float h0 = waterH(posxz,ft);
			float h1 = waterH(posxz - vec3(deltaPos,0.0,0.0),ft);
			float h2 = waterH(posxz - vec3(0.0,0.0,deltaPos),ft);

			float dX = ((h0-h1))/deltaPos;
			float dY = ((h0-h2))/deltaPos;



			vec3 refract = normalize(vec3(dX,dY,1.0));
			float refMult = sqrt(1.0-dot(normal,normalize(sPos.xyz))*dot(normal,normalize(sPos.xyz)))*0.005;

			newtc = texcoord.xy + refract.xy*refMult;
			vec3 mask = texture2D(gnormal,newtc).xyz;
			bool watermask = mask.z > 0.0 && newtc.x < 1.0 && newtc.y < 1.0 &&newtc.x > 0.0 && newtc.y > 0.0;
			newtc = watermask? newtc : texcoord;
	

		}
		

		c = texture2D(composite,newtc).xyz/10.;
		

		
		float Depth = texture2D(depthtex2, newtc).x;
		vec4 fragpos = gbufferProjectionInverse * (vec4(newtc-tempOffset/vec2(viewWidth,viewHeight),Depth,1.0) * 2.0 - 1.0);
		fragpos /= fragpos.w;
		fragpos.xy *= mulfov;
		
		c += Depth < comp? vec3(0.0) : calcSun(fragpos.xyz,sunVec)*sunlight + moonlight*0.6*(exp(dot(moonVec,normalize(sPos.xyz))*1.))*(1.0-rainStrength*0.5);

		
		//don't blur if there won't be any clouds
		if (cameraPosition.y > 220 || dot(fragpos.xyz,upVec) > 0.0){
		float pw = 1.0/ viewWidth;
		float ph = 1.0/ viewHeight;
		float lDepth = ld(Depth);
		float count = 1.0;
		//bilateral blur
		vec4 blur = texture2D(gdepth,newtc);
		vec4 blur1 = texture2D(gdepth,newtc + vec2(-0.5*pw,1.5*ph));
		vec4 blur2 = texture2D(gdepth,newtc + vec2(1.5*pw,0.5*ph));
		vec4 blur3 = texture2D(gdepth,newtc + vec2(0.5*pw,-1.5*ph));
		vec4 blur4 = texture2D(gdepth,newtc + vec2(-1.5*pw,-0.5*ph));

		vec4 depth1 = ld4(textureGather(depthtex2,newtc + vec2(-0.5*pw,1.5*ph),0));
		blur = blur + step(dot(abs(depth1-lDepth),vec4(far)),10.)*blur1;
		count += step(dot(abs(depth1-lDepth),vec4(far)),10.);

		vec4 depth2 = ld4(textureGather(depthtex2,texcoord + vec2(1.5*pw,0.5*ph),0));
		blur = blur + step(dot(abs(depth2-lDepth),vec4(far)),10.)*blur2;
		count += step(dot(abs(depth2-lDepth),vec4(far)),10.);

		vec4 depth3 = ld4(textureGather(depthtex2,texcoord + vec2(0.5*pw,-1.5*ph),0));
		blur = blur + step(dot(abs(depth3-lDepth),vec4(far)),10.)*blur3;
		count += step(dot(abs(depth3-lDepth),vec4(far)),10.);

		vec4 depth4 = ld4(textureGather(depthtex2,texcoord + vec2(-1.5*pw,-0.5*ph),0));
		blur = blur + step(dot(abs(depth4-lDepth),vec4(far)),10.)*blur4;
		count += step(dot(abs(depth4-lDepth),vec4(far)),10.);

		blur /= count;
		
		//apply clouds (assuming transparencies are placed before clouds)
		c = c*(blur.a)+blur.rgb*0.75;
		}
		
		

		vec4 finalAc = texture2D(gaux2,texcoord);
		vec4 rawAlbedo = trp;
		float alphaT = clamp(length(rawAlbedo.rgb)*1.02,0.0,1.0);
		rawAlbedo = rawAlbedo;


		c = mix(c,c*(rawAlbedo.rgb*sqrt(3.0)+0.0001),alphaT)*(1.0-alphaT) + finalAc.rgb;
		
	
	
		reflective = dot(normal.xyz,normal.xyz) > 0.0;

		if (reflective) {
			
			
				float Depth = texture2D(depthtex0, texcoord).x;
				vec4 fragpos = gbufferProjectionInverse * (vec4(texcoord,Depth,1.0) * 2.0 - 1.0);
				fragpos /= fragpos.w;
				fragpos.xy *= mulfov;
				
				normal = decode(normal.xy);



				normal = normalize(normal);
				
				vec3 reflectedVector = reflect(normalize(fragpos.xyz), normal);
				vec3 hV= normalize(normalize(reflectedVector) + normalize(-fragpos.xyz));

				float normalDotEye = dot(hV, normalize(fragpos.xyz));

				float F0 = iswater? 0.02 : 0.04;
				F0 = isice? 0.017 : 0.04;



				float fresnel = pow(clamp(1.0 + normalDotEye,0.0,1.0), 5.0) ;
				fresnel = fresnel+F0*(1.0-fresnel);
		
				float a = 1.0;
				float b = dot(fragpos.xyz,normalize(reflectedVector)*2.);
				float C = dot(fragpos.xyz,fragpos.xyz) - far*far*12.;
				float delta = b*b - 4*a*C;
				float K = (-b + sqrt(delta)) / 2.;
				
				vec3 skyIntersection = fragpos.xyz + normalize(reflectedVector)*K;
				vec3 sky_c = getAtmosphericScattering(vec3(0.),normalize(skyIntersection))*0.0075+ moonlight*0.6*(exp(dot(moonVec,normalize(skyIntersection))*1.))*moonVisibility*(1.0-rainStrength*0.5) + drawMoon(normalize(skyIntersection));

				//vec4 reflection = raytrace(sPos.xyz, normal,sky_c,reflectedVector,mulfov,interleaved_gradientNoise());
				
				vec3 rtPos = rayTrace(reflectedVector,fragpos.xyz,bayer128(gl_FragCoord.xy));
				sky_c = (isEyeInWater == 0)? sky_c+calcSun(skyIntersection,sunVec)*sky*sunlight  + drawStars(sPos.xyz): vec3(0.012,0.025,0.03)*length(trueSunlight*sunVisibility+moonlight*moonVisibility);
				
				vec4 reflection = vec4(sky_c,0.);
				if (rtPos.z > 0.){
				vec4 fragpositionPrev = gbufferProjectionInverse * vec4(rtPos*2.-1.,1.);
				fragpositionPrev /= fragpositionPrev.w;
				
				vec3 sampleP = fragpositionPrev.xyz;
				fragpositionPrev = gbufferModelViewInverse * fragpositionPrev;


			
				vec4 previousPosition = fragpositionPrev + vec4(cameraPosition-previousCameraPosition,0.);
				previousPosition = gbufferPreviousModelView * previousPosition;
				previousPosition = gbufferPreviousProjection * previousPosition;
				previousPosition.xy = previousPosition.xy/previousPosition.w*0.5+0.5;
				reflection.a = clamp(1.0 - pow(cdist(previousPosition.st), 20.0), 0.0, 1.0);
				reflection.rgb = texture2DLod(colortex4,previousPosition.xy,1.).rgb/10.;
				}
				

				reflection.rgb = mix(sky_c, reflection.rgb, reflection.a);

				fresnel *= isice? 1. : 1.0;
				//fresnel*= !(iswater|| isice)? pow(max(1.0-alphaT,0.01),0.8) : 1.0;

				vec3 reflC = vec3(1.0);
				//reflC = (isice)? mix(normalize(rawAlbedo.xyz)*sqrt(3.0),reflC,0.7) : (!(iswater|| isice)? mix(normalize(rawAlbedo.xyz)*sqrt(3.0),reflC,0.75):reflC);

				c = mix(c,reflection.rgb,fresnel);

			}	
if (isEyeInWater == 0)
{			
			c = getAtmosphericScattering2(length(sPos.xyz)*0.4,sPos.xyz,c,rainVL.b);
			c += moonlight*(0.1+rainVL.b*4.)*(length(sPos.xyz)/2048.)*(exp(dot(moonVec,normalize(sPos.xyz))))*moonVisibility;
}			


	}
if (isEyeInWater == 1)	 c = mix(c,vec3(0.012,0.025,0.03)*length(trueSunlight*sunVisibility+moonlight*moonVisibility),1.0-exp(-length(sPos.xyz)*vec3(0.2,0.25,0.3)/6.));

	if (!transparency) {
		c = texture2D(composite,texcoord).rgb/10.;
		if (isEyeInWater == 1)	 c = mix(c,vec3(0.012,0.025,0.03)*length(trueSunlight*sunVisibility+moonlight*moonVisibility),1.0-exp(-length(sPos.xyz)*vec3(0.2,0.25,0.3)/6.));
		float Depth = texture2D(depthtex2, texcoord).x;
		
		if (cameraPosition.y > 220 || dot(sPos.xyz,upVec) > 0.0){
		float pw = 1.0/ viewWidth;
		float ph = 1.0/ viewHeight;
		float lDepth = ld(Depth);
		float count = 1.0;
		//bilateral blur
		vec4 blur = texture2D(gdepth,texcoord);
		vec4 blur1 = texture2D(gdepth,texcoord + vec2(-0.5*pw,1.5*ph));
		vec4 blur2 = texture2D(gdepth,texcoord + vec2(1.5*pw,0.5*ph));
		vec4 blur3 = texture2D(gdepth,texcoord + vec2(0.5*pw,-1.5*ph));
		vec4 blur4 = texture2D(gdepth,texcoord + vec2(-1.5*pw,-0.5*ph));

		vec4 depth1 = ld4(textureGather(depthtex2,texcoord + vec2(-0.5*pw,1.5*ph),0));
		blur = blur + step(dot(abs(depth1-lDepth),vec4(far)),10.)*blur1;
		count += step(dot(abs(depth1-lDepth),vec4(far)),10.);

		vec4 depth2 = ld4(textureGather(depthtex2,texcoord + vec2(1.5*pw,0.5*ph),0));
		blur = blur + step(dot(abs(depth2-lDepth),vec4(far)),10.)*blur2;
		count += step(dot(abs(depth2-lDepth),vec4(far)),10.);

		vec4 depth3 = ld4(textureGather(depthtex2,texcoord + vec2(0.5*pw,-1.5*ph),0));
		blur = blur + step(dot(abs(depth3-lDepth),vec4(far)),10.)*blur3;
		count += step(dot(abs(depth3-lDepth),vec4(far)),10.);

		vec4 depth4 = ld4(textureGather(depthtex2,texcoord + vec2(-1.5*pw,-0.5*ph),0));
		blur = blur + step(dot(abs(depth4-lDepth),vec4(far)),10.)*blur4;
		count += step(dot(abs(depth4-lDepth),vec4(far)),10.);

		blur /= count;
		
		//apply clouds (assuming transparencies are placed before clouds)
		c = c*(blur.a)+blur.rgb*0.75 + c*abs(cameraPosition.y-260.)/768.*(1.0-blur.a);
		c += Depth < comp? vec3(0.0) : (calcSun(sPos.xyz,sunVec)*sunlight+ moonlight*0.6*(exp(dot(moonVec,normalize(sPos.xyz))*1.))*moonVisibility*(1.0-rainStrength*0.5) + drawMoon(sPos.xyz) + drawStars(sPos.xyz))*blur.a;
		}
		else c += Depth < comp? vec3(0.0) : (calcSun(sPos.xyz,sunVec)*sunlight+ moonlight*0.6*(exp(dot(moonVec,normalize(sPos.xyz))*1.))*moonVisibility*(1.0-rainStrength*0.5) + drawMoon(sPos.xyz) + drawStars(sPos.xyz));
	}




	if (rainStrength > 0.01){
	vec4 rain = texture2D(gaux4,texcoord);
		if (rain.r > 0.0001) {
			float rainRGB = 0.25;
			float rainA = rain.r;

			float torch_lightmap 		= 6.4 - min(rain.g/rain.r * 6.16,5.6);
			torch_lightmap 		= 0.1 / torch_lightmap / torch_lightmap - 0.002595;

			vec3 rainC = vec3(rainRGB);
			rainC += torch_lightmap*vec3(1.0,0.4,0.04)*2.05/2.4;
			float cosSunUpAngle = dot(sunVec, upVec) * 0.95 + 0.05;
			vec3 sunColor = normalize(pow(sunlight,vec3(0.33)))*SunIntensity(cosSunUpAngle, 1000.);
			float SdotE = dot(sunVec,normalize(sPos.xyz));
			rainC *= sunColor*exp(SdotE*SdotE*SdotE*1.7)*0.00002+length(sunlight)*vec3(0.1,0.14,0.2)*0.6*sunVisibility+moonlight*2.*moonVisibility;
			c = c*(1.0-rainA*0.2)+rainC*rainA;
	}
	}

/* DRAWBUFFERS:3 */


//	if (c.x > 1. || c.y > 1. || c.z > 1.) c.xyz =vec3(1.,0.,0.);

	 gl_FragData[0] = clamp(vec4(fpDither(c*10.,triangWhiteNoise(texcoord)),1.0),0.,65000.);

}
