#version 120

//go to line 96 for changing sunlight/ambient color balance

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;


	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	const ivec4 ToD[25] = ivec4[25](ivec4(0,0,6.25,16.25), //hour,r,g,b
							ivec4(1,0,6.25,16.25),
							ivec4(2,0,6.25,16.25),
							ivec4(3,0,6.25,16.25),
							ivec4(4,0,6.25,16.25),
							ivec4(5,0,6.25,16.25),
							ivec4(6,200,100,30),
							ivec4(7,200,100,30),
							ivec4(8,200,100,60),
							ivec4(9,210,115,60),
							ivec4(10,220,120,70),
							ivec4(11,230,125,70),
							ivec4(12,250,130,80),
							ivec4(13,230,125,70),
							ivec4(14,220,120,70),
							ivec4(15,210,115,60),
							ivec4(16,200,100,60),
							ivec4(17,200,100,30),
							ivec4(18,200,100,30),
							ivec4(19,0,6.25,16.25),
							ivec4(20,0,6.25,16.25),
							ivec4(21,0,6.25,16.25),
							ivec4(22,0,6.25,16.25),
							ivec4(23,0,6.25,16.25),
							ivec4(24,0,6.25,16.25)); 

	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,12.25,32.125,60), //hour,r,g,b
							ivec4(1,12.25,32.125,60),
							ivec4(2,12.25,32.125,60),
							ivec4(3,12.25,32.125,60),
							ivec4(4,12.25,32.125,60),
							ivec4(5,12.25,32.125,60),
							ivec4(6,21.20,41.25,101.25),
							ivec4(7,25.20,41.25,101.25),
							ivec4(8,25.20,41.25,101.25),
							ivec4(9,31.20,41.25,101.25),
							ivec4(10,31.20,41.25,101.25),
							ivec4(11,31.20,41.25,101.25),
							ivec4(12,31.20,41.25,101.25),
							ivec4(13,31.20,41.25,101.25),
							ivec4(14,31.20,41.25,101.25),
							ivec4(15,31.20,41.25,101.25),
							ivec4(16,25.20,41.25,101.25),
							ivec4(17,25.20,41.25,101.25),
							ivec4(18,21.20,41.25,101.25),
							ivec4(19,12.25,32.125,60),
							ivec4(20,12.25,32.125,60),
							ivec4(21,12.25,32.125,60),
							ivec4(22,12.25,32.125,60),
							ivec4(23,12.25,32.125,60),
							ivec4(24,12.25,32.125,60));

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
void main() {
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}

	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}
	
	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 1.0;
	}
	
	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.7;
	}
	
	
	else if (heldItemId == 327) {
		//lave bucket
		handItemLight = 0.4;
	}
	
		else if (heldItemId == 385) {
		//fire charger
		handItemLight = 0.2;
	}
	
		else if (heldItemId == 138) {
		//Beacon
		handItemLight = 1.0;
	}
	
		else if (heldItemId == 169) {
		//Sea lantern
		handItemLight = 1.0;
	}
	
	

	

	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight_color = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	

							
	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;
	
	vec3 ambient_color_rain = vec3(0.4, 0.4, 0.2); //rain

	ambient_color = sqrt(pow(mix(ambient_color, ambient_color_rain, rainStrength*0.75),vec3(2.0))*2.0*ambient_color); //rain
	
}

