#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

	const ivec4 ToD[25] = ivec4[25](ivec4(0,1.5,7.5,17), //hour,r,g,b
							ivec4(1,1.5,7.5,17),
							ivec4(2,1.5,7.5,17),
							ivec4(3,1.5,7.5,17),
							ivec4(4,1.5,7.5,17),
							ivec4(5,1.5,7.5,17),
							ivec4(6,200,45,10),
							ivec4(7,200,45,20),
							ivec4(8,200,65,30),
							ivec4(9,170,75,40),
							ivec4(10,170,75,50),
							ivec4(11,180,80,50),
							ivec4(12,190,80,50),
							ivec4(13,180,80,50),
							ivec4(14,170,75,50),
							ivec4(15,170,75,40),
							ivec4(16,200,65,30),
							ivec4(17,200,45,20),
							ivec4(18,200,45,10),
							ivec4(19,1.5,7.5,17),
							ivec4(20,1.5,7.5,17),
							ivec4(21,1.5,7.5,17),
							ivec4(22,1.5,7.5,17),
							ivec4(23,1.5,7.5,17),
							ivec4(24,1.5,7.5,17));

							
							
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,45,60,90), //hour,r,g,b
							ivec4(1,45,60,90),
							ivec4(2,45,60,90),
							ivec4(3,45,60,90),
							ivec4(4,45,60,90),
							ivec4(5,45,60,90),
							ivec4(6,90,120,230),
							ivec4(7,150,200,250),
							ivec4(8,195,210,250),
							ivec4(9,195,220,270),
							ivec4(10,200,235,290),
							ivec4(11,205,250,310),
							ivec4(12,205,250,320),
							ivec4(13,205,250,310),
							ivec4(14,200,235,290),
							ivec4(15,195,220,270),
							ivec4(16,195,210,250),
							ivec4(17,150,200,250),
							ivec4(18,90,120,230),
							ivec4(19,45,60,90),
							ivec4(20,45,60,90),
							ivec4(21,45,60,90),
							ivec4(22,45,60,90),
							ivec4(23,45,60,90),
							ivec4(24,45,60,90));
							
							
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	
		if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;
	
	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	
	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

	
}
