#version 120
#extension GL_EXT_gpu_shader4 : enable


varying vec4 lmtexcoord;
varying vec4 color;
 varying vec4 normalMat;
#ifdef MC_NORMAL_MAP
varying vec4 tangent;
uniform float wetness;
#endif
uniform sampler2D normals;
uniform sampler2D specular;

uniform sampler2D texture;
uniform float frameTimeCounter;

float interleaved_gradientNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y)+frameTimeCounter);
}

//encode normal in two channels (xy),torch(z) and sky lightmap (w)
vec4 encode (vec3 n)
{
	
    return vec4(n.xy*inversesqrt(n.z*8.0+8.0) + 0.5,lmtexcoord.z,lmtexcoord.w);
}

#ifdef MC_NORMAL_MAP
vec3 applyBump(vec3 normal, vec3 bump)
{
		vec3 tangent2 = normalize(cross(tangent.rgb,normal)*tangent.w);
		mat3 tbnMatrix = mat3(tangent.x, tangent2.x, normal.x,
								  tangent.y, tangent2.y, normal.y,
						     	  tangent.z, tangent2.z, normal.z);
								  
		float bumpmult = 1.0-wetness*0.95;
	
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);

		return normalize(bump*tbnMatrix);
}
#endif
float encodeVec2(vec2 a){
    const vec2 constant1 = vec2( 1., 256.) / 65535.;
    return dot( floor( a * 255. ), constant1 );
}

float encodeVec2(float x,float y){
    return encodeVec2(vec2(x,y));
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
/* DRAWBUFFERS:2 */
void main() {
	vec4 data0 = texture2D(texture, lmtexcoord.xy)*color;

	
	vec3 normal = normalMat.xyz;
	#ifdef MC_NORMAL_MAP
	normal = applyBump(normal,texture2D(normals,lmtexcoord.xy).xyz*2.-1.);
	#endif
	vec4 data1 = clamp(interleaved_gradientNoise()*exp2(-8.)+encode(normal),0.,1.0);
	
	gl_FragData[0] = vec4(encodeVec2(data0.x,data1.x),encodeVec2(data0.y,data1.y),encodeVec2(data0.z,data1.z),encodeVec2(data1.w,data0.w));

}