#version 120
#extension GL_EXT_gpu_shader4 : enable
const int shadowMapResolution = 2048; //[512 768 1024 1536 2048 3172 4096 8192]
varying vec4 lmtexcoord;
varying vec4 color;
 varying vec4 normalMat;
varying vec3 binormal;
varying vec3 tangent;
varying vec3 viewVector;


#define SHADOW_MAP_BIAS 0.8

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform sampler2DShadow shadow;


uniform vec3 sunPosition;
uniform float frameTimeCounter;
uniform float lightPosSign;

uniform float moonIntensity;
uniform float sunIntensity;
uniform vec3 sunColor;
uniform vec3 nsunColor;
uniform int framemod16;

uniform vec2 texelSize;
uniform float rainStrength;
uniform float skyIntensityNight;
uniform float skyIntensity;

#include "lib/color_dither.glsl"
#include "lib/color_transforms.glsl"
#include "lib/texFiltering.glsl"
#include "lib/projections.glsl"
vec3 sunVec = normalize(mat3(gbufferModelViewInverse) *sunPosition);
#include "lib/sky_gradient.glsl"
#include "lib/waterBump.glsl"
#include "lib/clouds.glsl"
#include "lib/stars.glsl"

float interleaved_gradientNoise(){
	vec2 coord = gl_FragCoord.xy;
	float noise = fract(52.9829189*fract(0.06711056*coord.x + 0.00583715*coord.y));
	return noise;
}
//area light approximation (from horizon zero dawn siggraph presentation)
float GetNoHSquared(float radiusTan, float NoL, float NoV, float VoL)
{
    // radiusCos can be precalculated if radiusTan is a directional light
    float radiusCos = inversesqrt(1.0 + radiusTan * radiusTan);
    
    // Early out if R falls within the disc
    float RoL = 2.0 * NoL * NoV - VoL;
    if (RoL >= radiusCos)
        return 1.0;

    float rOverLengthT = radiusCos * radiusTan * inversesqrt(1.0 - RoL * RoL);
    float NoTr = rOverLengthT * (NoV - RoL * NoL);
    float VoTr = rOverLengthT * (2.0 * NoV * NoV - 1.0 - RoL * VoL);

    // Calculate dot(cross(N, L), V). This could already be calculated and available.
    float triple = sqrt(clamp(1.0 - NoL * NoL - NoV * NoV - VoL * VoL + 2.0 * NoL * NoV * VoL,0.,1.));
    
    // Do one Newton iteration to improve the bent light vector
    float NoBr = rOverLengthT * triple, VoBr = rOverLengthT * (2.0 * triple * NoV);
    float NoLVTr = NoL * radiusCos + NoV + NoTr, VoLVTr = VoL * radiusCos + 1.0 + VoTr;
    float p = NoBr * VoLVTr, q = NoLVTr * VoLVTr, s = VoBr * NoLVTr;    
    float xNum = q * (-0.5 * p + 0.25 * VoBr * NoLVTr);
    float xDenom = p * p + s * ((s - 2.0 * p)) + NoLVTr * ((NoL * radiusCos + NoV) * VoLVTr * VoLVTr + 
                   q * (-0.5 * (VoLVTr + VoL * radiusCos) - 0.5));
    float twoX1 = 2.0 * xNum / (xDenom * xDenom + xNum * xNum);
    float sinTheta = twoX1 * xDenom;
    float cosTheta = 1.0 - twoX1 * xNum;
    NoTr = cosTheta * NoTr + sinTheta * NoBr; // use new T to update NoTr
    VoTr = cosTheta * VoTr + sinTheta * VoBr; // use new T to update VoTr
    
    // Calculate (N.H)^2 based on the bent light vector
    float newNoL = NoL * radiusCos + NoTr;
    float newVoL = VoL * radiusCos + VoTr;
    float NoH = NoV + newNoL;
    float HoH = 2.0 * newVoL + 2.0;
    return max(0.0, NoH * NoH / HoH);
}
//optimized ggx from jodie with area light approximation
float GGX (vec3 n, vec3 v, vec3 l, float r, float F0,float lightSize) {
  r*=r;r*=r;
  
  vec3 h = l + v;
  float hn = inversesqrt(dot(h, h));

  float dotLH = clamp(dot(h,l)*hn,0.,1.);
  float dotNH = clamp(dot(h,n)*hn,0.,1.);
  float dotNL = clamp(dot(n,l),0.,1.);
  float dotNHsq = GetNoHSquared(lightSize,dotNL,dot(n,v),dot(v,l));
  
  float denom = dotNHsq * r - dotNHsq + 1.;
  float D = r / (3.141592653589793 * denom * denom);
  float F = F0 + (1. - F0) * exp2((-5.55473*dotLH-6.98316)*dotLH);
  float k2 = .25 * r;

  return dotNL * D * F / (dotLH*dotLH*(1.0-k2)+k2);
}
const vec2 shadowOffsets[8] = vec2[8](vec2( -0.7071,  0.7071 ),
vec2( -0.0000, -0.8750 ),
vec2(  0.5303,  0.5303 ),
vec2( -0.6250, -0.0000 ),
vec2(  0.3536, -0.3536 ),
vec2( -0.0000,  0.3750 ),
vec2( -0.1768, -0.1768 ),
vec2( 0.1250,  0.0000 ));
float facos(float sx){
    float x = clamp(abs( sx ),0.,1.);
    float a = sqrt( 1. - x ) * ( -0.16882 * x + 1.56734 );
    return sx > 0. ? a : pi - a;
}	

#define SHADOW_MAP_BIAS 0.8
float calcDistort(vec2 worlpos){
	
	vec2 pos = abs(worlpos * 1.165);
	vec2 posSQ = pos*pos;
	
	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	return 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
}	
			
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
/* DRAWBUFFERS:1 */
void main() {
	float iswater = normalMat.w;
	gl_FragData[0] = texture2D(texture, lmtexcoord.xy)*color;
	if (iswater > 0.4) gl_FragData[0] = vec4(0.42,0.6,0.7,0.6);
	if (iswater > 0.9) gl_FragData[0] = vec4(0.16,0.42,0.5,0.3);

		vec3 albedo = toLinear(gl_FragData[0].rgb);
		
		vec3 normal = normalMat.xyz;
		vec3 fragpos = toScreenSpace(gl_FragCoord.xyz*vec3(texelSize,1.0));
		vec3 p3 = mat3(gbufferModelViewInverse) * fragpos + gbufferModelViewInverse[3].xyz;

		if (iswater > 0.4){
		float bumpmult = 0.5;
		if (iswater > 0.9) bumpmult = 0.12;
		float parallaxMult = bumpmult;
		vec3 posxz = p3+cameraPosition;
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
				
		vec3 viewVectorz = normalize(tbnMatrix*normalize(fragpos));
		vec3 bump;
		bump = getWaveHeight(posxz.xz - posxz.y,iswater);

		

		
		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
							  
		normal = normalize(bump * tbnMatrix);
		}
		
		float diffuseSun = clamp(dot(normal.xyz,normalize(mat3(gbufferModelViewInverse)*sunPosition)),0.0,1.);
		float shading = 1.0;



		//compute shadows only if not backface
		if (diffuseSun > 0.001) {
			
			vec3 projectedShadowPosition = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
			projectedShadowPosition = diagonal3(shadowProjection) * projectedShadowPosition + shadowProjection[3].xyz;
			
			//apply distortion
			float distortFactor = calcDistort(projectedShadowPosition.xy);
			projectedShadowPosition.xy *= distortFactor/0.92;
			//do shadows only if on shadow map
			if (abs(projectedShadowPosition.x) < 1.0-1.5/shadowMapResolution && abs(projectedShadowPosition.y) < 1.0-1.5/shadowMapResolution){
				float diffthresh = (facos(diffuseSun)*2.0+0.05)*0.014*0.06/distortFactor/distortFactor;	

				projectedShadowPosition = projectedShadowPosition * vec3(0.5,0.5,0.5/3.0) + vec3(0.5,0.5,0.5);
				shading = 0.0;	
				#ifdef PCF
				mat2 noiseM = mat2( cos( noise*3.14159265359*2.0 ), -sin( noise*3.14159265359*2.0 ),
								   sin( noise*3.14159265359*2.0 ), cos( noise*3.14159265359*2.0 )
									);

				
				for(int i = 0; i < 8; i++){
					vec2 offsetS = shadowOffsets[i];
							
					float weight = 1.0+length(offsetS)*1.412;
					shading += shadow2D(shadow,vec3(projectedShadowPosition + vec3((noiseM*offsetS)*(distortFactor*0.2*1.412/shadowMapResolution),-diffthresh*weight))).x/8.0;
					}
				#endif
				
				#ifndef PCF
				projectedShadowPosition.z -= diffthresh*2.;
				shading = shadow2D(shadow,vec3(projectedShadowPosition)).x;
				#endif
			}
		}
		
		vec3 ambientCoefs = normal.xyz/dot(abs(normal.xyz),vec3(1.));
		float direct =diffuseSun;
	
		

		float torch_lightmap = 16.0-min(15.,( lmtexcoord.z-0.5/16.)*16.*16./15);
		float fallof1 = clamp(1.0 - pow(torch_lightmap/16.0,4.0),0.0,1.0);
		torch_lightmap = fallof1*fallof1/(torch_lightmap*torch_lightmap+1.0);
	
	
		vec3 diffuseLight = shading*direct*(sunColor*sunIntensity+vec3(0.9,1.0,1.5)*moonIntensity*0.1) + skyIntensity*5.*(lmtexcoord.w*lmtexcoord.w)*vec3(0.8,0.9,1.) + 9.0*vec3(1.,0.45,0.12)*torch_lightmap + 0.001;

		vec3 color = diffuseLight*albedo;
		
		
		float f0 = 0.08;

		float roughness = 0.05;
		if (iswater > 0.4) roughness=0.04;
		if (iswater > 0.9) roughness=0.05;
		
		float emissive = 0.0;
		float F0 = f0;
normal = normalize(vec3(gbufferModelView*vec4(normal.xyz,0.0)));
				vec3 reflectedVector = reflect(normalize(fragpos), normal);	
				float normalDotEye = dot(normal, normalize(fragpos));
				float fresnel = pow(clamp(1.0 + normalDotEye,0.0,1.0), 5.0) ;
				fresnel = fresnel+F0*(1.0-fresnel);
				
				vec4 finalRefl = vec4(0.);
				
				float sunSpec = GGX(normal,-normalize(fragpos),  normalize(sunPosition), roughness, f0,0.035);
				float moonSpec = GGX(normal,-normalize(fragpos),  -normalize(sunPosition), roughness, f0,0.065);
				
				vec3 dir = reflect(normalize(fragpos), normal.xyz);
				
				//if the reflected ray goes under the surface, invert ray direction
				if (dot(dir,normal)<0.) {
				dir = reflect(normalize(fragpos), -normal.xyz);	

				}
				reflectedVector = normalize(dir);

				vec3 wrefl = mat3(gbufferModelViewInverse)*reflectedVector;
				vec3 sky_c = cloud2D(wrefl,getSkyColor(wrefl,1.,1.,wrefl.y))*lmtexcoord.w*lmtexcoord.w ;
				sky_c += stars(wrefl);
				




				//vec4 reflection = raytrace(sPos.xyz, normal,sky_c,reflectedVector,mulfov,interleaved_gradientNoise());

				
				vec4 reflection = vec4(sky_c,0.);

				

				reflection.rgb = mix(sky_c, reflection.rgb, reflection.a);
				finalRefl += vec4(reflection.rgba);

				vec3 reflected= finalRefl.rgb*fresnel+shading*sunSpec*sunIntensity* sunColor*0.01+shading*moonSpec*moonIntensity*vec3(0.09,0.1,0.15)*0.00025;

				float alpha0 = gl_FragData[0].a;
				vec3 specColor = mix(normalize(albedo)*0.25,vec3(1.0/sqrt(3.)),1.0-alpha0*alpha0*alpha0*alpha0);
		//correct alpha channel with fresnel
		gl_FragData[0].a = -gl_FragData[0].a*fresnel+gl_FragData[0].a+fresnel;				
		gl_FragData[0].rgb = color*10./gl_FragData[0].a*alpha0*(1.0-fresnel)+reflected*10./gl_FragData[0].a*specColor;



}