#version 120

/*
Modified Chocapic13 Shader Lite By Airloocke42
*/

#define LENS_EFFECTS

#define DOF
	#define DOF_INTENSITY 1.0

#define BLOOM
	const float b_intensity = 12.0;

#define VIGNETTE
	#define VIGNETTE_STRENGTH 8.25
	#define VIGNETTE_START 0.25
	#define VIGNETTE_EXP 1.5   

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 ambient_color;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D gcolor;

uniform sampler2D composite;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform ivec2 eyeBrightness;

uniform int isEyeInWater;
uniform int worldTime;

uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

vec3 sunPos = sunPosition;

uniform int fogMode;

float timefract = worldTime;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;

float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

vec3 fogclr = pow(mix(vec3(0.5,0.5,1.0),vec3(0.3,0.3,0.3),rainStrength)*ambient_color,vec3(2.2));

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

float matflag = texture2D(gaux1,texcoord.xy).g;

float ld(float depth) { return (2.0 * near) / (far + near - depth * (far - near)); }

float A = 0.15, B = 0.25, C = 0.10, D = 0.20, E = 0.02, F = 0.30, W = 16.0;

vec3 Uncharted2Tonemap(vec3 x) { return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F; }

float getnoise(vec2 pos) { return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)); }

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,3.0);
}

vec3 genlens(vec3 lenscolor, float dist, float size, vec4 tpos, float sun) {

	vec2 lightPos = tpos.xy/tpos.z*dist; lightPos = (lightPos + 1.0f)/2.0f;	

    float lensFlare = max(pow(max(1 - pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio),size)/size,10.0)/1,0.1),5.0)-0.1,0);

    return clamp(lensFlare, 0.0, 1.0) * lenscolor * 0.5 * sun * (1.0-rainStrength);	
}

void main() {

	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int land = int(matflag > 0.04);
	int hand  = int(matflag > 0.75 && matflag < 0.85);

	vec2 fake_refract = vec2(sin(worldTime/15.0 + texcoord.x*100.0 + texcoord.y*50.0),cos(worldTime/15.0 + texcoord.y*100.0 + texcoord.x*50.0)) * isEyeInWater;

	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.005).rgb*16.0;

	float fog = 0.0; 
	fog = 1.0-clamp(exp(-pow(ld(texture2D(depthtex0, texcoord.st).r),3.0)),0.0,1.0);
	
	#ifdef DOF
	vec4 bcolor = vec4(0.0);

	float blur = min(abs(texture2D(depthtex0, texcoord.st).x - texture2D(depthtex0, vec2(0.5)).x) * 0.1, 0.1);		
	int k = 0;

	if (hand < 0.9) {
	for ( int i = -3; i < 3; i++) {
		for ( int j = -3; j < 3; j++) {

   	vec2 depth = (vec2(j,i)/3.0) * blur * vec2(1.0,aspectRatio);
	     depth *= DOF_INTENSITY;

    	bcolor += texture2D(gaux2, texcoord.xy + depth)*16.0;
		k++;
		}
	}
   	color.rgb = bcolor.rgb/k;
	}
	#endif

	#ifdef BLOOM
	color *= 0.8;

	float rad = 0.001, sc = 20.0, blm_amount = 0.02*b_intensity;
	int i = 0, samples = 1; vec4 clr = vec4(0.0);
	
	for (i = -8; i < 8; i++) {
	vec2 d = vec2(-i, i), e = vec2(0, i), f = texcoord.st;
	clr += texture2D(gaux2, f+(d.yy)*rad)*sc;
	clr += texture2D(gaux2, f+(d.yx)*rad)*sc;
	clr += texture2D(gaux2, f+(d.xy)*rad)*sc;
	clr += texture2D(gaux2, f+(d.xx)*rad)*sc;

	clr += texture2D(gaux2, f+(e.xy)*rad)*sc;
	clr += texture2D(gaux2, f+(-e.yx)*rad)*sc;
	clr += texture2D(gaux2, f+(-e.xy)*rad)*sc;
	clr += texture2D(gaux2, f+(e.yx)*rad)*sc;

	++samples;
	sc = sc - 1.0;
	}
	clr = (clr/8.0)/samples; color += clr.rgb*blm_amount;
	#endif

	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

	fogclr = mix(color.rgb,ambient_color*0.5,0.2);

	color.rgb += texture2D(gaux4,texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z, lightPos = pos1*0.5+0.5;
			
	vec3 lightVector;
	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	} else {
		lightVector = normalize(moonPosition);
	}

	float xdist = abs(lightPos.x-texcoord.x);
	float ydist = abs(lightPos.y-texcoord.y);

	float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);
	float fade = clamp(1.0-step(distof,0.08),0.0,1.0);

	float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;

	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);

	#ifdef LENS_EFFECTS
	if (sunvisibility > 0.05) {

	float anamorphic_lens = exp(-ydist*ydist/0.005)*exp(-xdist*xdist/0.1)*sunvisibility*(1-TimeMidnight*0.9) * (1.0-rainStrength);

	color.rgb += (vec3(0.25,0.45,1.0)*anamorphic_lens);
	}

	vec3 light_color = mix(vec3(1.0),sunlight,sunvisibility);

	float sun = sunvisibility;
	float h = TimeMidnight, r = rainStrength;

	if (sun*fade > 0.05) {

	vec3 c2 = vec3(0.1,0.6,.8) * (1-h), c1 = vec3(0.8,0.6,.1) * (1-h);
	vec3 c0 = vec3(0.1,1.0,.3) * (1-h), c3 = vec3(1.0,0.3,.1) * (1-h);

	color += genlens(c3, -0.05, 0.05, tpos, sun * (1-r));
	color += genlens(c1, -0.25, 0.07, tpos, sun * (1-r));
	color += genlens(c2, -0.45, 0.09, tpos, sun * (1-r));
	color += genlens(c0, -0.65, 0.13, tpos, sun * (1-r));

	}

	#endif

	#ifdef VIGNETTE

	float dv = pow(clamp(distance(texcoord.st, vec2(0.5, 0.5))/sqrt(2.0)-VIGNETTE_START,0.0,1.0),VIGNETTE_EXP);

	dv *= VIGNETTE_STRENGTH;
	dv = clamp(1.0 - dv,0.0,1.0);

	color *= dv;
	#endif

	float avglight = texture2D(gaux2,vec2(1.0)).a;
	float exposure = -log(clamp(avglight*48.0,0.01,0.5));
	exposure = 1.0;

	vec3 curr = Uncharted2Tonemap(color);

	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(W));
	color = curr*whiteScale;

	float saturation = 1.05, avg = (color.r + color.g + color.b);

        color = (((color - avg )*saturation)+avg) ;
	color /= saturation;	
	color = clamp(pow(color,vec3(1.1/2.2)),0.0,1.0);

	gl_FragColor = vec4(color,1.0);
	
}