#version 120

varying vec2 texcoord;
varying vec2 lightPos;
varying float avgLuma;
varying vec3 lightColor;
varying float sunVisibility;
varying float Vis;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex4;

uniform float viewHeight;
uniform float viewWidth;
uniform float frameTimeCounter;
uniform float rainStrength;
uniform float aspectRatio;
uniform mat4 gbufferProjection;
uniform vec3 sunPosition;
uniform float nightVision;
uniform float frameTime; 
float pw = 1.0/viewWidth;
float ph = 1.0/viewHeight;
float nrand( vec2 n )
{
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float triangWhiteNoise( vec2 n )
{
	//uses white noise for color dithering : gives a somewhat more "filmic" look when noise is visible
	float t = fract( frameTimeCounter );
	float rnd = nrand( n + 0.07*t );

    float center = rnd*2.0-1.0;
    rnd = center*inversesqrt(abs(center));
    rnd = max(-1.0,rnd); 
    return rnd-sign(center);
}
#include "lensflareslul.glsl"
void main() {
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;

#define GODRAYS_FILTER_SAMPLES  5 //[3 5 7 10 12 20]
	vec2 deltatexcoord = vec2(lightPos - texcoord)/GODRAYS_FILTER_SAMPLES*vec2(pw,ph)*250.;


		vec2 noisetc = texcoord - 0.5 * deltatexcoord*GODRAYS_FILTER_SAMPLES;
		
		vec3 gr = vec3(0.);
	for (int i = 0; i < GODRAYS_FILTER_SAMPLES; i++){
		vec3 Samplee = texture2D(colortex1, noisetc).rgb;
		gr += Samplee;
		noisetc += deltatexcoord;
	}



/* DRAWBUFFERS:014 */
gl_FragData[0] = vec4(texture2D(colortex0,texcoord).rgb + gr/GODRAYS_FILTER_SAMPLES,1.0);
gl_FragData[1] = vec4(0.);
gl_FragData[2] = texture2D(colortex4,texcoord);


	
	vec2 ntc2 = texcoord*2.0-1.0;
	if (ntc2.x < 1.0 && ntc2.y < 1.0 && ntc2.x > 0.0 && ntc2.y > 0.0){
	float lensVis = mix(Vis,texture2D(colortex4,0.5/vec2(viewWidth,viewHeight)).y,0.75*exp2(-frameTime/1000.+1./50.));
	vec3 lensC = vec3(0.);
	LensFlare(lensC);
	
	gl_FragData[1].xyz = mix(lensC*length(lightColor), length(lensC)*lightColor,1.0-sunVisibility*0.9)*lensVis*20.;

	}
	
	if (texcoord.x < 1.4/viewWidth && texcoord.y < 1.4/viewHeight){
	//hackish exposure curve
	float targetExposure = clamp(pow(avgLuma,0.66)*pow(700.*10.,0.7)/10.,0.05/(1.0+nightVision*9.),0.35);
	
	float lensVis = mix(Vis,texture2D(colortex4,0.5/vec2(viewWidth,viewHeight)).y,0.75*exp2(-frameTime/1000.+1./50.));

	float mixFactor = 0.065;	
	float avgLum = mix(targetExposure,texture2D(colortex4,0.5/vec2(viewWidth,viewHeight)).x,0.965*exp2(-frameTime/1000.+1./50.));
	
	gl_FragData[2].x = avgLum;
	gl_FragData[2].y = lensVis;
	}

}