#version 120
#define SHARPENING 0.5 //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.8 1.0 1.2 1.5 1.75 2.0]
uniform sampler2D colortex0;

uniform float viewHeight;
uniform float viewWidth;
uniform float frameTimeCounter;
varying vec2 texcoord;

float pw = 1.0/viewWidth;
float ph = 1.0/viewHeight;
float nrand( vec2 n )
{
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float triangWhiteNoise( vec2 n )
{
	//uses white noise for color dithering : gives a somewhat more "filmic" look when noise is visible
	float t = fract( frameTimeCounter );
	float rnd = nrand( n + 0.07*t );

    float center = rnd*2.0-1.0;
    rnd = center*inversesqrt(abs(center));
    rnd = max(-1.0,rnd); 
    return rnd-sign(center);
}

void main() {
//sharpen filter, required to reduce taa blurriness
vec4 neighboor = texture2D(colortex0, texcoord + vec2(pw,0.)) + texture2D(colortex0, texcoord + vec2(-pw,0.)) + texture2D(colortex0, texcoord + vec2(0.,-ph))+texture2D(colortex0, texcoord + vec2(0.,ph));
    gl_FragColor = texture2D(colortex0, texcoord)*(1.+SHARPENING)-neighboor*SHARPENING/4.;
gl_FragColor.a = 1.0;

}