vec4 smoothfilter(in sampler2D tex, in vec2 uv)
{
	vec2 textureResolution = vec2(32.);
	uv = uv*textureResolution + 0.5;
	vec2 iuv = floor( uv );
	vec2 fuv = fract( uv );
	uv = iuv + fuv*fuv*(3.0-2.0*fuv);
	uv = (uv - 0.5)/textureResolution;
	return texture2D( tex, uv);
}

float getWaterBump(vec2 posxz, float waveM, float waveZ, float iswater){

posxz = posxz.yx/1.5;
float radiance = 0.1;

mat2 rotationMatrix = mat2(vec2(cos(radiance), -sin(radiance)),
					vec2(sin(radiance), cos(radiance)));
					
float radiance2 = -0.5;

mat2 rotationMatrix2 = mat2(vec2(cos(radiance2), -sin(radiance2)),
					vec2(sin(radiance2), cos(radiance2)));
	
	float wave = 0.0;
	vec2 movement = abs(vec2(0.0, -frameTimeCounter * 0.00015*(iswater*2.-1.)));
	
	vec2 coord0 = posxz / 1024.0 * waveZ * 1024.0 * rotationMatrix + movement * waveM * 697.0;
	vec2 coord1 = posxz / 1024.0 * waveZ * 1024.0 * rotationMatrix2 + movement * 0.9 * waveM * 697.0;
	vec2 coord2 = posxz / 1024.0 * waveZ * 1024.0 + movement * 0.5 * waveM * 697.0;
	
	coord0.y *= 4.;
	coord1.y *= 4.;
	coord2.y *= 4.;
	
	
	wave += smoothfilter(noisetex,coord0/32).x * 23.0;
	wave += smoothfilter(noisetex,coord1/32.).x * 10.0;
	wave += -smoothfilter(noisetex,coord2.yx*4./32.).x *2.5;

	wave *= mix(0.3,1.0,iswater) * 0.1;
	wave *= 0.157;
	
	return wave;
	
}

vec3 getWaveHeight(vec2 posxz, float iswater){

	vec2 coord = posxz;

		float deltaPos = 0.1;
		
		float waveZ = mix(4.0,0.25,iswater);
		float waveM = mix(0.,2.0,iswater);

		float h0 = getWaterBump(coord, waveM, waveZ, iswater);
		float h1 = getWaterBump(coord + vec2(deltaPos,0.0), waveM, waveZ, iswater);
		float h2 = getWaterBump(coord + vec2(-deltaPos,0.0), waveM, waveZ, iswater);
		float h3 = getWaterBump(coord + vec2(0.0,deltaPos), waveM, waveZ, iswater);
		float h4 = getWaterBump(coord + vec2(0.0,-deltaPos), waveM, waveZ, iswater);

		float xDelta = -((h1-h0))/deltaPos;
		float yDelta = -((h3-h0))/deltaPos;

		vec3 wave = normalize(vec3(xDelta,yDelta,1.0));

		return wave;
}