#version 120
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

	
	

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 ambientNdotL;


varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 viewVector;
varying float dist;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;



uniform sampler2D texture;
uniform sampler2D noisetex;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 cameraPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform int heldBlockLightValue;

#include "lib/waterBump.glsl"




vec4 encode (vec3 n,float dif)
{
    float p = sqrt(n.z*8+8);
	
	float vis = lmcoord.t;
	if (ambientNdotL.a > 0.9) vis = vis / 4.0;
	if (ambientNdotL.a > 0.4 && ambientNdotL.a < 0.6) vis = vis/4.0+0.25;
	if (ambientNdotL.a < 0.1) vis = vis/4.0+0.5;
		
	
    return vec4(n.xy/p + 0.5,vis,1.0);
}
	#define PW_DEPTH 0.4 //[0. 0.1 0.2 0.3 0.4 0.5 1.0 1.5 2.0 2.5 3.0]

	
vec3 getParallaxDisplacement(vec3 posxz, float iswater, float pwMul) {

	float waveZ = mix(2.0,0.25,iswater);
	float waveM = mix(0.5,2.0,iswater);

	vec3 parallaxPos = posxz;
	vec2 vec = viewVector.xy / dist  * 22.0 * PW_DEPTH*pwMul * (1.0-rainStrength*PW_DEPTH);
	float waterHeight = getWaterBump(posxz.xz - posxz.y, waveM, waveZ, iswater) * 0.5;

		parallaxPos.xz -= waterHeight * vec;

	return parallaxPos;
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	float iswater = ambientNdotL.a;
	float diffuse = dot(normalize(sunPosition),normal);
	diffuse = (worldTime > 12700 && worldTime < 23250)? -diffuse : diffuse;
		



	
	vec4 albedo = texture2D(texture, texcoord.xy);
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	if (iswater > 0.9) albedo.rgb = mix(albedo.rgb,vec3(0.35,0.67,0.72),0.8);

	
	vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragposition /= fragposition.w;
	

	
	vec4 worldposition = gbufferModelViewInverse * fragposition;
	vec3 wpos = worldposition.xyz;



	
	vec4 frag2 = vec4((normal), 1.0f);
	

	float bumpmult = 0.4*sqrt(iswater)+0.0;
	float parallaxMult = bumpmult;
			vec3 posxz = wpos+cameraPosition;
		posxz = getParallaxDisplacement(posxz, iswater,parallaxMult);
			
			
	vec3 bump;
	bump = getWaveHeight(posxz.xz - posxz.y,iswater);
			mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
	//const float bumpmult = 0.13457;

	
	bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
						  
	frag2 = vec4(normalize(bump * tbnMatrix), 1.0);


		

	vec3 fColor = albedo.rgb*color.rgb*0.5*170.;

	
	
	float alpha = mix(albedo.a*color.a,0.11,max(iswater*2.0-1.0,0.0));

/* DRAWBUFFERS:02 */
	gl_FragData[0] = vec4(fColor,alpha);
	gl_FragData[1] = encode(frag2.rgb,lmcoord.t);

}