#version 120
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/* DRAWBUFFERS:024 */

#define OPACITY 0.85 							// [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1]

#define RED 0.1									// [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1]
#define GREEN 0.25								// [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1]
#define BLUE 0.4								// [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 1]

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int MAX_OCCLUSION_POINTS = 20;
const float MAX_OCCLUSION_DISTANCE = 100.0;
const float bump_distance = 128.0;				//Bump render distance: tiny = 32, short = 64, normal = 128, far = 256
const float pom_distance = 64.0;				//POM render distance: tiny = 32, short = 64, normal = 128, far = 256
const float fademult = 0.1;
const float PI = 3.1415927;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 wpos;
varying float iswater;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float far;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

float waterH(vec3 posxz) {

		vec2 coord = fract(vec2(posxz.xz / 1000.0));

		float noise  = texture2D(noisetex, coord * 0.5 + vec2(frameTimeCounter / 700.0)).x / 0.5;
			  noise += texture2D(noisetex, coord * 1.0 - vec2(frameTimeCounter / 700.0)).x / 1.0;
			  noise += texture2D(noisetex, coord * 2.5 + vec2(frameTimeCounter / 1500.0)).x / 2.5;
			  noise += texture2D(noisetex, coord * 2.5 - vec2(frameTimeCounter / 1500.0)).x / 2.5;
			  //noise += texture2D(noisetex, coord * 3.5 + vec2(frameTimeCounter / 900.0)).x / 3.5;
			  //noise += texture2D(noisetex, coord * 3.5 - vec2(frameTimeCounter / 900.0)).x / 3.5;

		return noise;
		
float wave = 0.0;

float factor = 1.0;
float amplitude = 0.3;
float speed = 10.0;
float size = .08;

float px = posxz.x/50.0 + 50.0;
float py = posxz.z/50.0 + 50.0;

float fpx = abs(fract(px*250.0)-0.5)*2.0;
float fpy = abs(fract(py*250.0)-0.5)*2.0;

float d = length(vec2(fpx,fpy));

for (int i = 0; i < 3; i++) {
wave -= d*factor*cos( (1/factor)*px*py*size + 1.0*frameTimeCounter*speed);
factor /= 2;
}

factor = 1.0;
px = -posxz.x/ 50.0 + 500.0;
py = -posxz.z/250.0 - 500.0;

fpx = abs(fract(px*250.0)-0.5)*2.0;
fpy = abs(fract(py*250.0)-0.5)*2.0;

d = length(vec2(fpx,fpy));
float wave2 = 0.0;
for (int i = 0; i < 3; i++) {
wave2 -= d*factor*cos( (1/factor)*px*py*size + 1.0*frameTimeCounter*speed);
factor /= 2;
}

return amplitude*wave2+amplitude*wave;
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {	

	vec4 watercolor = vec4(RED, GREEN, BLUE, OPACITY);
	vec4 tex = vec4((watercolor*(color/3)).rgb,watercolor.a);
	if (iswater < 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	
	vec3 posxz = wpos.xyz;

	posxz.x += (posxz.z+frameTimeCounter)*1.25;
	posxz.z += (posxz.x+frameTimeCounter*0.2)*0.25;
	
	float deltaPos = 0.4;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz - vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz - vec3(0.0,0.0,deltaPos));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	float dX = ((h1-h0)+(h0-h2))/deltaPos;
	float dY = ((h3-h0)+(h0-h4))/deltaPos;
	
	vec3 newnormal = normalize(vec3(dX,dY,10.0));
	
	vec4 frag2;
		 frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);
		 
	if (iswater > 0.9) {
		vec3 bump = newnormal;
		float bumpmult = 0.3225;	
		
		bump *= vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							  tangent.y, binormal.y, normal.y,
							  tangent.z, binormal.z, normal.z);
		
		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	}
	gl_FragData[0] = tex;
	gl_FragData[1] = frag2;	
	gl_FragData[2] = vec4(lmcoord.t, mix(1.0,0.05,iswater), lmcoord.s, 1.0);
}