#version 120
#define MAX_COLOR_RANGE 48.0

//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

#define VIGNETTE
	#define VIGNETTE_STRENGTH 0.90

#define LENS_FLARE
	#define LENS_STRENGTH 0.5
    #define RAIN_DROP_LENS
	#define BIG_RAINBOW
	#define ATOM_LENS
	#define SMALL_RAINBOW
	
	
#define BLOOM								//do the "fog blur" in the same time
	#define B_LQ			
	#define B_TRESH 0.1				
	#define B_RAD 5.0					//sampling circle size multiplier, don't affect performance
	#define B_INTENSITY 0.5		//basic multiplier

//#define DOF
	//lens properties
	const float focal = 0.015;
	float aperture = 0.009;	
	const float sizemult = 300.0;

#define COLOR_CORRECTION

#define TONEMAP
	#define TONEMAP_CURVE 3.40
	
#define CONTRAST 0.3

#define GAMMA 0.6	//higher values means darker						
	
#define CROSSPROCESS
	#define BRIGHTMULT 1.0 
	#define DARKMULT 0.0	
	#define COLOR_BOOST	0.0	
	#define HIGHDESATURATE

#define GLARE
	#define GLARE_INTENSITY 0.35
	#define GLARE_OFFSET 1.0
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



varying vec4 texcoord;
varying vec3 sunlight;

uniform sampler2D depthtex0;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D texture;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D composite;
uniform sampler2D gnormal;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
varying vec3 ambient_color;
varying vec3 moonlight;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
varying float moonVisibility;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#ifdef BLOOM
	#ifdef B_LQ
		const vec2 offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif
	
#endif


#ifdef DOF

//hexagon pattern
const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
									vec2(  0.0000,  0.2500 ),
									vec2( -0.2165,  0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2(  0.2165, -0.1250 ),
									vec2(  0.4330,  0.2500 ),
									vec2(  0.0000,  0.5000 ),
									vec2( -0.4330,  0.2500 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.0000, -0.5000 ),
									vec2(  0.4330, -0.2500 ),
									vec2(  0.6495,  0.3750 ),
									vec2(  0.0000,  0.7500 ),
									vec2( -0.6495,  0.3750 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.0000, -0.7500 ),
									vec2(  0.6495, -0.3750 ),
									vec2(  0.8660,  0.5000 ),
									vec2(  0.0000,  1.0000 ),
									vec2( -0.8660,  0.5000 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.0000, -1.0000 ),
									vec2(  0.8660, -0.5000 ),
									vec2(  0.2163,  0.3754 ),
									vec2( -0.2170,  0.3750 ),
									vec2( -0.4333, -0.0004 ),
									vec2( -0.2163, -0.3754 ),
									vec2(  0.2170, -0.3750 ),
									vec2(  0.4333,  0.0004 ),
									vec2(  0.4328,  0.5004 ),
									vec2( -0.2170,  0.6250 ),
									vec2( -0.6498,  0.1246 ),
									vec2( -0.4328, -0.5004 ),
									vec2(  0.2170, -0.6250 ),
									vec2(  0.6498, -0.1246 ),
									vec2(  0.6493,  0.6254 ),
									vec2( -0.2170,  0.8750 ),
									vec2( -0.8663,  0.2496 ),
									vec2( -0.6493, -0.6254 ),
									vec2(  0.2170, -0.8750 ),
									vec2(  0.8663, -0.2496 ),
									vec2(  0.2160,  0.6259 ),
									vec2( -0.4340,  0.5000 ),
									vec2( -0.6500, -0.1259 ),
									vec2( -0.2160, -0.6259 ),
									vec2(  0.4340, -0.5000 ),
									vec2(  0.6500,  0.1259 ),
									vec2(  0.4325,  0.7509 ),
									vec2( -0.4340,  0.7500 ),
									vec2( -0.8665, -0.0009 ),
									vec2( -0.4325, -0.7509 ),
									vec2(  0.4340, -0.7500 ),
									vec2(  0.8665,  0.0009 ),
									vec2(  0.2158,  0.8763 ),
									vec2( -0.6510,  0.6250 ),
									vec2( -0.8668, -0.2513 ),
									vec2( -0.2158, -0.8763 ),
									vec2(  0.6510, -0.6250 ),
									vec2(  0.8668,  0.2513 ));

#endif

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
/*
float A = 0.15;
float B = 0.50;
float C = 0.10;
float D = 0.20;
float E = 0.02;
float F = 0.30;
float W = 4.2;
*/

float A = 0.15;
float B = 0.2;
float C = 0.1;
float D = 0.2;
float E = 0.02;
float F = 0.3;
float W = MAX_COLOR_RANGE;

vec3 Uncharted2Tonemap(vec3 x) {
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),
								
								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),
								
								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),
								
								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);
								
float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,3.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 
void main() {
	vec2 fake_refract = vec2(sin(worldTime/15.0 + texcoord.x*100.0 + texcoord.y*50.0),cos(worldTime/15.0 + texcoord.y*100.0 + texcoord.x*50.0)) * isEyeInWater;
	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.005).rgb;
#ifdef DOF
	
	//Calculate pixel Circle of Confusion that will be used for bokeh depth of field
	float z = ld(texture2D(depthtex0, texcoord.st).r)*far;
	float focus = ld(texture2D(depthtex0, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*10.0);		
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = vec3(0.0);
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);

	for ( int i = 0; i < 60; i++) {
		sample = texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio));
		bcolor += sample.rgb;
	}
	
	color.rgb = bcolor/60.0;
	
#endif
	
	float plum = luma(color.rgb);

#ifdef BLOOM
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
	vec3 blur = vec3(0.0);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*4.0,0.8),0.0,1.0)+0.1;
	float fog = 0.0;
	fog = 1.0-clamp(exp(-ld(texture2D(depthtex0, texcoord.st).r)),0.0,1.0);
	#ifdef B_LQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 25; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/25.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
		color += csample/25.0*B_INTENSITY;
	#endif

	
	
#endif


color.rgb += texture2D(gaux4,texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;
		
#ifdef LENS_FLARE
float xdist = abs(lightPos.x-texcoord.x);
float ydist = abs(lightPos.y-texcoord.y);
float xydist = distance(lightPos.xy,texcoord.xy);
float xydistratio = distratio(lightPos.xy,texcoord.xy,aspectRatio);

float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

float time = float(worldTime);
float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;

float centerdist = distance(lightPos.xy,vec2(0.5))/1.0;
float sizemult = 2.0 + centerdist;
float noise = fract(sin(dot(texcoord.st ,vec2(18.9898f,28.633f))) * 4378.5453f)*0.1 + 0.9;
							
float circles_lens = 0.0;

#ifdef RAIN_DROP_LENS
//LITTLE DOTS ON SCREEN

if (sunvisibility > 0.05) {

if (xydist < 0.35) {
vec2 sun_to_center = lightPos-vec2(0.5);
float dir = abs(sin(length(sun_to_center)))*0.25+0.75;

for (int i = 0; i < 8; i++) {
vec3 carac = pattern[i]*1.25;

carac.z *= 1.0/1.25;
carac.x /= aspectRatio;
carac *= (1.0 + dir)/2.0;

vec2 coord = carac.xy * sizemult+ lightPos.xy;
float strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*0.75)*strength;

carac = pattern[i];
carac.x /= aspectRatio;
carac.yx *= (2.0 - dir)/2.5;

coord = -carac.yx * sizemult + lightPos.xy;
strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*0.66)*strength;
}
color += sunlight*vec3(circles_lens) * sunvisibility * noise * 0.25;
color += TimeMidnight*vec3(circles_lens)*+0.1;
color += rainx*vec3(circles_lens)*0.0;

circles_lens -= 0.1 * TimeSunrise;
circles_lens += 0.2 * TimeNoon;
circles_lens -= 0.1 * TimeSunset;
}
}
#endif
vec3 sP = sunPosition;

			vec2 lPos = lightPos;

			if (fading > 0.01 && TimeMidnight < 1.0) {
	
			float sunmask = 0.0f;
			float sunstep = -4.5f;
			float masksize = 0.004f;

			sunmask = texture2D(gaux2,vec2(0.0)).a;

			sunmask *= LENS_STRENGTH * (2.0f - TimeMidnight)*fading;
			sunmask *= 1.0 - rainx;
					
			if (sunmask > 0.02) {
			
			//Detect if sun is on edge of screen
				float edgemaskx = clamp(distance(lPos.x, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
				float edgemasky = clamp(distance(lPos.y, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
			
				const float flaremultR = 1.5f;
				const float flaremultG = 1.5f;
				const float flaremultB = 1.5f;
				
			////Darken colors if the sun is visible
				float centermask = 1.0 - clamp(distance(lPos.xy, vec2(0.5f, 0.5f))*2.0, 0.0, 1.0);
				centermask = pow(centermask, 1.0f);
				centermask *= sunmask;
			
				float flarescale = 1.0f;
				const float flarescaleconst = 1.0f;
				
			//Flare gets bigger at center of screen
				flarescale *= (1.0 - centermask);		

					
					

	//-//Custom lens flare//-//				
\
 
 /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW_RAINBOW
                 
 //lens
 //Lens
 
   
       
        float flarescale2 = 1.1f;
       
        float flarescale3 = 2.0f;
       
        float flarescale4 = 1.5f;
 
    vec3 tempColor = vec3(0.0);
       
        vec3 tempColor3 = vec3(0.0);
       
        vec3 tempColor4 = vec3(0.0);
                 
        vec2 resolution = vec2(viewWidth, viewHeight);
 
        float PI = 3.141592;
 
        vec2 uv = (texcoord.xy);
 
        float random = fract(sin(dot(sunPosition.xy, vec2(12.9898, 78.233)))* 43758.5453);
       
                random - 0.25f;
 
                if (random < 0.25f)
                {
                        random = 0.25f;
                }
       
        float c = 0.0;
        float dx = uv.x - 0.5;
        float dy = uv.y - 0.5;
        c = (atan(dy, dx) / PI + 1.0) * 1.0;
        float t = (sin(random) + 1.0) * 1.0;
        c = tan(c * t * 1000.0);
       
       
        vec4 tempColor2 = vec4(c, c, c, 1.0 );
       
       
                if (tempColor2.r < 0.7f)
                {
                        tempColor2.r = 0.7f;
                }
                else if (tempColor2.r > 1.0f)
                {
                        tempColor2.r = 1.0f;
                }
               
                sin(tempColor2);
 
                //color.r = tempColor2.r;
                //color.g = tempColor2.r;
                //color.b = tempColor2.r;
                 
 
 
#ifdef BIG_RAINBOW 
//-------------------Red--------------------------------------------------------------------------------------
 
                        vec2 flare_Red_scale = vec2(0.9f*flarescale2, 0.9f*flarescale2);
                          float flare_Red_pow = 4.25f;
                          float flare_Red_fill = 10.0f;
                          float flare_Red_offset = -0.0f;
                        vec2 flare_Red_pos = vec2(  ((1.0 - lPos.x)*(flare_Red_offset + 1.0) - (flare_Red_offset*0.5))  *aspectRatio*flare_Red_scale.x,  ((1.0 - lPos.y)*(flare_Red_offset + 1.0) - (flare_Red_offset*0.5))  *flare_Red_scale.y);
                       
                       
                        float flare_Red_ = distance(flare_Red_pos, vec2(texcoord.s*aspectRatio*flare_Red_scale.x, texcoord.t*flare_Red_scale.y));
                                  flare_Red_ = 0.5 - flare_Red_;
                                  flare_Red_ = clamp(flare_Red_*flare_Red_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Red_ = sin(flare_Red_*1.57075);
                                 
                                  flare_Red_ = pow(flare_Red_, 1.1f);
                                 
                                  flare_Red_ *= flare_Red_pow;                
                                 
                                 
                                  //subtract
                                  vec2 flare_RedD_scale = vec2(0.58*flarescale2, 0.58*flarescale2);
                                  float flare_RedD_pow = 8.0f;
                                  float flare_RedD_fill = 1.4f;
                                  float flare_RedD_offset = -0.2f;
                                vec2 flare_RedD_pos = vec2(  ((1.0 - lPos.x)*(flare_RedD_offset + 1.0) - (flare_RedD_offset*0.5))  *aspectRatio*flare_RedD_scale.x,  ((1.0 - lPos.y)*(flare_RedD_offset + 1.0) - (flare_RedD_offset*0.5))  *flare_RedD_scale.y);
                       
                       
                                float flare_RedD_ = distance(flare_RedD_pos, vec2(texcoord.s*aspectRatio*flare_RedD_scale.x, texcoord.t*flare_RedD_scale.y));
                                        flare_RedD_ = 0.5 - flare_RedD_;
                                        flare_RedD_ = clamp(flare_RedD_*flare_RedD_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_RedD_ = sin(flare_RedD_*1.57075);
                                        flare_RedD_ = pow(flare_RedD_, 0.9f);
                                 
                                        flare_RedD_ *= flare_RedD_pow;
                                 
                                flare_Red_ = clamp(flare_Red_ - flare_RedD_, 0.0, 10.0);
                                flare_Red_ *= sunmask;
                                 
                                        tempColor.r += flare_Red_*1.0f*flaremultR * tempColor2.r;
                                        tempColor.g += flare_Red_*0.0f*flaremultG * tempColor2.r;
                                        tempColor.b += flare_Red_*0.0f*flaremultB * tempColor2.r;              
               
//--------------------------------------------------------------------------------------
   
//-------------------Orange--------------------------------------------------------------------------------------
 
                        vec2 flare_Orange_scale = vec2(0.86f*flarescale2, 0.86f*flarescale2);
                          float flare_Orange_pow = 4.25f;
                          float flare_Orange_fill = 10.0f;
                          float flare_Orange_offset = -0.0f;
                        vec2 flare_Orange_pos = vec2(  ((1.0 - lPos.x)*(flare_Orange_offset + 1.0) - (flare_Orange_offset*0.5))  *aspectRatio*flare_Orange_scale.x,  ((1.0 - lPos.y)*(flare_Orange_offset + 1.0) - (flare_Orange_offset*0.5))  *flare_Orange_scale.y);
                       
                       
                        float flare_Orange_ = distance(flare_Orange_pos, vec2(texcoord.s*aspectRatio*flare_Orange_scale.x, texcoord.t*flare_Orange_scale.y));
                                  flare_Orange_ = 0.5 - flare_Orange_;
                                  flare_Orange_ = clamp(flare_Orange_*flare_Orange_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Orange_ = sin(flare_Orange_*1.57075);
                                 
                                  flare_Orange_ = pow(flare_Orange_, 1.1f);
                                 
                                  flare_Orange_ *= flare_Orange_pow;                  
                                 
                                 
                                  //subtract
                                  vec2 flare_OrangeD_scale = vec2(0.5446f*flarescale2, 0.5446f*flarescale2);
                                  float flare_OrangeD_pow = 8.0f;
                                  float flare_OrangeD_fill = 1.4f;
                                  float flare_OrangeD_offset = -0.2f;
                                vec2 flare_OrangeD_pos = vec2(  ((1.0 - lPos.x)*(flare_OrangeD_offset + 1.0) - (flare_OrangeD_offset*0.5))  *aspectRatio*flare_OrangeD_scale.x,  ((1.0 - lPos.y)*(flare_OrangeD_offset + 1.0) - (flare_OrangeD_offset*0.5))  *flare_OrangeD_scale.y);
                       
                       
                                float flare_OrangeD_ = distance(flare_OrangeD_pos, vec2(texcoord.s*aspectRatio*flare_OrangeD_scale.x, texcoord.t*flare_OrangeD_scale.y));
                                        flare_OrangeD_ = 0.5 - flare_OrangeD_;
                                        flare_OrangeD_ = clamp(flare_OrangeD_*flare_OrangeD_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_OrangeD_ = sin(flare_OrangeD_*1.57075);
                                        flare_OrangeD_ = pow(flare_OrangeD_, 0.9f);
                                 
                                        flare_OrangeD_ *= flare_OrangeD_pow;
                                 
                                flare_Orange_ = clamp(flare_Orange_ - flare_OrangeD_, 0.0, 10.0);
                                flare_Orange_ *= sunmask;
                                 
                                        tempColor.r += flare_Orange_*1.0f*flaremultR * tempColor2.r;
                                        tempColor.g += flare_Orange_*1.0f*flaremultG * tempColor2.r;
                                        tempColor.b += flare_Orange_*0.0f*flaremultB * tempColor2.r;  
               
//--------------------------------------------------------------------------------------
   
//-------------------Green--------------------------------------------------------------------------------------
 
            vec2 flare_Green_scale = vec2(0.82f*flarescale2, 0.82f*flarescale2);
                          float flare_Green_pow = 4.25f;
                          float flare_Green_fill = 10.0f;
                          float flare_Green_offset = -0.0f;
                        vec2 flare_Green_pos = vec2(  ((1.0 - lPos.x)*(flare_Green_offset + 1.0) - (flare_Green_offset*0.5))  *aspectRatio*flare_Green_scale.x,  ((1.0 - lPos.y)*(flare_Green_offset + 1.0) - (flare_Green_offset*0.5))  *flare_Green_scale.y);
                       
                       
                        float flare_Green_ = distance(flare_Green_pos, vec2(texcoord.s*aspectRatio*flare_Green_scale.x, texcoord.t*flare_Green_scale.y));
                                  flare_Green_ = 0.5 - flare_Green_;
                                  flare_Green_ = clamp(flare_Green_*flare_Green_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Green_ = sin(flare_Green_*1.57075);
                                 
                                  flare_Green_ = pow(flare_Green_, 1.1f);
                                 
                                  flare_Green_ *= flare_Green_pow;                    
                                 
                                 
                                  //subtract
                                  vec2 flare_GreenD_scale = vec2(0.5193f*flarescale2, 0.5193f*flarescale2);
                                  float flare_GreenD_pow = 8.0f;
                                  float flare_GreenD_fill = 1.4f;
                                  float flare_GreenD_offset = -0.2f;
                                vec2 flare_GreenD_pos = vec2(  ((1.0 - lPos.x)*(flare_GreenD_offset + 1.0) - (flare_GreenD_offset*0.5))  *aspectRatio*flare_GreenD_scale.x,  ((1.0 - lPos.y)*(flare_GreenD_offset + 1.0) - (flare_GreenD_offset*0.5))  *flare_GreenD_scale.y);
                       
                       
                                float flare_GreenD_ = distance(flare_GreenD_pos, vec2(texcoord.s*aspectRatio*flare_GreenD_scale.x, texcoord.t*flare_GreenD_scale.y));
                                        flare_GreenD_ = 0.5 - flare_GreenD_;
                                        flare_GreenD_ = clamp(flare_GreenD_*flare_GreenD_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_GreenD_ = sin(flare_GreenD_*1.57075);
                                        flare_GreenD_ = pow(flare_GreenD_, 0.9f);
                                 
                                        flare_GreenD_ *= flare_GreenD_pow;
                                 
                                flare_Green_ = clamp(flare_Green_ - flare_GreenD_, 0.0, 10.0);
                                flare_Green_ *= sunmask;
                                 
                                        tempColor.r += flare_Green_*0.0f*flaremultR * tempColor2.r;
                                        tempColor.g += flare_Green_*1.0f*flaremultG * tempColor2.r;
                                        tempColor.b += flare_Green_*0.0f*flaremultB * tempColor2.r;              
               
//--------------------------------------------------------------------------------------
 
//-------------------Blue--------------------------------------------------------------------------------------
 
        vec2 flare_Blue_scale = vec2(0.78f*flarescale2, 0.78f*flarescale2);
                          float flare_Blue_pow = 4.25f;
                          float flare_Blue_fill = 10.0f;
                          float flare_Blue_offset = -0.0f;
                        vec2 flare_Blue_pos = vec2(  ((1.0 - lPos.x)*(flare_Blue_offset + 1.0) - (flare_Blue_offset*0.5))  *aspectRatio*flare_Blue_scale.x,  ((1.0 - lPos.y)*(flare_Blue_offset + 1.0) - (flare_Blue_offset*0.5))  *flare_Blue_scale.y);
                       
                       
                        float flare_Blue_ = distance(flare_Blue_pos, vec2(texcoord.s*aspectRatio*flare_Blue_scale.x, texcoord.t*flare_Blue_scale.y));
                                  flare_Blue_ = 0.5 - flare_Blue_;
                                  flare_Blue_ = clamp(flare_Blue_*flare_Blue_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Blue_ = sin(flare_Blue_*1.57075);
                                 
                                  flare_Blue_ = pow(flare_Blue_, 1.1f);
                                 
                                  flare_Blue_ *= flare_Blue_pow;                      
                                 
                                 
                                  //subtract
                                  vec2 flare_BlueD_scale = vec2(0.494f*flarescale2, 0.494f*flarescale2);
                                  float flare_BlueD_pow = 8.0f;
                                  float flare_BlueD_fill = 1.4f;
                                  float flare_BlueD_offset = -0.2f;
                                vec2 flare_BlueD_pos = vec2(  ((1.0 - lPos.x)*(flare_BlueD_offset + 1.0) - (flare_BlueD_offset*0.5))  *aspectRatio*flare_BlueD_scale.x,  ((1.0 - lPos.y)*(flare_BlueD_offset + 1.0) - (flare_BlueD_offset*0.5))  *flare_BlueD_scale.y);
                       
                       
                                float flare_BlueD_ = distance(flare_BlueD_pos, vec2(texcoord.s*aspectRatio*flare_BlueD_scale.x, texcoord.t*flare_BlueD_scale.y));
                                        flare_BlueD_ = 0.5 - flare_BlueD_;
                                        flare_BlueD_ = clamp(flare_BlueD_*flare_BlueD_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_BlueD_ = sin(flare_BlueD_*1.57075);
                                        flare_BlueD_ = pow(flare_BlueD_, 0.9f);
                                 
                                        flare_BlueD_ *= flare_BlueD_pow;
                                 
                                flare_Blue_ = clamp(flare_Blue_ - flare_BlueD_, 0.0, 10.0);
                                flare_Blue_ *= sunmask;
                                 
                                        tempColor.r += flare_Blue_*0.0f*flaremultR * tempColor2.r;
                                        tempColor.g += flare_Blue_*0.0f*flaremultG * tempColor2.r;
                                        tempColor.b += flare_Blue_*1.0f*flaremultB * tempColor2.r;  
               
//--------------------------------------------------------------------------------------
#endif 
 
//RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_RAINBOW_2_
 
 #ifdef SMALL_RAINBOW
//-------------------Red2--------------------------------------------------------------------------------------
 
                        vec2 flare_Red2_scale = vec2(0.9f*flarescale3, 0.9f*flarescale3);
                          float flare_Red2_pow = 4.25f;
                          float flare_Red2_fill = 10.0f;
                          float flare_Red2_offset = -0.0f;
                        vec2 flare_Red2_pos = vec2(  ((1.0 - lPos.x)*(flare_Red2_offset + 1.0) - (flare_Red2_offset*0.5))  *aspectRatio*flare_Red2_scale.x,  ((1.0 - lPos.y)*(flare_Red2_offset + 1.0) - (flare_Red2_offset*0.5))  *flare_Red2_scale.y);
                       
                       
                        float flare_Red2_ = distance(flare_Red2_pos, vec2(texcoord.s*aspectRatio*flare_Red2_scale.x, texcoord.t*flare_Red2_scale.y));
                                  flare_Red2_ = 0.5 - flare_Red2_;
                                  flare_Red2_ = clamp(flare_Red2_*flare_Red2_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Red2_ = sin(flare_Red2_*1.57075);
                                 
                                  flare_Red2_ = pow(flare_Red2_, 1.1f);
                                 
                                  flare_Red2_ *= flare_Red2_pow;                      
                                 
                                 
                                  //subtract
                                  vec2 flare_Red2D_scale = vec2(0.58*flarescale3, 0.58*flarescale3);
                                  float flare_Red2D_pow = 8.0f;
                                  float flare_Red2D_fill = 1.4f;
                                  float flare_Red2D_offset = -0.2f;
                                vec2 flare_Red2D_pos = vec2(  ((1.0 - lPos.x)*(flare_Red2D_offset + 1.0) - (flare_Red2D_offset*0.5))  *aspectRatio*flare_Red2D_scale.x,  ((1.0 - lPos.y)*(flare_Red2D_offset + 1.0) - (flare_Red2D_offset*0.5))  *flare_Red2D_scale.y);
                       
                       
                                float flare_Red2D_ = distance(flare_Red2D_pos, vec2(texcoord.s*aspectRatio*flare_Red2D_scale.x, texcoord.t*flare_Red2D_scale.y));
                                        flare_Red2D_ = 0.5 - flare_Red2D_;
                                        flare_Red2D_ = clamp(flare_Red2D_*flare_Red2D_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_Red2D_ = sin(flare_Red2D_*1.57075);
                                        flare_Red2D_ = pow(flare_Red2D_, 0.9f);
                                 
                                        flare_Red2D_ *= flare_Red2D_pow;
                                 
                                flare_Red2_ = clamp(flare_Red2_ - flare_Red2D_, 0.0, 10.0);
                                flare_Red2_ *= sunmask;
                                 
                                        tempColor3.r += flare_Red2_*10.0f*flaremultR * (tempColor2.r / 16);
                                        tempColor3.g += flare_Red2_*0.0f*flaremultG * (tempColor2.r / 16);
                                        tempColor3.b += flare_Red2_*0.0f*flaremultB * (tempColor2.r / 16);            
               
//--------------------------------------------------------------------------------------
   
//-------------------Orange2--------------------------------------------------------------------------------------
 
                        vec2 flare_Orange2_scale = vec2(0.86f*flarescale3, 0.86f*flarescale3);
                          float flare_Orange2_pow = 4.25f;
                          float flare_Orange2_fill = 10.0f;
                          float flare_Orange2_offset = -0.0f;
                        vec2 flare_Orange2_pos = vec2(  ((1.0 - lPos.x)*(flare_Orange2_offset + 1.0) - (flare_Orange2_offset*0.5))  *aspectRatio*flare_Orange2_scale.x,  ((1.0 - lPos.y)*(flare_Orange2_offset + 1.0) - (flare_Orange2_offset*0.5))  *flare_Orange2_scale.y);
                       
                       
                        float flare_Orange2_ = distance(flare_Orange2_pos, vec2(texcoord.s*aspectRatio*flare_Orange2_scale.x, texcoord.t*flare_Orange2_scale.y));
                                  flare_Orange2_ = 0.5 - flare_Orange2_;
                                  flare_Orange2_ = clamp(flare_Orange2_*flare_Orange2_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Orange2_ = sin(flare_Orange2_*1.57075);
                                 
                                  flare_Orange2_ = pow(flare_Orange2_, 1.1f);
                                 
                                  flare_Orange2_ *= flare_Orange2_pow;                
                                 
                                 
                                  //subtract
                                  vec2 flare_Orange2D_scale = vec2(0.5446f*flarescale3, 0.5446f*flarescale3);
                                  float flare_Orange2D_pow = 8.0f;
                                  float flare_Orange2D_fill = 1.4f;
                                  float flare_Orange2D_offset = -0.2f;
                                vec2 flare_Orange2D_pos = vec2(  ((1.0 - lPos.x)*(flare_Orange2D_offset + 1.0) - (flare_Orange2D_offset*0.5))  *aspectRatio*flare_Orange2D_scale.x,  ((1.0 - lPos.y)*(flare_Orange2D_offset + 1.0) - (flare_Orange2D_offset*0.5))  *flare_Orange2D_scale.y);
                       
                       
                                float flare_Orange2D_ = distance(flare_Orange2D_pos, vec2(texcoord.s*aspectRatio*flare_Orange2D_scale.x, texcoord.t*flare_Orange2D_scale.y));
                                        flare_Orange2D_ = 0.5 - flare_Orange2D_;
                                        flare_Orange2D_ = clamp(flare_Orange2D_*flare_Orange2D_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_Orange2D_ = sin(flare_Orange2D_*1.57075);
                                        flare_Orange2D_ = pow(flare_Orange2D_, 0.9f);
                                 
                                        flare_Orange2D_ *= flare_Orange2D_pow;
                                 
                                flare_Orange2_ = clamp(flare_Orange2_ - flare_Orange2D_, 0.0, 10.0);
                                flare_Orange2_ *= sunmask;
                                 
                                        tempColor3.r += flare_Orange2_*10.0f*flaremultR * (tempColor2.r / 16);
                                        tempColor3.g += flare_Orange2_*5.0f*flaremultG * (tempColor2.r / 16);
                                        tempColor3.b += flare_Orange2_*0.0f*flaremultB * (tempColor2.r / 16);
               
//--------------------------------------------------------------------------------------
   
//-------------------Green2--------------------------------------------------------------------------------------
 
            vec2 flare_Green2_scale = vec2(0.82f*flarescale3, 0.82f*flarescale3);
                          float flare_Green2_pow = 4.25f;
                          float flare_Green2_fill = 10.0f;
                          float flare_Green2_offset = -0.0f;
                        vec2 flare_Green2_pos = vec2(  ((1.0 - lPos.x)*(flare_Green2_offset + 1.0) - (flare_Green2_offset*0.5))  *aspectRatio*flare_Green2_scale.x,  ((1.0 - lPos.y)*(flare_Green2_offset + 1.0) - (flare_Green2_offset*0.5))  *flare_Green2_scale.y);
                       
                       
                        float flare_Green2_ = distance(flare_Green2_pos, vec2(texcoord.s*aspectRatio*flare_Green2_scale.x, texcoord.t*flare_Green2_scale.y));
                                  flare_Green2_ = 0.5 - flare_Green2_;
                                  flare_Green2_ = clamp(flare_Green2_*flare_Green2_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Green2_ = sin(flare_Green2_*1.57075);
                                 
                                  flare_Green2_ = pow(flare_Green2_, 1.1f);
                                 
                                  flare_Green2_ *= flare_Green2_pow;                  
                                 
                                 
                                  //subtract
                                  vec2 flare_Green2D_scale = vec2(0.5193f*flarescale3, 0.5193f*flarescale3);
                                  float flare_Green2D_pow = 8.0f;
                                  float flare_Green2D_fill = 1.4f;
                                  float flare_Green2D_offset = -0.2f;
                                vec2 flare_Green2D_pos = vec2(  ((1.0 - lPos.x)*(flare_Green2D_offset + 1.0) - (flare_Green2D_offset*0.5))  *aspectRatio*flare_Green2D_scale.x,  ((1.0 - lPos.y)*(flare_Green2D_offset + 1.0) - (flare_Green2D_offset*0.5))  *flare_Green2D_scale.y);
                       
                       
                                float flare_Green2D_ = distance(flare_Green2D_pos, vec2(texcoord.s*aspectRatio*flare_Green2D_scale.x, texcoord.t*flare_Green2D_scale.y));
                                        flare_Green2D_ = 0.5 - flare_Green2D_;
                                        flare_Green2D_ = clamp(flare_Green2D_*flare_Green2D_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_Green2D_ = sin(flare_Green2D_*1.57075);
                                        flare_Green2D_ = pow(flare_Green2D_, 0.9f);
                                 
                                        flare_Green2D_ *= flare_Green2D_pow;
                                 
                                flare_Green2_ = clamp(flare_Green2_ - flare_Green2D_, 0.0, 10.0);
                                flare_Green2_ *= sunmask;
                                 
                                        tempColor3.r += flare_Green2_*0.0f*flaremultR * (tempColor2.r / 2);
                                        tempColor3.g += flare_Green2_*1.0f*flaremultG * (tempColor2.r / 2);
                                        tempColor3.b += flare_Green2_*0.0f*flaremultB * (tempColor2.r / 2);  
               
//--------------------------------------------------------------------------------------
 
//-------------------Blue2--------------------------------------------------------------------------------------
 
        vec2 flare_Blue2_scale = vec2(0.78f*flarescale3, 0.78f*flarescale3);
                          float flare_Blue2_pow = 4.25f;
                          float flare_Blue2_fill = 10.0f;
                          float flare_Blue2_offset = -0.0f;
                        vec2 flare_Blue2_pos = vec2(  ((1.0 - lPos.x)*(flare_Blue2_offset + 1.0) - (flare_Blue2_offset*0.5))  *aspectRatio*flare_Blue2_scale.x,  ((1.0 - lPos.y)*(flare_Blue2_offset + 1.0) - (flare_Blue2_offset*0.5))  *flare_Blue2_scale.y);
                       
                       
                        float flare_Blue2_ = distance(flare_Blue2_pos, vec2(texcoord.s*aspectRatio*flare_Blue2_scale.x, texcoord.t*flare_Blue2_scale.y));
                                  flare_Blue2_ = 0.5 - flare_Blue2_;
                                  flare_Blue2_ = clamp(flare_Blue2_*flare_Blue2_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                  flare_Blue2_ = sin(flare_Blue2_*1.57075);
                                 
                                  flare_Blue2_ = pow(flare_Blue2_, 1.1f);
                                 
                                  flare_Blue2_ *= flare_Blue2_pow;                    
                                 
                                 
                                  //subtract
                                  vec2 flare_Blue2D_scale = vec2(0.494f*flarescale3, 0.494f*flarescale3);
                                  float flare_Blue2D_pow = 8.0f;
                                  float flare_Blue2D_fill = 1.4f;
                                  float flare_Blue2D_offset = -0.2f;
                                vec2 flare_Blue2D_pos = vec2(  ((1.0 - lPos.x)*(flare_Blue2D_offset + 1.0) - (flare_Blue2D_offset*0.5))  *aspectRatio*flare_Blue2D_scale.x,  ((1.0 - lPos.y)*(flare_Blue2D_offset + 1.0) - (flare_Blue2D_offset*0.5))  *flare_Blue2D_scale.y);
                       
                       
                                float flare_Blue2D_ = distance(flare_Blue2D_pos, vec2(texcoord.s*aspectRatio*flare_Blue2D_scale.x, texcoord.t*flare_Blue2D_scale.y));
                                        flare_Blue2D_ = 0.5 - flare_Blue2D_;
                                        flare_Blue2D_ = clamp(flare_Blue2D_*flare_Blue2D_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
                                        flare_Blue2D_ = sin(flare_Blue2D_*1.57075);
                                        flare_Blue2D_ = pow(flare_Blue2D_, 0.9f);
                                 
                                        flare_Blue2D_ *= flare_Blue2D_pow;
                                 
                                flare_Blue2_ = clamp(flare_Blue2_ - flare_Blue2D_, 0.0, 10.0);
                                flare_Blue2_ *= sunmask;
                                 
                                        tempColor3.r += flare_Blue2_*0.0f*flaremultR * (tempColor2.r / 2);
                                        tempColor3.g += flare_Blue2_*0.0f*flaremultG * (tempColor2.r / 2);
                                        tempColor3.b += flare_Blue2_*1.0f*flaremultB * (tempColor2.r / 2);
               
//--------------------------------------------------------------------------------------
 #endif
 

 
        color += (tempColor3 / 4.0f);
        color += (tempColor4 / 1.0f);
    color += (tempColor * 1.0f);
                 
                 
                 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                       
                 
                 
         
         //Center white flare
         vec2 flare1scale = vec2(1.7f*flarescale, 1.7f*flarescale);
         float flare1pow = 12.0f;
         vec2 flare1pos = vec2(lPos.x*aspectRatio*flare1scale.x, lPos.y*flare1scale.y);
         
         
         float flare1 = distance(flare1pos, vec2(texcoord.s*aspectRatio*flare1scale.x, texcoord.t*flare1scale.y));
              flare1 = 0.5 - flare1;
              flare1 = clamp(flare1, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
              flare1 *= sunmask;
              flare1 = pow(flare1, 1.8f);
             
              flare1 *= flare1pow;
             
                 color.r += flare1*0.7f*flaremultR;
               color.g += flare1*0.4f*flaremultG;
               color.b += flare1*0.2f*flaremultB;  
                       
                     
                     
         //Center white flare
           vec2 flare1Bscale = vec2(0.5f*flarescale, 0.5f*flarescale);
           float flare1Bpow = 6.0f;
         vec2 flare1Bpos = vec2(lPos.x*aspectRatio*flare1Bscale.x, lPos.y*flare1Bscale.y);
         
         
         float flare1B = distance(flare1Bpos, vec2(texcoord.s*aspectRatio*flare1Bscale.x, texcoord.t*flare1Bscale.y));
              flare1B = 0.5 - flare1B;
              flare1B = clamp(flare1B, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
              flare1B *= sunmask;
              flare1B = pow(flare1B, 1.8f);
             
              flare1B *= flare1Bpow;
             
                 color.r += flare1B*0.7f*flaremultR;
               color.g += flare1B*0.2f*flaremultG;
               color.b += flare1B*0.0f*flaremultB;  
             
             
         
               
               
         //Far blue flare MAIN
           vec2 flare3scale = vec2(2.0f*flarescale, 2.0f*flarescale);
           float flare3pow = 0.7f;
           float flare3fill = 10.0f;
           float flare3offset = -0.5f;
         vec2 flare3pos = vec2(  ((1.0 - lPos.x)*(flare3offset + 1.0) - (flare3offset*0.5))  *aspectRatio*flare3scale.x,  ((1.0 - lPos.y)*(flare3offset + 1.0) - (flare3offset*0.5))  *flare3scale.y);
         
         
         float flare3 = distance(flare3pos, vec2(texcoord.s*aspectRatio*flare3scale.x, texcoord.t*flare3scale.y));
              flare3 = 0.5 - flare3;
              flare3 = clamp(flare3*flare3fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare3 = sin(flare3*1.57075);
              flare3 *= sunmask;
              flare3 = pow(flare3, 1.1f);
             
              flare3 *= flare3pow;        
             
             
              //subtract from blue flare
              vec2 flare3Bscale = vec2(1.4f*flarescale, 1.4f*flarescale);
              float flare3Bpow = 1.0f;
              float flare3Bfill = 2.0f;
              float flare3Boffset = -0.65f;
            vec2 flare3Bpos = vec2(  ((1.0 - lPos.x)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *aspectRatio*flare3Bscale.x,  ((1.0 - lPos.y)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *flare3Bscale.y);
         
         
            float flare3B = distance(flare3Bpos, vec2(texcoord.s*aspectRatio*flare3Bscale.x, texcoord.t*flare3Bscale.y));
               flare3B = 0.5 - flare3B;
               flare3B = clamp(flare3B*flare3Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare3B = sin(flare3B*1.57075);
               flare3B *= sunmask;
               flare3B = pow(flare3B, 0.9f);
             
               flare3B *= flare3Bpow;
             
            flare3 = clamp(flare3 - flare3B, 0.0, 10.0);
             
             
                 color.r += flare3*0.5f*flaremultR;
               color.g += flare3*0.3f*flaremultG;
               color.b += flare3*0.0f*flaremultB;
 
               
               
               
         //Far blue flare MAIN 2
           vec2 flare3Cscale = vec2(3.2f*flarescale, 3.2f*flarescale);
           float flare3Cpow = 1.4f;
           float flare3Cfill = 10.0f;
           float flare3Coffset = -0.0f;
         vec2 flare3Cpos = vec2(  ((1.0 - lPos.x)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *aspectRatio*flare3Cscale.x,  ((1.0 - lPos.y)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *flare3Cscale.y);
         
         
         float flare3C = distance(flare3Cpos, vec2(texcoord.s*aspectRatio*flare3Cscale.x, texcoord.t*flare3Cscale.y));
              flare3C = 0.5 - flare3C;
              flare3C = clamp(flare3C*flare3Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare3C = sin(flare3C*1.57075);
             
              flare3C = pow(flare3C, 1.1f);
             
              flare3C *= flare3Cpow;        
             
             
              //subtract from blue flare
              vec2 flare3Dscale = vec2(2.1f*flarescale, 2.1f*flarescale);
              float flare3Dpow = 2.7f;
              float flare3Dfill = 1.4f;
              float flare3Doffset = -0.05f;
            vec2 flare3Dpos = vec2(  ((1.0 - lPos.x)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *aspectRatio*flare3Dscale.x,  ((1.0 - lPos.y)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *flare3Dscale.y);
         
         
            float flare3D = distance(flare3Dpos, vec2(texcoord.s*aspectRatio*flare3Dscale.x, texcoord.t*flare3Dscale.y));
               flare3D = 0.5 - flare3D;
               flare3D = clamp(flare3D*flare3Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare3D = sin(flare3D*1.57075);
               flare3D = pow(flare3D, 0.9f);
             
               flare3D *= flare3Dpow;
             
            flare3C = clamp(flare3C - flare3D, 0.0, 10.0);
            flare3C *= sunmask;
             
                 color.r += flare3C*0.5f*flaremultR;
               color.g += flare3C*0.3f*flaremultG;
               color.b += flare3C*0.0f*flaremultB;                    
               
 
               
         //far small pink flare
           vec2 flare4scale = vec2(4.5f*flarescale, 4.5f*flarescale);
           float flare4pow = 0.3f;
           float flare4fill = 3.0f;
           float flare4offset = -0.1f;
         vec2 flare4pos = vec2(  ((1.0 - lPos.x)*(flare4offset + 1.0) - (flare4offset*0.5))  *aspectRatio*flare4scale.x,  ((1.0 - lPos.y)*(flare4offset + 1.0) - (flare4offset*0.5))  *flare4scale.y);
         
         
         float flare4 = distance(flare4pos, vec2(texcoord.s*aspectRatio*flare4scale.x, texcoord.t*flare4scale.y));
              flare4 = 0.5 - flare4;
              flare4 = clamp(flare4*flare4fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare4 = sin(flare4*1.57075);
              flare4 *= sunmask;
              flare4 = pow(flare4, 1.1f);
             
              flare4 *= flare4pow;
             
                 color.r += flare4*0.6f*flaremultR;
               color.g += flare4*0.0f*flaremultG;
               color.b += flare4*0.8f*flaremultB;                    
               
               
               
         //far small pink flare2
           vec2 flare4Bscale = vec2(7.5f*flarescale, 7.5f*flarescale);
           float flare4Bpow = 0.4f;
           float flare4Bfill = 2.0f;
           float flare4Boffset = 0.0f;
         vec2 flare4Bpos = vec2(  ((1.0 - lPos.x)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *aspectRatio*flare4Bscale.x,  ((1.0 - lPos.y)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *flare4Bscale.y);
         
         
         float flare4B = distance(flare4Bpos, vec2(texcoord.s*aspectRatio*flare4Bscale.x, texcoord.t*flare4Bscale.y));
              flare4B = 0.5 - flare4B;
              flare4B = clamp(flare4B*flare4Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare4B = sin(flare4B*1.57075);
              flare4B *= sunmask;
              flare4B = pow(flare4B, 1.1f);
             
              flare4B *= flare4Bpow;
             
                 color.r += flare4B*0.4f*flaremultR;
               color.g += flare4B*0.0f*flaremultG;
               color.b += flare4B*0.8f*flaremultB;                  
               
               
               
         //far small pink flare3
           vec2 flare4Cscale = vec2(37.5f*flarescale, 37.5f*flarescale);
           float flare4Cpow = 2.0f;
           float flare4Cfill = 2.0f;
           float flare4Coffset = -0.3f;
         vec2 flare4Cpos = vec2(  ((1.0 - lPos.x)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *aspectRatio*flare4Cscale.x,  ((1.0 - lPos.y)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *flare4Cscale.y);
         
         
         float flare4C = distance(flare4Cpos, vec2(texcoord.s*aspectRatio*flare4Cscale.x, texcoord.t*flare4Cscale.y));
              flare4C = 0.5 - flare4C;
              flare4C = clamp(flare4C*flare4Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare4C = sin(flare4C*1.57075);
              flare4C *= sunmask;
              flare4C = pow(flare4C, 1.1f);
             
              flare4C *= flare4Cpow;
             
                 color.r += flare4C*0.6f*flaremultR;
               color.g += flare4C*0.3f*flaremultG;
               color.b += flare4C*0.1f*flaremultB;                  
               
               
               
         //far small pink flare4
           vec2 flare4Dscale = vec2(67.5f*flarescale, 67.5f*flarescale);
           float flare4Dpow = 1.0f;
           float flare4Dfill = 2.0f;
           float flare4Doffset = -0.35f;
         vec2 flare4Dpos = vec2(  ((1.0 - lPos.x)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *aspectRatio*flare4Dscale.x,  ((1.0 - lPos.y)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *flare4Dscale.y);
         
         
         float flare4D = distance(flare4Dpos, vec2(texcoord.s*aspectRatio*flare4Dscale.x, texcoord.t*flare4Dscale.y));
              flare4D = 0.5 - flare4D;
              flare4D = clamp(flare4D*flare4Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare4D = sin(flare4D*1.57075);
              flare4D *= sunmask;
              flare4D = pow(flare4D, 1.1f);
             
              flare4D *= flare4Dpow;
             
                 color.r += flare4D*0.2f*flaremultR;
               color.g += flare4D*0.2f*flaremultG;
               color.b += flare4D*0.2f*flaremultB;                  
               
               
                       
         //far small pink flare5
           vec2 flare4Escale = vec2(60.5f*flarescale, 60.5f*flarescale);
           float flare4Epow = 1.0f;
           float flare4Efill = 3.0f;
           float flare4Eoffset = -0.3393f;
         vec2 flare4Epos = vec2(  ((1.0 - lPos.x)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *aspectRatio*flare4Escale.x,  ((1.0 - lPos.y)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *flare4Escale.y);
         
         
         float flare4E = distance(flare4Epos, vec2(texcoord.s*aspectRatio*flare4Escale.x, texcoord.t*flare4Escale.y));
              flare4E = 0.5 - flare4E;
              flare4E = clamp(flare4E*flare4Efill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare4E = sin(flare4E*1.57075);
              flare4E *= sunmask;
              flare4E = pow(flare4E, 1.1f);
             
              flare4E *= flare4Epow;
             
                 color.r += flare4E*0.2f*flaremultR;
               color.g += flare4E*0.2f*flaremultG;
               color.b += flare4E*0.0f*flaremultB;              
               
                       
       
               
 
           vec2 flare5scale = vec2(3.2f*flarescale , 3.2f*flarescale );
           float flare5pow = 13.4f;
           float flare5fill = 1.0f;
           float flare5offset = -2.0f;
         vec2 flare5pos = vec2(  ((1.0 - lPos.x)*(flare5offset + 1.0) - (flare5offset*0.5))  *aspectRatio*flare5scale.x,  ((1.0 - lPos.y)*(flare5offset + 1.0) - (flare5offset*0.5))  *flare5scale.y);
         
         
         float flare5 = distance(flare5pos, vec2(texcoord.s*aspectRatio*flare5scale.x, texcoord.t*flare5scale.y));
              flare5 = 0.5 - flare5;
              flare5 = clamp(flare5*flare5fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare5 *= sunmask;
              flare5 = pow(flare5, 1.9f);
             
              flare5 *= flare5pow;
             
                 color.r += flare5*0.9f*flaremultR;
               color.g += flare5*0.4f*flaremultG;
               color.b += flare5*0.1f*flaremultB;                  
               
               
               
               
               
         
               
         //close ring flare green
           vec2 flare6Bscale = vec2(1.1f*flarescale, 1.1f*flarescale);
           float flare6Bpow = 0.2f;
           float flare6Bfill = 5.0f;
           float flare6Boffset = -1.9f;
         vec2 flare6Bpos = vec2(  ((1.0 - lPos.x)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *aspectRatio*flare6Bscale.x,  ((1.0 - lPos.y)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *flare6Bscale.y);
         
         
         float flare6B = distance(flare6Bpos, vec2(texcoord.s*aspectRatio*flare6Bscale.x, texcoord.t*flare6Bscale.y));
              flare6B = 0.5 - flare6B;
              flare6B = clamp(flare6B*flare6Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare6B = pow(flare6B, 1.6f);
              flare6B = sin(flare6B*3.1415);
              flare6B *= sunmask;
 
             
              flare6B *= flare6Bpow;
             
                 color.r += flare6B*1.0f*flaremultR * (tempColor2.r);
               color.g += flare6B*0.4f*flaremultG * (tempColor2.r);
               color.b += flare6B*0.0f*flaremultB * (tempColor2.r);                  
               
               
         
         //close ring flare blue
           vec2 flare6Cscale = vec2(0.9f*flarescale, 0.9f*flarescale);
           float flare6Cpow = 0.3f;
           float flare6Cfill = 5.0f;
           float flare6Coffset = -1.9f;
         vec2 flare6Cpos = vec2(  ((1.0 - lPos.x)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *aspectRatio*flare6Cscale.x,  ((1.0 - lPos.y)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *flare6Cscale.y);
         
         
         float flare6C = distance(flare6Cpos, vec2(texcoord.s*aspectRatio*flare6Cscale.x, texcoord.t*flare6Cscale.y));
              flare6C = 0.5 - flare6C;
              flare6C = clamp(flare6C*flare6Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare6C = pow(flare6C, 1.8f);
              flare6C = sin(flare6C*3.1415);
              flare6C *= sunmask;
 
             
              flare6C *= flare6Cpow;
             
                 color.r += flare6C*0.5f*flaremultR * (tempColor2.r);
               color.g += flare6C*0.3f*flaremultG * (tempColor2.r);
               color.b += flare6C*0.0f*flaremultB * (tempColor2.r);                  
               
               
               
               
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
               
                           
                           //Edge blue strip 1
           vec2 flareEscale = vec2(0.2f*flarescale, 5.0f*flarescale);
           float flareEpow = 1.0f;
           float flareEfill = 2.0f;
           vec2 flareEoffset = vec2(0.0f);
         vec2 flareEpos = vec2(lPos.x*aspectRatio*flareEscale.x, lPos.y*flareEscale.y);
         
         
         float flareE = distance(flareEpos, vec2(texcoord.s*aspectRatio*flareEscale.x, texcoord.t*flareEscale.y));
              flareE = 0.5 - flareE;
              flareE = clamp(flareE*flareEfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flareE *= sunmask;
              flareE = pow(flareE, 1.4f);
             
              flareE *= flareEpow;
 
             
               color.r += flareE*1.0f*flaremultR;
               color.g += flareE*0.6f*flaremultG;
               color.b += flareE*0.0f*flaremultB;  
           
               
               
            //Center orange strip 1
           vec2 flare_strip1_scale = vec2(0.5f*flarescale, 40.0f*flarescale);
           float flare_strip1_pow = 0.25f;
           float flare_strip1_fill = 2.0f;
           float flare_strip1_offset = 0.0f;
         vec2 flare_strip1_pos = vec2(lPos.x*aspectRatio*flare_strip1_scale.x, lPos.y*flare_strip1_scale.y);
         
         
         float flare_strip1_ = distance(flare_strip1_pos, vec2(texcoord.s*aspectRatio*flare_strip1_scale.x, texcoord.t*flare_strip1_scale.y));
              flare_strip1_ = 0.5 - flare_strip1_;
              flare_strip1_ = clamp(flare_strip1_*flare_strip1_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare_strip1_ *= sunmask;
              flare_strip1_ = pow(flare_strip1_, 1.4f);
             
              flare_strip1_ *= flare_strip1_pow;
 
             
                 color.r += flare_strip1_*0.05f*flaremultR;
               color.g += flare_strip1_*0.03f*flaremultG;
               color.b += flare_strip1_*0.0f*flaremultB;  
               
               
               
            //Center orange strip 3
           vec2 flare_strip3_scale = vec2(0.4f*flarescale, 35.0f*flarescale);
           float flare_strip3_pow = 0.5f;
           float flare_strip3_fill = 10.0f;
           float flare_strip3_offset = 0.0f;
         vec2 flare_strip3_pos = vec2(lPos.x*aspectRatio*flare_strip3_scale.x, lPos.y*flare_strip3_scale.y);
         
         
         float flare_strip3_ = distance(flare_strip3_pos, vec2(texcoord.s*aspectRatio*flare_strip3_scale.x, texcoord.t*flare_strip3_scale.y));
              flare_strip3_ = 0.5 - flare_strip3_;
              flare_strip3_ = clamp(flare_strip3_*flare_strip3_fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare_strip3_ *= sunmask;
              flare_strip3_ = pow(flare_strip3_, 1.4f);
             
              flare_strip3_ *= flare_strip3_pow;
 
             
                 color.r += flare_strip3_*0.05f*flaremultR;
               color.g += flare_strip3_*0.03f*flaremultG;
               color.b += flare_strip3_*0.0f*flaremultB;  
 
                           
               //mid orange sweep
           vec2 flare_extra3scale = vec2(32.0f*flarescale, 32.0f*flarescale);
           float flare_extra3pow = 2.5f;
           float flare_extra3fill = 1.1f;
           float flare_extra3offset = -1.3f;
         vec2 flare_extra3pos = vec2(  ((1.0 - lPos.x)*(flare_extra3offset + 1.0) - (flare_extra3offset*0.5))  *aspectRatio*flare_extra3scale.x,  ((1.0 - lPos.y)*(flare_extra3offset + 1.0) - (flare_extra3offset*0.5))  *flare_extra3scale.y);
         
         
         float flare_extra3 = distance(flare_extra3pos, vec2(texcoord.s*aspectRatio*flare_extra3scale.x, texcoord.t*flare_extra3scale.y));
              flare_extra3 = 0.5 - flare_extra3;
              flare_extra3 = clamp(flare_extra3*flare_extra3fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare_extra3 = sin(flare_extra3*1.57075);
              flare_extra3 *= sunmask;
              flare_extra3 = pow(flare_extra3, 1.1f);
             
              flare_extra3 *= flare_extra3pow;        
             
             
              //subtract
              vec2 flare_extra3Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
              float flare_extra3Bpow = 1.5f;
              float flare_extra3Bfill = 1.0f;
              float flare_extra3Boffset = -0.77f;
            vec2 flare_extra3Bpos = vec2(  ((1.0 - lPos.x)*(flare_extra3Boffset + 1.0) - (flare_extra3Boffset*0.5))  *aspectRatio*flare_extra3Bscale.x,  ((1.0 - lPos.y)*(flare_extra3Boffset + 1.0) - (flare_extra3Boffset*0.5))  *flare_extra3Bscale.y);
         
         
            float flare_extra3B = distance(flare_extra3Bpos, vec2(texcoord.s*aspectRatio*flare_extra3Bscale.x, texcoord.t*flare_extra3Bscale.y));
               flare_extra3B = 0.5 - flare_extra3B;
               flare_extra3B = clamp(flare_extra3B*flare_extra3Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare_extra3B = sin(flare_extra3B*1.57075);
               flare_extra3B *= sunmask;
               flare_extra3B = pow(flare_extra3B, 0.9f);
             
               flare_extra3B *= flare_extra3Bpow;
             
            flare_extra3 = clamp(flare_extra3 - flare_extra3B, 0.0, 10.0);
             
             
                 color.r += flare_extra3*0.5f*flaremultR;
               color.g += flare_extra3*0.4f*flaremultG;
               color.b += flare_extra3*0.1f*flaremultB;  
               
 
               
                  //mid orange sweep
           vec2 flare_extra4scale = vec2(35.0f*flarescale, 35.0f*flarescale);
           float flare_extra4pow = 1.0f;
           float flare_extra4fill = 1.1f;
           float flare_extra4offset = -1.2f;
         vec2 flare_extra4pos = vec2(  ((1.0 - lPos.x)*(flare_extra4offset + 1.0) - (flare_extra4offset*0.5))  *aspectRatio*flare_extra4scale.x,  ((1.0 - lPos.y)*(flare_extra4offset + 1.0) - (flare_extra4offset*0.5))  *flare_extra4scale.y);
         
         
         float flare_extra4 = distance(flare_extra4pos, vec2(texcoord.s*aspectRatio*flare_extra4scale.x, texcoord.t*flare_extra4scale.y));
              flare_extra4 = 0.5 - flare_extra4;
              flare_extra4 = clamp(flare_extra4*flare_extra4fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare_extra4 = sin(flare_extra4*1.57075);
              flare_extra4 *= sunmask;
              flare_extra4 = pow(flare_extra4, 1.1f);
             
              flare_extra4 *= flare_extra4pow;        
             
             
              //subtract
              vec2 flare_extra4Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
              float flare_extra4Bpow = 1.5f;
              float flare_extra4Bfill = 1.0f;
              float flare_extra4Boffset = -0.77f;
            vec2 flare_extra4Bpos = vec2(  ((1.0 - lPos.x)*(flare_extra4Boffset + 1.0) - (flare_extra4Boffset*0.5))  *aspectRatio*flare_extra4Bscale.x,  ((1.0 - lPos.y)*(flare_extra4Boffset + 1.0) - (flare_extra4Boffset*0.5))  *flare_extra4Bscale.y);
         
         
            float flare_extra4B = distance(flare_extra4Bpos, vec2(texcoord.s*aspectRatio*flare_extra4Bscale.x, texcoord.t*flare_extra4Bscale.y));
               flare_extra4B = 0.5 - flare_extra4B;
               flare_extra4B = clamp(flare_extra4B*flare_extra4Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare_extra4B = sin(flare_extra4B*1.57075);
               flare_extra4B *= sunmask;
               flare_extra4B = pow(flare_extra4B, 0.9f);
             
               flare_extra4B *= flare_extra4Bpow;
             
            flare_extra4 = clamp(flare_extra4 - flare_extra4B, 0.0, 10.0);
             
             
                 color.r += flare_extra4*0.6f*flaremultR;
               color.g += flare_extra4*0.4f*flaremultG;
               color.b += flare_extra4*0.1f*flaremultB;  
               
               
               
               //mid orange sweep
           vec2 flare_extra5scale = vec2(25.0f*flarescale, 25.0f*flarescale);
           float flare_extra5pow = 4.0f;
           float flare_extra5fill = 1.1f;
           float flare_extra5offset = -0.9f;
         vec2 flare_extra5pos = vec2(  ((1.0 - lPos.x)*(flare_extra5offset + 1.0) - (flare_extra5offset*0.5))  *aspectRatio*flare_extra5scale.x,  ((1.0 - lPos.y)*(flare_extra5offset + 1.0) - (flare_extra5offset*0.5))  *flare_extra5scale.y);
         
         
         float flare_extra5 = distance(flare_extra5pos, vec2(texcoord.s*aspectRatio*flare_extra5scale.x, texcoord.t*flare_extra5scale.y));
              flare_extra5 = 0.5 - flare_extra5;
              flare_extra5 = clamp(flare_extra5*flare_extra5fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare_extra5 = sin(flare_extra5*1.57075);
              flare_extra5 *= sunmask;
              flare_extra5 = pow(flare_extra5, 1.1f);
             
              flare_extra5 *= flare_extra5pow;        
             
             
              //subtract
              vec2 flare_extra5Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
              float flare_extra5Bpow = 1.5f;
              float flare_extra5Bfill = 1.0f;
              float flare_extra5Boffset = -0.77f;
            vec2 flare_extra5Bpos = vec2(  ((1.0 - lPos.x)*(flare_extra5Boffset + 1.0) - (flare_extra5Boffset*0.5))  *aspectRatio*flare_extra5Bscale.x,  ((1.0 - lPos.y)*(flare_extra5Boffset + 1.0) - (flare_extra5Boffset*0.5))  *flare_extra5Bscale.y);
         
         
            float flare_extra5B = distance(flare_extra5Bpos, vec2(texcoord.s*aspectRatio*flare_extra5Bscale.x, texcoord.t*flare_extra5Bscale.y));
               flare_extra5B = 0.5 - flare_extra5B;
               flare_extra5B = clamp(flare_extra5B*flare_extra5Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare_extra5B = sin(flare_extra5B*1.57075);
               flare_extra5B *= sunmask;
               flare_extra5B = pow(flare_extra5B, 0.9f);
             
               flare_extra5B *= flare_extra5Bpow;
             
            flare_extra5 = clamp(flare_extra5 - flare_extra5B, 0.0, 10.0);
             
             
                 color.r += flare_extra5*0.5f*flaremultR;
               color.g += flare_extra5*0.3f*flaremultG;
               color.b += flare_extra5*0.0f*flaremultB;  
               
               
//////////////////////////////////////////////////////////////////////////////
 
           
         //far red glow
 
           vec2 flare7Bscale = vec2(0.2f*flarescale, 0.2f*flarescale);
           float flare7Bpow = 0.1f;
           float flare7Bfill = 2.0f;
           float flare7Boffset = 2.9f;
         vec2 flare7Bpos = vec2(  ((1.0 - lPos.x)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *aspectRatio*flare7Bscale.x,  ((1.0 - lPos.y)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *flare7Bscale.y);
         
         
         float flare7B = distance(flare7Bpos, vec2(texcoord.s*aspectRatio*flare7Bscale.x, texcoord.t*flare7Bscale.y));
              flare7B = 0.5 - flare7B;
              flare7B = clamp(flare7B*flare7Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare7B = pow(flare7B, 1.9f);
              flare7B = sin(flare7B*3.1415*0.5);
              flare7B *= sunmask;
 
             
              flare7B *= flare7Bpow;
             
                 color.r += flare7B*1.0f*flaremultR;
               color.g += flare7B*0.0f*flaremultG;
               color.b += flare7B*0.0f*flaremultB;  
         
         
         
         //Edge blue strip 1
           vec2 flare8scale = vec2(0.3f*flarescale, 40.5f*flarescale);
           float flare8pow = 0.5f;
           float flare8fill = 12.0f;
           float flare8offset = 1.0f;
         vec2 flare8pos = vec2(  ((1.0 - lPos.x)*(flare8offset + 1.0) - (flare8offset*0.5))  *aspectRatio*flare8scale.x,  ((lPos.y)*(flare8offset + 1.0) - (flare8offset*0.5))  *flare8scale.y);
         
         
         float flare8 = distance(flare8pos, vec2(texcoord.s*aspectRatio*flare8scale.x, texcoord.t*flare8scale.y));
              flare8 = 0.5 - flare8;
              flare8 = clamp(flare8*flare8fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare8 *= sunmask;
              flare8 = pow(flare8, 1.4f);
             
              flare8 *= flare8pow;
              flare8 *= edgemaskx;
             
                 color.r += flare8*0.0f*flaremultR;
               color.g += flare8*0.3f*flaremultG;
               color.b += flare8*0.8f*flaremultB;              
         
     
     
         //Edge blue strip 1
           vec2 flare9scale = vec2(0.2f*flarescale, 5.5f*flarescale);
           float flare9pow = 1.9f;
           float flare9fill = 2.0f;
           vec2 flare9offset = vec2(1.0f, 0.0f);
         vec2 flare9pos = vec2(  ((1.0 - lPos.x)*(flare9offset.x + 1.0) - (flare9offset.x*0.5))  *aspectRatio*flare9scale.x,  ((1.0 - lPos.y)*(flare9offset.y + 1.0) - (flare9offset.y*0.5))  *flare9scale.y);
         
         
         float flare9 = distance(flare9pos, vec2(texcoord.s*aspectRatio*flare9scale.x, texcoord.t*flare9scale.y));
              flare9 = 0.5 - flare9;
              flare9 = clamp(flare9*flare9fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare9 *= sunmask;
              flare9 = pow(flare9, 1.4f);
             
              flare9 *= flare9pow;
              flare9 *= edgemaskx;
             
                 color.r += flare9*0.2f*flaremultR;
               color.g += flare9*0.4f*flaremultG;
               color.b += flare9*0.9f*flaremultB;  
               
               
               
      //SMALL SWEEPS      ///////////////////////////////                  
               
               
         //mid orange sweep
           vec2 flare10scale = vec2(6.0f*flarescale, 6.0f*flarescale);
           float flare10pow = 1.9f;
           float flare10fill = 1.1f;
           float flare10offset = -0.7f;
         vec2 flare10pos = vec2(  ((1.0 - lPos.x)*(flare10offset + 1.0) - (flare10offset*0.5))  *aspectRatio*flare10scale.x,  ((1.0 - lPos.y)*(flare10offset + 1.0) - (flare10offset*0.5))  *flare10scale.y);
         
         
         float flare10 = distance(flare10pos, vec2(texcoord.s*aspectRatio*flare10scale.x, texcoord.t*flare10scale.y));
              flare10 = 0.5 - flare10;
              flare10 = clamp(flare10*flare10fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare10 = sin(flare10*1.57075);
              flare10 *= sunmask;
              flare10 = pow(flare10, 1.1f);
             
              flare10 *= flare10pow;        
             
             
              //subtract
              vec2 flare10Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
              float flare10Bpow = 1.5f;
              float flare10Bfill = 1.0f;
              float flare10Boffset = -0.77f;
            vec2 flare10Bpos = vec2(  ((1.0 - lPos.x)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *aspectRatio*flare10Bscale.x,  ((1.0 - lPos.y)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *flare10Bscale.y);
         
         
            float flare10B = distance(flare10Bpos, vec2(texcoord.s*aspectRatio*flare10Bscale.x, texcoord.t*flare10Bscale.y));
               flare10B = 0.5 - flare10B;
               flare10B = clamp(flare10B*flare10Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare10B = sin(flare10B*1.57075);
               flare10B *= sunmask;
               flare10B = pow(flare10B, 0.9f);
             
               flare10B *= flare10Bpow;
             
            flare10 = clamp(flare10 - flare10B, 0.0, 10.0);
             
             
                 color.r += flare10*0.5f*flaremultR;
               color.g += flare10*0.3f*flaremultG;
               color.b += flare10*0.0f*flaremultB;            
               
               
         //mid blue sweep
           vec2 flare10Cscale = vec2(6.0f*flarescale, 6.0f*flarescale);
           float flare10Cpow = 1.9f;
           float flare10Cfill = 1.1f;
           float flare10Coffset = -0.6f;
         vec2 flare10Cpos = vec2(  ((1.0 - lPos.x)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *aspectRatio*flare10Cscale.x,  ((1.0 - lPos.y)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *flare10Cscale.y);
         
         
         float flare10C = distance(flare10Cpos, vec2(texcoord.s*aspectRatio*flare10Cscale.x, texcoord.t*flare10Cscale.y));
              flare10C = 0.5 - flare10C;
              flare10C = clamp(flare10C*flare10Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare10C = sin(flare10C*1.57075);
              flare10C *= sunmask;
              flare10C = pow(flare10C, 1.1f);
             
              flare10C *= flare10Cpow;        
             
             
              //subtract
              vec2 flare10Dscale = vec2(5.1f*flarescale, 5.1f*flarescale);
              float flare10Dpow = 1.5f;
              float flare10Dfill = 1.0f;
              float flare10Doffset = -0.67f;
            vec2 flare10Dpos = vec2(  ((1.0 - lPos.x)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *aspectRatio*flare10Dscale.x,  ((1.0 - lPos.y)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *flare10Dscale.y);
         
         
            float flare10D = distance(flare10Dpos, vec2(texcoord.s*aspectRatio*flare10Dscale.x, texcoord.t*flare10Dscale.y));
               flare10D = 0.5 - flare10D;
               flare10D = clamp(flare10D*flare10Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
               flare10D = sin(flare10D*1.57075);
               flare10D *= sunmask;
               flare10D = pow(flare10D, 0.9f);
             
               flare10D *= flare10Dpow;
             
            flare10C = clamp(flare10C - flare10D, 0.0, 10.0);
             
             
                 color.r += flare10C*0.5f*flaremultR;
               color.g += flare10C*0.3f*flaremultG;
               color.b += flare10C*0.0f*flaremultB;  
      //////////////////////////////////////////////////////////
     
     
     
     
     
      //Pointy fuzzy glow dots////////////////////////////////////////////////
         //RedGlow1
 
           vec2 flare11scale = vec2(1.5f*flarescale, 1.5f*flarescale);
           float flare11pow = 1.1f;
           float flare11fill = 2.0f;
           float flare11offset = -0.523f;
         vec2 flare11pos = vec2(  ((1.0 - lPos.x)*(flare11offset + 1.0) - (flare11offset*0.5))  *aspectRatio*flare11scale.x,  ((1.0 - lPos.y)*(flare11offset + 1.0) - (flare11offset*0.5))  *flare11scale.y);
         
         
         float flare11 = distance(flare11pos, vec2(texcoord.s*aspectRatio*flare11scale.x, texcoord.t*flare11scale.y));
              flare11 = 0.5 - flare11;
              flare11 = clamp(flare11*flare11fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare11 = pow(flare11, 2.9f);
              flare11 *= sunmask;
 
             
              flare11 *= flare11pow;
             
                 color.r += flare11*1.0f*flaremultR;
               color.g += flare11*0.2f*flaremultG;
               color.b += flare11*0.0f*flaremultB;      
               
               
         //PurpleGlow2
 
           vec2 flare12scale = vec2(2.5f*flarescale, 2.5f*flarescale);
           float flare12pow = 0.5f;
           float flare12fill = 2.0f;
           float flare12offset = -0.323f;
         vec2 flare12pos = vec2(  ((1.0 - lPos.x)*(flare12offset + 1.0) - (flare12offset*0.5))  *aspectRatio*flare12scale.x,  ((1.0 - lPos.y)*(flare12offset + 1.0) - (flare12offset*0.5))  *flare12scale.y);
         
         
         float flare12 = distance(flare12pos, vec2(texcoord.s*aspectRatio*flare12scale.x, texcoord.t*flare12scale.y));
              flare12 = 0.5 - flare12;
              flare12 = clamp(flare12*flare12fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare12 = pow(flare12, 2.9f);
              flare12 *= sunmask;
 
             
              flare12 *= flare12pow;
             
                 color.r += flare12*0.7f*flaremultR;
               color.g += flare12*0.3f*flaremultG;
               color.b += flare12*0.0f*flaremultB;      
               
               
               
         //BlueGlow3
 
           vec2 flare13scale = vec2(1.0f*flarescale, 1.0f*flarescale);
           float flare13pow = 1.5f;
           float flare13fill = 2.0f;
           float flare13offset = +0.138f;
         vec2 flare13pos = vec2(  ((1.0 - lPos.x)*(flare13offset + 1.0) - (flare13offset*0.5))  *aspectRatio*flare13scale.x,  ((1.0 - lPos.y)*(flare13offset + 1.0) - (flare13offset*0.5))  *flare13scale.y);
         
         
         float flare13 = distance(flare13pos, vec2(texcoord.s*aspectRatio*flare13scale.x, texcoord.t*flare13scale.y));
              flare13 = 0.5 - flare13;
              flare13 = clamp(flare13*flare13fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
              flare13 = pow(flare13, 2.9f);
              flare13 *= sunmask;
 
             
              flare13 *= flare13pow;
             
                 color.r += flare13*0.5f*flaremultR;
               color.g += flare13*0.3f*flaremultG;
               color.b += flare13*0.0f*flaremultB;      
               
         
 
			   	//--//far rings around the sun//--//	
		

		#ifdef ATOM_LENS
	//far red ring
			  vec2 flare4ARscale = vec2(6.0f*flarescale, 3.0f*flarescale);
			  float flare4ARpow = 1.0f;
			  float flare4ARfill = 10.0f;
			  float flare4ARoffset = -2.0f;
			vec2 flare4ARpos = vec2(  ((1.0 - lPos.x)*(flare4ARoffset + 1.0) - (flare4ARoffset*0.5))  *aspectRatio*flare4ARscale.x,  ((1.0 - lPos.y)*(flare4ARoffset + 1.0) - (flare4ARoffset*0.5))  *flare4ARscale.y);
			
			
			float flare4AR = distance(flare4ARpos, vec2(texcoord.s*aspectRatio*flare4ARscale.x, texcoord.t*flare4ARscale.y));
				  flare4AR = 0.5 - flare4AR;
				  flare4AR = clamp(flare4AR*flare4ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4AR = pow(flare4AR, 1.6f);
				  flare4AR = sin(flare4AR*3.1415);
				  flare4AR *= sunmask;

				  
				  flare4AR *= flare4ARpow;
				  
				  	color.r += flare4AR*0.4f*flaremultR;
					color.g += flare4AR*0.0f*flaremultG;
					color.b += flare4AR*0.0f*flaremultB;


	//far blue ring

			  vec2 flare9ARscale = vec2(3.0f*flarescale, 6.0*flarescale);
			  float flare9ARpow = 1.0f;
			  float flare9ARfill = 10.0f;
			  float flare9ARoffset = -2.0f;
			vec2 flare9ARpos = vec2(  ((1.0 - lPos.x)*(flare9ARoffset + 1.0) - (flare9ARoffset*0.5))  *aspectRatio*flare9ARscale.x,  ((1.0 - lPos.y)*(flare9ARoffset + 1.0) - (flare9ARoffset*0.5))  *flare9ARscale.y);
			
			
			float flare9AR = distance(flare9ARpos, vec2(texcoord.s*aspectRatio*flare9ARscale.x, texcoord.t*flare9ARscale.y));
				  flare9AR = 0.5 - flare9AR;
				  flare9AR = clamp(flare9AR*flare9ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare9AR = pow(flare9AR, 1.9f);
				  flare9AR = sin(flare9AR*3.1415);
				  flare9AR *= sunmask;

				  
				  flare9AR *= flare9ARpow;
				  
				  	color.r += flare9AR*1.0f*flaremultR;
					color.g += flare9AR*0.0f*flaremultG;
					color.b += flare9AR*0.4*flaremultB;
					
			     
       #endif
			   
			   
			   


	
	//-//end of the flares//-//
			}
}





#endif

#ifdef GLARE

	color = color * 1.0;
	
	float radius = 0.002*GLARE_OFFSET;
	float radiusv = 0.002;
	float bloomintensity = 0.1*GLARE_INTENSITY;
	
	vec4 clr = vec4(0.0);
	
	clr += texture2D(composite, texcoord.st);
	
	
	
	clr += texture2D(composite, texcoord.st + (vec2(10.0,0.0))*radius)*10.0;
	clr += texture2D(composite, texcoord.st + (vec2(9.0,0.0))*radius)*11.0;
	clr += texture2D(composite, texcoord.st + (vec2(8.0,0.0))*radius)*12.0;
	clr += texture2D(composite, texcoord.st + (vec2(7.0,0.0))*radius)*13.0;
	clr += texture2D(composite, texcoord.st + (vec2(6.0,0.0))*radius)*14.0;
	clr += texture2D(composite, texcoord.st + (vec2(5.0,0.0))*radius)*15.0;
	clr += texture2D(composite, texcoord.st + (vec2(4.0,0.0))*radius)*16.0;
	clr += texture2D(composite, texcoord.st + (vec2(3.0,0.0))*radius)*17.0;
	clr += texture2D(composite, texcoord.st + (vec2(2.0,0.0))*radius)*18.0;
	clr += texture2D(composite, texcoord.st + (vec2(1.0,0.0))*radius)*19.0;
	
	clr += texture2D(composite, texcoord.st + (vec2(0.0,0.0))*radius)*20.0;
		
	clr += texture2D(composite, texcoord.st + (vec2(-1.0,0.0))*radius)*19.0;
	clr += texture2D(composite, texcoord.st + (vec2(-2.0,0.0))*radius)*18.0;
	clr += texture2D(composite, texcoord.st + (vec2(-3.0,0.0))*radius)*17.0;
	clr += texture2D(composite, texcoord.st + (vec2(-4.0,0.0))*radius)*16.0;
	clr += texture2D(composite, texcoord.st + (vec2(-5.0,0.0))*radius)*15.0;
	clr += texture2D(composite, texcoord.st + (vec2(-6.0,0.0))*radius)*14.0;
	clr += texture2D(composite, texcoord.st + (vec2(-7.0,0.0))*radius)*13.0;
	clr += texture2D(composite, texcoord.st + (vec2(-8.0,0.0))*radius)*12.0;
	clr += texture2D(composite, texcoord.st + (vec2(-9.0,0.0))*radius)*11.0;
	clr += texture2D(composite, texcoord.st + (vec2(-10.0,0.0))*radius)*10.0;
	

	clr += texture2D(composite, texcoord.st + (vec2(0.0,10.0))*radius)*10.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,9.0))*radius)*11.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,8.0))*radius)*12.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,7.0))*radius)*13.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,6.0))*radius)*14.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,5.0))*radius)*15.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,4.0))*radius)*16.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,3.0))*radius)*17.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,2.0))*radius)*18.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,1.0))*radius)*19.0;
	
	
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-10.0))*radius)*10.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-9.0))*radius)*11.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-8.0))*radius)*12.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-7.0))*radius)*13.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-6.0))*radius)*14.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-5.0))*radius)*15.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-4.0))*radius)*16.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-3.0))*radius)*17.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-2.0))*radius)*18.0;
	clr += texture2D(composite, texcoord.st + (vec2(0.0,-1.0))*radius)*19.0;
	

	
	clr = (clr/20.0)/5.0;
	clr.r = pow(clr.r, 1.2)*1.6 - (clr.g + clr.b)*0.6;
	clr.g = pow(clr.g, 1.2)*1.6 - (clr.r + clr.b)*0.6;
	clr.b = pow(clr.b, 1.2)*1.9 - (clr.r + clr.g)*0.9;
	
	clr = clamp((clr), 0.0, 1.0);
	
	color.r = color.r + (clr.r*1.5)*bloomintensity;
	color.g = color.g + (clr.g*1.5)*bloomintensity;
	color.b = color.b + (clr.b*4.0)*bloomintensity;
	color = max(color, 0.0);
	//color = color*1.05 - 0.05;
	
	

#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 0.9 - dv;

dv = pow(dv, 0.25);

dv *= 2.3;
dv -= 0.9;

color *= dv;
#endif

color = color * BRIGHTMULT;

#ifdef CROSSPROCESS
	//pre-gain
	color = color * (BRIGHTMULT + 0.0f) + 0.03f;
	
 
	//calculate double curve
	float dbr = -color.r + 1.4f;
	float dbg = -color.g + 1.4f;
	float dbb = -color.b + 1.4f;
	
	//fade between simple gamma up curve and double curve
	float pr = mix(dbr, 0.55f, 0.7f);
	float pg = mix(dbg, 0.55f, 0.7f);
	float pb = mix(dbb, 0.55f, 0.7f);
	
	color.r = pow((color.r * 0.95f - 0.005f), pr);
	color.g = pow((color.g * 0.95f - 0.002f), pg);
	color.b = pow((color.b * 0.91f + 0.000f), pb);
#endif

	//Color boosting
	color.r = (color.r)*(COLOR_BOOST + 1.0) + (color.g + color.b)*(-COLOR_BOOST);
	color.g = (color.g)*(COLOR_BOOST + 1.0) + (color.r + color.b)*(-COLOR_BOOST);
	color.b = (color.b)*(COLOR_BOOST + 1.0) + (color.r + color.g)*(-COLOR_BOOST);

#ifdef HIGHDESATURATE


	//average
	float rgb = max(color.r, max(color.g, color.b))/2 + min(color.r, min(color.g, color.b));

	//adjust black and white image to be brighter
	float bw = pow(rgb, 0.7);

	//mix between per-channel analysis and average analysis
	float rgbr = mix(rgb, color.r, 0.7);
	float rgbg = mix(rgb, color.g, 0.7);
	float rgbb = mix(rgb, color.b, 0.7);

	//calculate crossfade based on lum
	float mixfactorr = max(1.0, (rgbr*2 - 1));
	float mixfactorg = max(1.0, (rgbg*2 - 1));
	float mixfactorb = max(1.0, (rgbb*2 - 1));

	//crossfade between saturated and desaturated image
	float mixr = mix(color.r, bw, mixfactorr);
	float mixg = mix(color.g, bw, mixfactorg);
	float mixb = mix(color.b, bw, mixfactorb);
	
	//desaturate blue channel
	color.b = color.b*0.6 + ((color.r + color.g)/2.0)*0.2;

	color.r = pow(color.r, GAMMA);
	color.g = pow(color.g, GAMMA);
	color.b = pow(color.b, GAMMA);
	
	color = color*(1.0 + DARKMULT) - DARKMULT;
	
	
#endif

#ifdef COLOR_CORRECTION
	color.r = clamp(color.r, 0.04, 1.0);
	color.b = clamp(color.b, 0.1, 0.89);
	
	//Color changes depends on time//
	color.rgb -= color.rgb*0.05*TimeSunrise;
	color.rgb += color.rgb*0.05*TimeNoon;
	color.rgb -= color.rgb*0.05*TimeSunset;
	color.rgb -= color.rgb*0.05*TimeMidnight;
	
	color.b += color.b*0.1*TimeNoon;
	color.r -= color.r*0.1*TimeNoon;
	
	color.b += color.b*0.1*TimeSunrise;
	color.g += color.g*0.05*TimeSunrise;
	color.r += color.r*0.05*TimeSunrise;
	
	color.b += color.b*0.1*TimeSunset;
	color.g += color.g*0.05*TimeSunset;
	color.r += color.r*0.05*TimeSunset;
	
	color.b += color.b*0.1*TimeMidnight;
	color.g += color.g*0.1*TimeMidnight;
		
#endif


color = clamp(color,0.0,1.0);

float white = luma(color);
color = color*(1.0+pow(white,CONTRAST))/(2.0-CONTRAST);

color = pow(color,vec3(2.2));
#ifdef TONEMAP

color = color / (color + TONEMAP_CURVE) * (2.0+TONEMAP_CURVE);

#endif

color = pow(color,vec3(1.0));
color = color * 0.7;

	color.r = color.r*0.9;
    color.g = color.g*0.9; 
    color.b = color.b*0.9;	

	gl_FragColor = vec4(color,1.0);
	
}
